/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItem;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionSummaryItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryDeletionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryDeletionSummary> {
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(InventoryDeletionSummary.getter(InventoryDeletionSummary::totalCount)).setter(InventoryDeletionSummary.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final SdkField<Integer> REMAINING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RemainingCount").getter(InventoryDeletionSummary.getter(InventoryDeletionSummary::remainingCount)).setter(InventoryDeletionSummary.setter(Builder::remainingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingCount").build()}).build();
    private static final SdkField<List<InventoryDeletionSummaryItem>> SUMMARY_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SummaryItems").getter(InventoryDeletionSummary.getter(InventoryDeletionSummary::summaryItems)).setter(InventoryDeletionSummary.setter(Builder::summaryItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryDeletionSummaryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COUNT_FIELD, REMAINING_COUNT_FIELD, SUMMARY_ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalCount;
    private final Integer remainingCount;
    private final List<InventoryDeletionSummaryItem> summaryItems;

    private InventoryDeletionSummary(BuilderImpl builder) {
        this.totalCount = builder.totalCount;
        this.remainingCount = builder.remainingCount;
        this.summaryItems = builder.summaryItems;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public final Integer remainingCount() {
        return this.remainingCount;
    }

    public final boolean hasSummaryItems() {
        return this.summaryItems != null && !(this.summaryItems instanceof SdkAutoConstructList);
    }

    public final List<InventoryDeletionSummaryItem> summaryItems() {
        return this.summaryItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryItems() ? this.summaryItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDeletionSummary)) {
            return false;
        }
        InventoryDeletionSummary other = (InventoryDeletionSummary)obj;
        return Objects.equals(this.totalCount(), other.totalCount()) && Objects.equals(this.remainingCount(), other.remainingCount()) && this.hasSummaryItems() == other.hasSummaryItems() && Objects.equals(this.summaryItems(), other.summaryItems());
    }

    public final String toString() {
        return ToString.builder((String)"InventoryDeletionSummary").add("TotalCount", (Object)this.totalCount()).add("RemainingCount", (Object)this.remainingCount()).add("SummaryItems", this.hasSummaryItems() ? this.summaryItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
            case "RemainingCount": {
                return Optional.ofNullable(clazz.cast(this.remainingCount()));
            }
            case "SummaryItems": {
                return Optional.ofNullable(clazz.cast(this.summaryItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryDeletionSummary, T> g) {
        return obj -> g.apply((InventoryDeletionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalCount;
        private Integer remainingCount;
        private List<InventoryDeletionSummaryItem> summaryItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDeletionSummary model) {
            this.totalCount(model.totalCount);
            this.remainingCount(model.remainingCount);
            this.summaryItems(model.summaryItems);
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public final Integer getRemainingCount() {
            return this.remainingCount;
        }

        @Override
        public final Builder remainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
            return this;
        }

        public final void setRemainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
        }

        public final List<InventoryDeletionSummaryItem.Builder> getSummaryItems() {
            List<InventoryDeletionSummaryItem.Builder> result = InventoryDeletionSummaryItemsCopier.copyToBuilder(this.summaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder summaryItems(Collection<InventoryDeletionSummaryItem> summaryItems) {
            this.summaryItems = InventoryDeletionSummaryItemsCopier.copy(summaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(InventoryDeletionSummaryItem ... summaryItems) {
            this.summaryItems(Arrays.asList(summaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(Consumer<InventoryDeletionSummaryItem.Builder> ... summaryItems) {
            this.summaryItems(Stream.of(summaryItems).map(c -> (InventoryDeletionSummaryItem)((InventoryDeletionSummaryItem.Builder)InventoryDeletionSummaryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaryItems(Collection<InventoryDeletionSummaryItem.BuilderImpl> summaryItems) {
            this.summaryItems = InventoryDeletionSummaryItemsCopier.copyFromBuilder(summaryItems);
        }

        public InventoryDeletionSummary build() {
            return new InventoryDeletionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryDeletionSummary> {
        public Builder totalCount(Integer var1);

        public Builder remainingCount(Integer var1);

        public Builder summaryItems(Collection<InventoryDeletionSummaryItem> var1);

        public Builder summaryItems(InventoryDeletionSummaryItem ... var1);

        public Builder summaryItems(Consumer<InventoryDeletionSummaryItem.Builder> ... var1);
    }
}

