/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSessionResponse extends SsmResponse implements
        ToCopyableBuilder<StartSessionResponse.Builder, StartSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(StartSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> TOKEN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenValue").getter(getter(StartSessionResponse::tokenValue)).setter(setter(Builder::tokenValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenValue").build()).build();

    private static final SdkField<String> STREAM_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamUrl").getter(getter(StartSessionResponse::streamUrl)).setter(setter(Builder::streamUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            TOKEN_VALUE_FIELD, STREAM_URL_FIELD));

    private final String sessionId;

    private final String tokenValue;

    private final String streamUrl;

    private StartSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.tokenValue = builder.tokenValue;
        this.streamUrl = builder.streamUrl;
    }

    /**
     * <p>
     * The ID of the session.
     * </p>
     * 
     * @return The ID of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * An encrypted token value containing session and caller information. Used to authenticate the connection to the
     * managed node.
     * </p>
     * 
     * @return An encrypted token value containing session and caller information. Used to authenticate the connection
     *         to the managed node.
     */
    public final String tokenValue() {
        return tokenValue;
    }

    /**
     * <p>
     * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive
     * output from the node. Format:
     * <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>
     * </p>
     * <p>
     * <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services
     * Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of supported
     * <b>region</b> values, see the <b>Region</b> column in <a
     * href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints</a> in
     * the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.
     * </p>
     * 
     * @return A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and
     *         receive output from the node. Format:
     *         <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>
     *         </p>
     *         <p>
     *         <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web
     *         Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of
     *         supported <b>region</b> values, see the <b>Region</b> column in <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service
     *         endpoints</a> in the <i>Amazon Web Services General Reference</i>.
     *         </p>
     *         <p>
     *         <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.
     */
    public final String streamUrl() {
        return streamUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenValue());
        hashCode = 31 * hashCode + Objects.hashCode(streamUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionResponse)) {
            return false;
        }
        StartSessionResponse other = (StartSessionResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(tokenValue(), other.tokenValue())
                && Objects.equals(streamUrl(), other.streamUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSessionResponse").add("SessionId", sessionId()).add("TokenValue", tokenValue())
                .add("StreamUrl", streamUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "TokenValue":
            return Optional.ofNullable(clazz.cast(tokenValue()));
        case "StreamUrl":
            return Optional.ofNullable(clazz.cast(streamUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSessionResponse, T> g) {
        return obj -> g.apply((StartSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSessionResponse> {
        /**
         * <p>
         * The ID of the session.
         * </p>
         * 
         * @param sessionId
         *        The ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * An encrypted token value containing session and caller information. Used to authenticate the connection to
         * the managed node.
         * </p>
         * 
         * @param tokenValue
         *        An encrypted token value containing session and caller information. Used to authenticate the
         *        connection to the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenValue(String tokenValue);

        /**
         * <p>
         * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive
         * output from the node. Format:
         * <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>
         * </p>
         * <p>
         * <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon Web
         * Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list of
         * supported <b>region</b> values, see the <b>Region</b> column in <a
         * href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service
         * endpoints</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * <p>
         * <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.
         * </p>
         * 
         * @param streamUrl
         *        A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and
         *        receive output from the node. Format:
         *        <code>wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)</code>
         *        </p>
         *        <p>
         *        <b>region</b> represents the Region identifier for an Amazon Web Services Region supported by Amazon
         *        Web Services Systems Manager, such as <code>us-east-2</code> for the US East (Ohio) Region. For a list
         *        of supported <b>region</b> values, see the <b>Region</b> column in <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service
         *        endpoints</a> in the <i>Amazon Web Services General Reference</i>.
         *        </p>
         *        <p>
         *        <b>session-id</b> represents the ID of a Session Manager session, such as <code>1a2b3c4dEXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamUrl(String streamUrl);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String tokenValue;

        private String streamUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionResponse model) {
            super(model);
            sessionId(model.sessionId);
            tokenValue(model.tokenValue);
            streamUrl(model.streamUrl);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTokenValue() {
            return tokenValue;
        }

        public final void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        @Override
        @Transient
        public final Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public final String getStreamUrl() {
            return streamUrl;
        }

        public final void setStreamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
        }

        @Override
        @Transient
        public final Builder streamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        @Override
        public StartSessionResponse build() {
            return new StartSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
