/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PatchFilterKey {
    ARCH("ARCH"),
    ADVISORY_ID("ADVISORY_ID"),
    BUGZILLA_ID("BUGZILLA_ID"),
    PATCH_SET("PATCH_SET"),
    PRODUCT("PRODUCT"),
    PRODUCT_FAMILY("PRODUCT_FAMILY"),
    CLASSIFICATION("CLASSIFICATION"),
    CVE_ID("CVE_ID"),
    EPOCH("EPOCH"),
    MSRC_SEVERITY("MSRC_SEVERITY"),
    NAME("NAME"),
    PATCH_ID("PATCH_ID"),
    SECTION("SECTION"),
    PRIORITY("PRIORITY"),
    REPOSITORY("REPOSITORY"),
    RELEASE("RELEASE"),
    SEVERITY("SEVERITY"),
    SECURITY("SECURITY"),
    VERSION("VERSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PatchFilterKey> VALUE_MAP;
    private final String value;

    private PatchFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PatchFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PatchFilterKey> knownValues() {
        EnumSet<PatchFilterKey> knownValues = EnumSet.allOf(PatchFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PatchFilterKey.class, PatchFilterKey::toString);
    }
}

