/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncS3Destination;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncSource;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceDataSyncRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, CreateResourceDataSyncRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncName").getter(CreateResourceDataSyncRequest.getter(CreateResourceDataSyncRequest::syncName)).setter(CreateResourceDataSyncRequest.setter(Builder::syncName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()}).build();
    private static final SdkField<ResourceDataSyncS3Destination> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Destination").getter(CreateResourceDataSyncRequest.getter(CreateResourceDataSyncRequest::s3Destination)).setter(CreateResourceDataSyncRequest.setter(Builder::s3Destination)).constructor(ResourceDataSyncS3Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destination").build()}).build();
    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncType").getter(CreateResourceDataSyncRequest.getter(CreateResourceDataSyncRequest::syncType)).setter(CreateResourceDataSyncRequest.setter(Builder::syncType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()}).build();
    private static final SdkField<ResourceDataSyncSource> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SyncSource").getter(CreateResourceDataSyncRequest.getter(CreateResourceDataSyncRequest::syncSource)).setter(CreateResourceDataSyncRequest.setter(Builder::syncSource)).constructor(ResourceDataSyncSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD, S3_DESTINATION_FIELD, SYNC_TYPE_FIELD, SYNC_SOURCE_FIELD));
    private final String syncName;
    private final ResourceDataSyncS3Destination s3Destination;
    private final String syncType;
    private final ResourceDataSyncSource syncSource;

    private CreateResourceDataSyncRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
        this.syncType = builder.syncType;
        this.syncSource = builder.syncSource;
    }

    public final String syncName() {
        return this.syncName;
    }

    public final ResourceDataSyncS3Destination s3Destination() {
        return this.s3Destination;
    }

    public final String syncType() {
        return this.syncType;
    }

    public final ResourceDataSyncSource syncSource() {
        return this.syncSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.syncName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncType());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDataSyncRequest)) {
            return false;
        }
        CreateResourceDataSyncRequest other = (CreateResourceDataSyncRequest)((Object)obj);
        return Objects.equals(this.syncName(), other.syncName()) && Objects.equals(this.s3Destination(), other.s3Destination()) && Objects.equals(this.syncType(), other.syncType()) && Objects.equals(this.syncSource(), other.syncSource());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceDataSyncRequest").add("SyncName", (Object)this.syncName()).add("S3Destination", (Object)this.s3Destination()).add("SyncType", (Object)this.syncType()).add("SyncSource", (Object)this.syncSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncName": {
                return Optional.ofNullable(clazz.cast(this.syncName()));
            }
            case "S3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
            case "SyncType": {
                return Optional.ofNullable(clazz.cast(this.syncType()));
            }
            case "SyncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceDataSyncRequest, T> g) {
        return obj -> g.apply((CreateResourceDataSyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String syncName;
        private ResourceDataSyncS3Destination s3Destination;
        private String syncType;
        private ResourceDataSyncSource syncSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDataSyncRequest model) {
            super(model);
            this.syncName(model.syncName);
            this.s3Destination(model.s3Destination);
            this.syncType(model.syncType);
            this.syncSource(model.syncSource);
        }

        public final String getSyncName() {
            return this.syncName;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final String getSyncType() {
            return this.syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        public final ResourceDataSyncSource.Builder getSyncSource() {
            return this.syncSource != null ? this.syncSource.toBuilder() : null;
        }

        public final void setSyncSource(ResourceDataSyncSource.BuilderImpl syncSource) {
            this.syncSource = syncSource != null ? syncSource.build() : null;
        }

        @Override
        public final Builder syncSource(ResourceDataSyncSource syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceDataSyncRequest build() {
            return new CreateResourceDataSyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceDataSyncRequest> {
        public Builder syncName(String var1);

        public Builder s3Destination(ResourceDataSyncS3Destination var1);

        default public Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return this.s3Destination((ResourceDataSyncS3Destination)((ResourceDataSyncS3Destination.Builder)ResourceDataSyncS3Destination.builder().applyMutation(s3Destination)).build());
        }

        public Builder syncType(String var1);

        public Builder syncSource(ResourceDataSyncSource var1);

        default public Builder syncSource(Consumer<ResourceDataSyncSource.Builder> syncSource) {
            return this.syncSource((ResourceDataSyncSource)((ResourceDataSyncSource.Builder)ResourceDataSyncSource.builder().applyMutation(syncSource)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

