/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateActivationRequest extends SsmRequest implements
        ToCopyableBuilder<CreateActivationRequest.Builder, CreateActivationRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateActivationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultInstanceName").getter(getter(CreateActivationRequest::defaultInstanceName))
            .setter(setter(Builder::defaultInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceName").build())
            .build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRole").getter(getter(CreateActivationRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<Integer> REGISTRATION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RegistrationLimit").getter(getter(CreateActivationRequest::registrationLimit))
            .setter(setter(Builder::registrationLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationLimit").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate").getter(getter(CreateActivationRequest::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateActivationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RegistrationMetadataItem>> REGISTRATION_METADATA_FIELD = SdkField
            .<List<RegistrationMetadataItem>> builder(MarshallingType.LIST)
            .memberName("RegistrationMetadata")
            .getter(getter(CreateActivationRequest::registrationMetadata))
            .setter(setter(Builder::registrationMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrationMetadataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrationMetadataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DEFAULT_INSTANCE_NAME_FIELD, IAM_ROLE_FIELD, REGISTRATION_LIMIT_FIELD, EXPIRATION_DATE_FIELD, TAGS_FIELD,
            REGISTRATION_METADATA_FIELD));

    private final String description;

    private final String defaultInstanceName;

    private final String iamRole;

    private final Integer registrationLimit;

    private final Instant expirationDate;

    private final List<Tag> tags;

    private final List<RegistrationMetadataItem> registrationMetadata;

    private CreateActivationRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.expirationDate = builder.expirationDate;
        this.tags = builder.tags;
        this.registrationMetadata = builder.registrationMetadata;
    }

    /**
     * <p>
     * A user-defined description of the resource that you want to register with Systems Manager.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @return A user-defined description of the resource that you want to register with Systems Manager. </p>
     *         <important>
     *         <p>
     *         Don't enter personally identifiable information in this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console or
     * when you use the Amazon Web Services command line tools to list Systems Manager resources.
     * </p>
     * <important>
     * <p>
     * Don't enter personally identifiable information in this field.
     * </p>
     * </important>
     * 
     * @return The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager
     *         console or when you use the Amazon Web Services command line tools to list Systems Manager resources.</p>
     *         <important>
     *         <p>
     *         Don't enter personally identifiable information in this field.
     *         </p>
     */
    public final String defaultInstanceName() {
        return defaultInstanceName;
    }

    /**
     * <p>
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM
     * role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
     * <code>ssm.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
     * service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     * </p>
     * </note>
     * 
     * @return The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
     *         This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
     *         principal <code>ssm.amazonaws.com</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
     *         IAM service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.</p> <note>
     *         <p>
     *         You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     *         </p>
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     * </p>
     * 
     * @return Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
     */
    public final Integer registrationLimit() {
        return registrationLimit;
    }

    /**
     * <p>
     * The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00". You
     * can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code expires
     * in 24 hours.
     * </p>
     * 
     * @return The date by which this activation request should expire, in timestamp format, such as
     *         "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
     *         expiration date, the activation code expires in 24 hours.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag an activation to identify which servers
     * or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you could specify
     * the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When you
     * specify the activation ID and code, tags assigned to the activation are automatically applied to the on-premises
     * servers or VMs.
     * </p>
     * </important>
     * <p>
     * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
     * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
     * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed with
     * "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For information
     * about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *         ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
     *         identify which servers or virtual machines (VMs) in your on-premises environment you intend to activate.
     *         In this case, you could specify the following key-value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=OS,Value=Windows</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=Environment,Value=Production</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
     *         When you specify the activation ID and code, tags assigned to the activation are automatically applied to
     *         the on-premises servers or VMs.
     *         </p>
     *         </important>
     *         <p>
     *         You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers,
     *         edge devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed
     *         node ID. This means they are listed in the Amazon Web Services Systems Manager console with an ID that is
     *         prefixed with "mi-". For information about how to add tags to your managed nodes, see
     *         <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes, see
     *         <a>RemoveTagsFromResource</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistrationMetadata property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegistrationMetadata() {
        return registrationMetadata != null && !(registrationMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Reserved for internal use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistrationMetadata} method.
     * </p>
     * 
     * @return Reserved for internal use.
     */
    public final List<RegistrationMetadataItem> registrationMetadata() {
        return registrationMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistrationMetadata() ? registrationMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActivationRequest)) {
            return false;
        }
        CreateActivationRequest other = (CreateActivationRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(defaultInstanceName(), other.defaultInstanceName())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(registrationLimit(), other.registrationLimit())
                && Objects.equals(expirationDate(), other.expirationDate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasRegistrationMetadata() == other.hasRegistrationMetadata()
                && Objects.equals(registrationMetadata(), other.registrationMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateActivationRequest").add("Description", description())
                .add("DefaultInstanceName", defaultInstanceName()).add("IamRole", iamRole())
                .add("RegistrationLimit", registrationLimit()).add("ExpirationDate", expirationDate())
                .add("Tags", hasTags() ? tags() : null)
                .add("RegistrationMetadata", hasRegistrationMetadata() ? registrationMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultInstanceName":
            return Optional.ofNullable(clazz.cast(defaultInstanceName()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "RegistrationLimit":
            return Optional.ofNullable(clazz.cast(registrationLimit()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RegistrationMetadata":
            return Optional.ofNullable(clazz.cast(registrationMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateActivationRequest, T> g) {
        return obj -> g.apply((CreateActivationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateActivationRequest> {
        /**
         * <p>
         * A user-defined description of the resource that you want to register with Systems Manager.
         * </p>
         * <important>
         * <p>
         * Don't enter personally identifiable information in this field.
         * </p>
         * </important>
         * 
         * @param description
         *        A user-defined description of the resource that you want to register with Systems Manager. </p>
         *        <important>
         *        <p>
         *        Don't enter personally identifiable information in this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager console
         * or when you use the Amazon Web Services command line tools to list Systems Manager resources.
         * </p>
         * <important>
         * <p>
         * Don't enter personally identifiable information in this field.
         * </p>
         * </important>
         * 
         * @param defaultInstanceName
         *        The name of the registered, managed node as it will appear in the Amazon Web Services Systems Manager
         *        console or when you use the Amazon Web Services command line tools to list Systems Manager
         *        resources.</p> <important>
         *        <p>
         *        Don't enter personally identifiable information in this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceName(String defaultInstanceName);

        /**
         * <p>
         * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This
         * IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
         * <code>ssm.amazonaws.com</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an IAM
         * service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * <note>
         * <p>
         * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
         * </p>
         * </note>
         * 
         * @param iamRole
         *        The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
         *        This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
         *        principal <code>ssm.amazonaws.com</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-service-role.html">Create an
         *        IAM service role for a hybrid environment</a> in the <i>Amazon Web Services Systems Manager User
         *        Guide</i>.</p> <note>
         *        <p>
         *        You can't specify an IAM service-linked role for this parameter. You must create a unique role.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
         * </p>
         * 
         * @param registrationLimit
         *        Specify the maximum number of managed nodes you want to register. The default value is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationLimit(Integer registrationLimit);

        /**
         * <p>
         * The date by which this activation request should expire, in timestamp format, such as "2021-07-07T00:00:00".
         * You can specify a date up to 30 days in advance. If you don't provide an expiration date, the activation code
         * expires in 24 hours.
         * </p>
         * 
         * @param expirationDate
         *        The date by which this activation request should expire, in timestamp format, such as
         *        "2021-07-07T00:00:00". You can specify a date up to 30 days in advance. If you don't provide an
         *        expiration date, the activation code expires in 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which
         * servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you
         * could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When
         * you specify the activation ID and code, tags assigned to the activation are automatically applied to the
         * on-premises servers or VMs.
         * </p>
         * </important>
         * <p>
         * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
         * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
         * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed
         * with "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For
         * information about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
         *        identify which servers or virtual machines (VMs) in your on-premises environment you intend to
         *        activate. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
         *        When you specify the activation ID and code, tags assigned to the activation are automatically applied
         *        to the on-premises servers or VMs.
         *        </p>
         *        </important>
         *        <p>
         *        You can't add tags to or delete tags from an existing activation. You can tag your on-premises
         *        servers, edge devices, and VMs after they connect to Systems Manager for the first time and are
         *        assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager
         *        console with an ID that is prefixed with "mi-". For information about how to add tags to your managed
         *        nodes, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes,
         *        see <a>RemoveTagsFromResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which
         * servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you
         * could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When
         * you specify the activation ID and code, tags assigned to the activation are automatically applied to the
         * on-premises servers or VMs.
         * </p>
         * </important>
         * <p>
         * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
         * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
         * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed
         * with "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For
         * information about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
         * </p>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag an activation to
         *        identify which servers or virtual machines (VMs) in your on-premises environment you intend to
         *        activate. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code.
         *        When you specify the activation ID and code, tags assigned to the activation are automatically applied
         *        to the on-premises servers or VMs.
         *        </p>
         *        </important>
         *        <p>
         *        You can't add tags to or delete tags from an existing activation. You can tag your on-premises
         *        servers, edge devices, and VMs after they connect to Systems Manager for the first time and are
         *        assigned a managed node ID. This means they are listed in the Amazon Web Services Systems Manager
         *        console with an ID that is prefixed with "mi-". For information about how to add tags to your managed
         *        nodes, see <a>AddTagsToResource</a>. For information about how to remove tags from your managed nodes,
         *        see <a>RemoveTagsFromResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag an activation to identify which
         * servers or virtual machines (VMs) in your on-premises environment you intend to activate. In this case, you
         * could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * When you install SSM Agent on your on-premises servers and VMs, you specify an activation ID and code. When
         * you specify the activation ID and code, tags assigned to the activation are automatically applied to the
         * on-premises servers or VMs.
         * </p>
         * </important>
         * <p>
         * You can't add tags to or delete tags from an existing activation. You can tag your on-premises servers, edge
         * devices, and VMs after they connect to Systems Manager for the first time and are assigned a managed node ID.
         * This means they are listed in the Amazon Web Services Systems Manager console with an ID that is prefixed
         * with "mi-". For information about how to add tags to your managed nodes, see <a>AddTagsToResource</a>. For
         * information about how to remove tags from your managed nodes, see <a>RemoveTagsFromResource</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ssm.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param registrationMetadata
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationMetadata(Collection<RegistrationMetadataItem> registrationMetadata);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * 
         * @param registrationMetadata
         *        Reserved for internal use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationMetadata(RegistrationMetadataItem... registrationMetadata);

        /**
         * <p>
         * Reserved for internal use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem.Builder#build()} is called
         * immediately and its result is passed to {@link #registrationMetadata(List<RegistrationMetadataItem>)}.
         * 
         * @param registrationMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.RegistrationMetadataItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrationMetadata(java.util.Collection<RegistrationMetadataItem>)
         */
        Builder registrationMetadata(Consumer<RegistrationMetadataItem.Builder>... registrationMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String description;

        private String defaultInstanceName;

        private String iamRole;

        private Integer registrationLimit;

        private Instant expirationDate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<RegistrationMetadataItem> registrationMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActivationRequest model) {
            super(model);
            description(model.description);
            defaultInstanceName(model.defaultInstanceName);
            iamRole(model.iamRole);
            registrationLimit(model.registrationLimit);
            expirationDate(model.expirationDate);
            tags(model.tags);
            registrationMetadata(model.registrationMetadata);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultInstanceName() {
            return defaultInstanceName;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Integer getRegistrationLimit() {
            return registrationLimit;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RegistrationMetadataItem.Builder> getRegistrationMetadata() {
            List<RegistrationMetadataItem.Builder> result = RegistrationMetadataListCopier
                    .copyToBuilder(this.registrationMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistrationMetadata(Collection<RegistrationMetadataItem.BuilderImpl> registrationMetadata) {
            this.registrationMetadata = RegistrationMetadataListCopier.copyFromBuilder(registrationMetadata);
        }

        @Override
        public final Builder registrationMetadata(Collection<RegistrationMetadataItem> registrationMetadata) {
            this.registrationMetadata = RegistrationMetadataListCopier.copy(registrationMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationMetadata(RegistrationMetadataItem... registrationMetadata) {
            registrationMetadata(Arrays.asList(registrationMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationMetadata(Consumer<RegistrationMetadataItem.Builder>... registrationMetadata) {
            registrationMetadata(Stream.of(registrationMetadata)
                    .map(c -> RegistrationMetadataItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateActivationRequest build() {
            return new CreateActivationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
