/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.DefaultSsmAsyncClient;
import software.amazon.awssdk.services.ssm.DefaultSsmBaseClientBuilder;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClientBuilder;
import software.amazon.awssdk.services.ssm.SsmServiceClientConfiguration;
import software.amazon.awssdk.services.ssm.endpoints.SsmEndpointProvider;

@SdkInternalApi
final class DefaultSsmAsyncClientBuilder
extends DefaultSsmBaseClientBuilder<SsmAsyncClientBuilder, SsmAsyncClient>
implements SsmAsyncClientBuilder {
    DefaultSsmAsyncClientBuilder() {
    }

    @Override
    public DefaultSsmAsyncClientBuilder endpointProvider(SsmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSsmAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SsmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsmAsyncClient client = new DefaultSsmAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

