/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;

public class GetParametersByPathPublisher
implements SdkPublisher<GetParametersByPathResponse> {
    private final SsmAsyncClient client;
    private final GetParametersByPathRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetParametersByPathPublisher(SsmAsyncClient client, GetParametersByPathRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetParametersByPathPublisher(SsmAsyncClient client, GetParametersByPathRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetParametersByPathResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetParametersByPathResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetParametersByPathResponseFetcher
    implements AsyncPageFetcher<GetParametersByPathResponse> {
        private GetParametersByPathResponseFetcher() {
        }

        public boolean hasNextPage(GetParametersByPathResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetParametersByPathResponse> nextPage(GetParametersByPathResponse previousPage) {
            if (previousPage == null) {
                return GetParametersByPathPublisher.this.client.getParametersByPath(GetParametersByPathPublisher.this.firstRequest);
            }
            return GetParametersByPathPublisher.this.client.getParametersByPath((GetParametersByPathRequest)((Object)GetParametersByPathPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

