/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo;

public class DescribeInstanceAssociationsStatusPublisher
implements SdkPublisher<DescribeInstanceAssociationsStatusResponse> {
    private final SsmAsyncClient client;
    private final DescribeInstanceAssociationsStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceAssociationsStatusPublisher(SsmAsyncClient client, DescribeInstanceAssociationsStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceAssociationsStatusPublisher(SsmAsyncClient client, DescribeInstanceAssociationsStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceAssociationsStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceAssociationsStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        Function<DescribeInstanceAssociationsStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceAssociationStatusInfos() != null) {
                return response.instanceAssociationStatusInfos().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstanceAssociationsStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstanceAssociationsStatusResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceAssociationsStatusResponse> {
        private DescribeInstanceAssociationsStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceAssociationsStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceAssociationsStatusResponse> nextPage(DescribeInstanceAssociationsStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceAssociationsStatusPublisher.this.client.describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusPublisher.this.firstRequest);
            }
            return DescribeInstanceAssociationsStatusPublisher.this.client.describeInstanceAssociationsStatus((DescribeInstanceAssociationsStatusRequest)((Object)DescribeInstanceAssociationsStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

