/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentFilterKey {
    NAME("Name"),
    OWNER("Owner"),
    PLATFORM_TYPES("PlatformTypes"),
    DOCUMENT_TYPE("DocumentType"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentFilterKey> VALUE_MAP;
    private final String value;

    private DocumentFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentFilterKey> knownValues() {
        EnumSet<DocumentFilterKey> knownValues = EnumSet.allOf(DocumentFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentFilterKey.class, DocumentFilterKey::toString);
    }
}

