/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationFilter.Builder, AssociationFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(AssociationFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(AssociationFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("key", KEY_FIELD);
                    put("value", VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private AssociationFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <note>
     * <p>
     * <code>InstanceId</code> has been deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AssociationFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.</p> <note>
     *         <p>
     *         <code>InstanceId</code> has been deprecated.
     *         </p>
     * @see AssociationFilterKey
     */
    public final AssociationFilterKey key() {
        return AssociationFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <note>
     * <p>
     * <code>InstanceId</code> has been deprecated.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AssociationFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.</p> <note>
     *         <p>
     *         <code>InstanceId</code> has been deprecated.
     *         </p>
     * @see AssociationFilterKey
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The filter value.
     * </p>
     * 
     * @return The filter value.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationFilter)) {
            return false;
        }
        AssociationFilter other = (AssociationFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationFilter").add("Key", keyAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociationFilter, T> g) {
        return obj -> g.apply((AssociationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * <note>
         * <p>
         * <code>InstanceId</code> has been deprecated.
         * </p>
         * </note>
         * 
         * @param key
         *        The name of the filter.</p> <note>
         *        <p>
         *        <code>InstanceId</code> has been deprecated.
         *        </p>
         * @see AssociationFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * <note>
         * <p>
         * <code>InstanceId</code> has been deprecated.
         * </p>
         * </note>
         * 
         * @param key
         *        The name of the filter.</p> <note>
         *        <p>
         *        <code>InstanceId</code> has been deprecated.
         *        </p>
         * @see AssociationFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationFilterKey
         */
        Builder key(AssociationFilterKey key);

        /**
         * <p>
         * The filter value.
         * </p>
         * 
         * @param value
         *        The filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationFilter model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(AssociationFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public AssociationFilter build() {
            return new AssociationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
