/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceDataSyncRequest extends SsmRequest implements
        ToCopyableBuilder<CreateResourceDataSyncRequest.Builder, CreateResourceDataSyncRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncName").getter(getter(CreateResourceDataSyncRequest::syncName)).setter(setter(Builder::syncName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()).build();

    private static final SdkField<ResourceDataSyncS3Destination> S3_DESTINATION_FIELD = SdkField
            .<ResourceDataSyncS3Destination> builder(MarshallingType.SDK_POJO).memberName("S3Destination")
            .getter(getter(CreateResourceDataSyncRequest::s3Destination)).setter(setter(Builder::s3Destination))
            .constructor(ResourceDataSyncS3Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Destination").build()).build();

    private static final SdkField<String> SYNC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncType").getter(getter(CreateResourceDataSyncRequest::syncType)).setter(setter(Builder::syncType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncType").build()).build();

    private static final SdkField<ResourceDataSyncSource> SYNC_SOURCE_FIELD = SdkField
            .<ResourceDataSyncSource> builder(MarshallingType.SDK_POJO).memberName("SyncSource")
            .getter(getter(CreateResourceDataSyncRequest::syncSource)).setter(setter(Builder::syncSource))
            .constructor(ResourceDataSyncSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD,
            S3_DESTINATION_FIELD, SYNC_TYPE_FIELD, SYNC_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SyncName", SYNC_NAME_FIELD);
                    put("S3Destination", S3_DESTINATION_FIELD);
                    put("SyncType", SYNC_TYPE_FIELD);
                    put("SyncSource", SYNC_SOURCE_FIELD);
                }
            });

    private final String syncName;

    private final ResourceDataSyncS3Destination s3Destination;

    private final String syncType;

    private final ResourceDataSyncSource syncSource;

    private CreateResourceDataSyncRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.s3Destination = builder.s3Destination;
        this.syncType = builder.syncType;
        this.syncSource = builder.syncSource;
    }

    /**
     * <p>
     * A name for the configuration.
     * </p>
     * 
     * @return A name for the configuration.
     */
    public final String syncName() {
        return syncName;
    }

    /**
     * <p>
     * Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value is
     * SyncToDestination.
     * </p>
     * 
     * @return Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code>
     *         value is SyncToDestination.
     */
    public final ResourceDataSyncS3Destination s3Destination() {
        return s3Destination;
    }

    /**
     * <p>
     * Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket for
     * Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for <code>S3Destination</code>
     * . Specify <code>SyncFromSource</code> to synchronize data from a single account and multiple Regions, or multiple
     * Amazon Web Services accounts and Amazon Web Services Regions, as listed in Organizations for Explorer. If you
     * specify <code>SyncFromSource</code>, you must provide a value for <code>SyncSource</code>. The default value is
     * <code>SyncToDestination</code>.
     * </p>
     * 
     * @return Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3
     *         bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for
     *         <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account
     *         and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as listed
     *         in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for
     *         <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.
     */
    public final String syncType() {
        return syncType;
    }

    /**
     * <p>
     * Specify information about the data sources to synchronize. This parameter is required if the
     * <code>SyncType</code> value is SyncFromSource.
     * </p>
     * 
     * @return Specify information about the data sources to synchronize. This parameter is required if the
     *         <code>SyncType</code> value is SyncFromSource.
     */
    public final ResourceDataSyncSource syncSource() {
        return syncSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(syncName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        hashCode = 31 * hashCode + Objects.hashCode(syncType());
        hashCode = 31 * hashCode + Objects.hashCode(syncSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDataSyncRequest)) {
            return false;
        }
        CreateResourceDataSyncRequest other = (CreateResourceDataSyncRequest) obj;
        return Objects.equals(syncName(), other.syncName()) && Objects.equals(s3Destination(), other.s3Destination())
                && Objects.equals(syncType(), other.syncType()) && Objects.equals(syncSource(), other.syncSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceDataSyncRequest").add("SyncName", syncName())
                .add("S3Destination", s3Destination()).add("SyncType", syncType()).add("SyncSource", syncSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncName":
            return Optional.ofNullable(clazz.cast(syncName()));
        case "S3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        case "SyncType":
            return Optional.ofNullable(clazz.cast(syncType()));
        case "SyncSource":
            return Optional.ofNullable(clazz.cast(syncSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceDataSyncRequest, T> g) {
        return obj -> g.apply((CreateResourceDataSyncRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResourceDataSyncRequest> {
        /**
         * <p>
         * A name for the configuration.
         * </p>
         * 
         * @param syncName
         *        A name for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        /**
         * <p>
         * Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value
         * is SyncToDestination.
         * </p>
         * 
         * @param s3Destination
         *        Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code>
         *        value is SyncToDestination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(ResourceDataSyncS3Destination s3Destination);

        /**
         * <p>
         * Amazon S3 configuration details for the sync. This parameter is required if the <code>SyncType</code> value
         * is SyncToDestination.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDataSyncS3Destination.Builder}
         * avoiding the need to create one manually via {@link ResourceDataSyncS3Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDataSyncS3Destination.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Destination(ResourceDataSyncS3Destination)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link ResourceDataSyncS3Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(ResourceDataSyncS3Destination)
         */
        default Builder s3Destination(Consumer<ResourceDataSyncS3Destination.Builder> s3Destination) {
            return s3Destination(ResourceDataSyncS3Destination.builder().applyMutation(s3Destination).build());
        }

        /**
         * <p>
         * Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3 bucket
         * for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for
         * <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single account and
         * multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services Regions, as listed in
         * Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must provide a value for
         * <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.
         * </p>
         * 
         * @param syncType
         *        Specify <code>SyncToDestination</code> to create a resource data sync that synchronizes data to an S3
         *        bucket for Inventory. If you specify <code>SyncToDestination</code>, you must provide a value for
         *        <code>S3Destination</code>. Specify <code>SyncFromSource</code> to synchronize data from a single
         *        account and multiple Regions, or multiple Amazon Web Services accounts and Amazon Web Services
         *        Regions, as listed in Organizations for Explorer. If you specify <code>SyncFromSource</code>, you must
         *        provide a value for <code>SyncSource</code>. The default value is <code>SyncToDestination</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncType(String syncType);

        /**
         * <p>
         * Specify information about the data sources to synchronize. This parameter is required if the
         * <code>SyncType</code> value is SyncFromSource.
         * </p>
         * 
         * @param syncSource
         *        Specify information about the data sources to synchronize. This parameter is required if the
         *        <code>SyncType</code> value is SyncFromSource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSource(ResourceDataSyncSource syncSource);

        /**
         * <p>
         * Specify information about the data sources to synchronize. This parameter is required if the
         * <code>SyncType</code> value is SyncFromSource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceDataSyncSource.Builder} avoiding
         * the need to create one manually via {@link ResourceDataSyncSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceDataSyncSource.Builder#build()} is called immediately and
         * its result is passed to {@link #syncSource(ResourceDataSyncSource)}.
         * 
         * @param syncSource
         *        a consumer that will call methods on {@link ResourceDataSyncSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncSource(ResourceDataSyncSource)
         */
        default Builder syncSource(Consumer<ResourceDataSyncSource.Builder> syncSource) {
            return syncSource(ResourceDataSyncSource.builder().applyMutation(syncSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String syncName;

        private ResourceDataSyncS3Destination s3Destination;

        private String syncType;

        private ResourceDataSyncSource syncSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDataSyncRequest model) {
            super(model);
            syncName(model.syncName);
            s3Destination(model.s3Destination);
            syncType(model.syncType);
            syncSource(model.syncSource);
        }

        public final String getSyncName() {
            return syncName;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final ResourceDataSyncS3Destination.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(ResourceDataSyncS3Destination.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(ResourceDataSyncS3Destination s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final String getSyncType() {
            return syncType;
        }

        public final void setSyncType(String syncType) {
            this.syncType = syncType;
        }

        @Override
        public final Builder syncType(String syncType) {
            this.syncType = syncType;
            return this;
        }

        public final ResourceDataSyncSource.Builder getSyncSource() {
            return syncSource != null ? syncSource.toBuilder() : null;
        }

        public final void setSyncSource(ResourceDataSyncSource.BuilderImpl syncSource) {
            this.syncSource = syncSource != null ? syncSource.build() : null;
        }

        @Override
        public final Builder syncSource(ResourceDataSyncSource syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceDataSyncRequest build() {
            return new CreateResourceDataSyncRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
