/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <a>PutResourcePolicy</a> API action enforces two limits. A policy can't be greater than 1024 bytes in size. And
 * only one policy can be attached to <code>OpsItemGroup</code>. Verify these limits and try again.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourcePolicyLimitExceededException extends SsmException implements
        ToCopyableBuilder<ResourcePolicyLimitExceededException.Builder, ResourcePolicyLimitExceededException> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ResourcePolicyLimitExceededException::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> LIMIT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LimitType").getter(getter(ResourcePolicyLimitExceededException::limitType))
            .setter(setter(Builder::limitType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LIMIT_FIELD, LIMIT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Limit", LIMIT_FIELD);
                    put("LimitType", LIMIT_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer limit;

    private final String limitType;

    private ResourcePolicyLimitExceededException(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.limitType = builder.limitType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Limit property for this object.
     * 
     * @return The value of the Limit property for this object.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * Returns the value of the LimitType property for this object.
     * 
     * @return The value of the LimitType property for this object.
     */
    public String limitType() {
        return limitType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicyLimitExceededException, T> g) {
        return obj -> g.apply((ResourcePolicyLimitExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourcePolicyLimitExceededException>,
            SsmException.Builder {
        /**
         * Sets the value of the Limit property for this object.
         *
         * @param limit
         *        The new value for the Limit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * Sets the value of the LimitType property for this object.
         *
         * @param limitType
         *        The new value for the LimitType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitType(String limitType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends SsmException.BuilderImpl implements Builder {
        private Integer limit;

        private String limitType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicyLimitExceededException model) {
            super(model);
            limit(model.limit);
            limitType(model.limitType);
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getLimitType() {
            return limitType;
        }

        public final void setLimitType(String limitType) {
            this.limitType = limitType;
        }

        @Override
        public final Builder limitType(String limitType) {
            this.limitType = limitType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ResourcePolicyLimitExceededException build() {
            return new ResourcePolicyLimitExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
