/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a command filter.
 * </p>
 * <note>
 * <p>
 * A managed node ID can't be specified when a command status is <code>Pending</code> because the command hasn't run on
 * the node yet.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommandFilter implements SdkPojo, Serializable, ToCopyableBuilder<CommandFilter.Builder, CommandFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(CommandFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(CommandFilter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("key", KEY_FIELD);
                    put("value", VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private CommandFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <note>
     * <p>
     * The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code> operation, only
     * with <code>ListCommands</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link CommandFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.</p> <note>
     *         <p>
     *         The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code>
     *         operation, only with <code>ListCommands</code>.
     *         </p>
     * @see CommandFilterKey
     */
    public final CommandFilterKey key() {
        return CommandFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <note>
     * <p>
     * The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code> operation, only
     * with <code>ListCommands</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link CommandFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.</p> <note>
     *         <p>
     *         The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code>
     *         operation, only with <code>ListCommands</code>.
     *         </p>
     * @see CommandFilterKey
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The filter value. Valid values for each filter key are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>InvokedAfter</b>: Specify a timestamp to limit your results. For example, specify
     * <code>2024-07-07T00:00:00Z</code> to see a list of command executions occurring July 7, 2021, and later.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>InvokedBefore</b>: Specify a timestamp to limit your results. For example, specify
     * <code>2024-07-07T00:00:00Z</code> to see a list of command executions from before July 7, 2021.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Status</b>: Specify a valid command status to see a list of all command executions with that status. The
     * status choices depend on the API you call.
     * </p>
     * <p>
     * The status values you can specify for <code>ListCommands</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Success</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimedOut</code> (this includes both Delivery and Execution time outs)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccessDenied</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryTimedOut</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExecutionTimedOut</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Incomplete</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NoInstancesInTag</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LimitExceeded</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The status values you can specify for <code>ListCommandInvocations</code> are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InProgress</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delayed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Success</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Cancelled</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TimedOut</code> (this includes both Delivery and Execution time outs)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AccessDenied</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeliveryTimedOut</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExecutionTimedOut</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Undeliverable</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InvalidPlatform</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminated</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM document) for which
     * you want to see command execution results. For example, specify <code>AWS-RunPatchBaseline</code> to see command
     * executions that used this SSM document to perform security patching operations on managed nodes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ExecutionStage</b>: Specify one of the following values (<code>ListCommands</code> operations only):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Executing</code>: Returns a list of command executions that are currently still running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Complete</code>: Returns a list of command executions that have already completed.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The filter value. Valid values for each filter key are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>InvokedAfter</b>: Specify a timestamp to limit your results. For example, specify
     *         <code>2024-07-07T00:00:00Z</code> to see a list of command executions occurring July 7, 2021, and later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>InvokedBefore</b>: Specify a timestamp to limit your results. For example, specify
     *         <code>2024-07-07T00:00:00Z</code> to see a list of command executions from before July 7, 2021.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Status</b>: Specify a valid command status to see a list of all command executions with that status.
     *         The status choices depend on the API you call.
     *         </p>
     *         <p>
     *         The status values you can specify for <code>ListCommands</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Success</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TimedOut</code> (this includes both Delivery and Execution time outs)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccessDenied</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryTimedOut</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExecutionTimedOut</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Incomplete</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NoInstancesInTag</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LimitExceeded</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The status values you can specify for <code>ListCommandInvocations</code> are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InProgress</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Delayed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Success</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Cancelled</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TimedOut</code> (this includes both Delivery and Execution time outs)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AccessDenied</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeliveryTimedOut</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExecutionTimedOut</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Undeliverable</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InvalidPlatform</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminated</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM document) for
     *         which you want to see command execution results. For example, specify <code>AWS-RunPatchBaseline</code>
     *         to see command executions that used this SSM document to perform security patching operations on managed
     *         nodes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ExecutionStage</b>: Specify one of the following values (<code>ListCommands</code> operations only):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Executing</code>: Returns a list of command executions that are currently still running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Complete</code>: Returns a list of command executions that have already completed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandFilter)) {
            return false;
        }
        CommandFilter other = (CommandFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommandFilter").add("Key", keyAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CommandFilter, T> g) {
        return obj -> g.apply((CommandFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommandFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * <note>
         * <p>
         * The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code> operation,
         * only with <code>ListCommands</code>.
         * </p>
         * </note>
         * 
         * @param key
         *        The name of the filter.</p> <note>
         *        <p>
         *        The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code>
         *        operation, only with <code>ListCommands</code>.
         *        </p>
         * @see CommandFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * <note>
         * <p>
         * The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code> operation,
         * only with <code>ListCommands</code>.
         * </p>
         * </note>
         * 
         * @param key
         *        The name of the filter.</p> <note>
         *        <p>
         *        The <code>ExecutionStage</code> filter can't be used with the <code>ListCommandInvocations</code>
         *        operation, only with <code>ListCommands</code>.
         *        </p>
         * @see CommandFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandFilterKey
         */
        Builder key(CommandFilterKey key);

        /**
         * <p>
         * The filter value. Valid values for each filter key are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>InvokedAfter</b>: Specify a timestamp to limit your results. For example, specify
         * <code>2024-07-07T00:00:00Z</code> to see a list of command executions occurring July 7, 2021, and later.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>InvokedBefore</b>: Specify a timestamp to limit your results. For example, specify
         * <code>2024-07-07T00:00:00Z</code> to see a list of command executions from before July 7, 2021.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Status</b>: Specify a valid command status to see a list of all command executions with that status. The
         * status choices depend on the API you call.
         * </p>
         * <p>
         * The status values you can specify for <code>ListCommands</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Success</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TimedOut</code> (this includes both Delivery and Execution time outs)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccessDenied</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryTimedOut</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionTimedOut</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Incomplete</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NoInstancesInTag</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LimitExceeded</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The status values you can specify for <code>ListCommandInvocations</code> are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InProgress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Delayed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Success</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Cancelled</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TimedOut</code> (this includes both Delivery and Execution time outs)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AccessDenied</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeliveryTimedOut</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExecutionTimedOut</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Undeliverable</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InvalidPlatform</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminated</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM document) for
         * which you want to see command execution results. For example, specify <code>AWS-RunPatchBaseline</code> to
         * see command executions that used this SSM document to perform security patching operations on managed nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ExecutionStage</b>: Specify one of the following values (<code>ListCommands</code> operations only):
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Executing</code>: Returns a list of command executions that are currently still running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Complete</code>: Returns a list of command executions that have already completed.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param value
         *        The filter value. Valid values for each filter key are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>InvokedAfter</b>: Specify a timestamp to limit your results. For example, specify
         *        <code>2024-07-07T00:00:00Z</code> to see a list of command executions occurring July 7, 2021, and
         *        later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>InvokedBefore</b>: Specify a timestamp to limit your results. For example, specify
         *        <code>2024-07-07T00:00:00Z</code> to see a list of command executions from before July 7, 2021.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Status</b>: Specify a valid command status to see a list of all command executions with that
         *        status. The status choices depend on the API you call.
         *        </p>
         *        <p>
         *        The status values you can specify for <code>ListCommands</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Success</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TimedOut</code> (this includes both Delivery and Execution time outs)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccessDenied</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryTimedOut</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExecutionTimedOut</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Incomplete</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NoInstancesInTag</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LimitExceeded</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The status values you can specify for <code>ListCommandInvocations</code> are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InProgress</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Delayed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Success</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Cancelled</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TimedOut</code> (this includes both Delivery and Execution time outs)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AccessDenied</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeliveryTimedOut</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExecutionTimedOut</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Undeliverable</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InvalidPlatform</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminated</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>DocumentName</b>: Specify name of the Amazon Web Services Systems Manager document (SSM document)
         *        for which you want to see command execution results. For example, specify
         *        <code>AWS-RunPatchBaseline</code> to see command executions that used this SSM document to perform
         *        security patching operations on managed nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ExecutionStage</b>: Specify one of the following values (<code>ListCommands</code> operations
         *        only):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Executing</code>: Returns a list of command executions that are currently still running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Complete</code>: Returns a list of command executions that have already completed.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandFilter model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(CommandFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public CommandFilter build() {
            return new CommandFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
