/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetParameterResponse extends SsmResponse implements
        ToCopyableBuilder<GetParameterResponse.Builder, GetParameterResponse> {
    private static final SdkField<Parameter> PARAMETER_FIELD = SdkField.<Parameter> builder(MarshallingType.SDK_POJO)
            .memberName("Parameter").getter(getter(GetParameterResponse::parameter)).setter(setter(Builder::parameter))
            .constructor(Parameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Parameter", PARAMETER_FIELD);
                }
            });

    private final Parameter parameter;

    private GetParameterResponse(BuilderImpl builder) {
        super(builder);
        this.parameter = builder.parameter;
    }

    /**
     * <p>
     * Information about a parameter.
     * </p>
     * 
     * @return Information about a parameter.
     */
    public final Parameter parameter() {
        return parameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParameterResponse)) {
            return false;
        }
        GetParameterResponse other = (GetParameterResponse) obj;
        return Objects.equals(parameter(), other.parameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetParameterResponse").add("Parameter", parameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parameter":
            return Optional.ofNullable(clazz.cast(parameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetParameterResponse, T> g) {
        return obj -> g.apply((GetParameterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetParameterResponse> {
        /**
         * <p>
         * Information about a parameter.
         * </p>
         * 
         * @param parameter
         *        Information about a parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameter(Parameter parameter);

        /**
         * <p>
         * Information about a parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link Parameter.Builder} avoiding the need to
         * create one manually via {@link Parameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Parameter.Builder#build()} is called immediately and its result
         * is passed to {@link #parameter(Parameter)}.
         * 
         * @param parameter
         *        a consumer that will call methods on {@link Parameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameter(Parameter)
         */
        default Builder parameter(Consumer<Parameter.Builder> parameter) {
            return parameter(Parameter.builder().applyMutation(parameter).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private Parameter parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParameterResponse model) {
            super(model);
            parameter(model.parameter);
        }

        public final Parameter.Builder getParameter() {
            return parameter != null ? parameter.toBuilder() : null;
        }

        public final void setParameter(Parameter.BuilderImpl parameter) {
            this.parameter = parameter != null ? parameter.build() : null;
        }

        @Override
        public final Builder parameter(Parameter parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        public GetParameterResponse build() {
            return new GetParameterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
