/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateManagedInstanceRoleRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateManagedInstanceRoleRequest.Builder, UpdateManagedInstanceRoleRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateManagedInstanceRoleRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRole").getter(getter(UpdateManagedInstanceRoleRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            IAM_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("IamRole", IAM_ROLE_FIELD);
                }
            });

    private final String instanceId;

    private final String iamRole;

    private UpdateManagedInstanceRoleRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.iamRole = builder.iamRole;
    }

    /**
     * <p>
     * The ID of the managed node where you want to update the role.
     * </p>
     * 
     * @return The ID of the managed node where you want to update the role.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This IAM
     * role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
     * <code>ssm.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html">Create
     * the IAM service role required for Systems Manager in hybrid and multicloud environments</a> in the <i>Amazon Web
     * Services Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     * </p>
     * </note>
     * 
     * @return The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
     *         This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
     *         principal <code>ssm.amazonaws.com</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html"
     *         >Create the IAM service role required for Systems Manager in hybrid and multicloud environments</a> in
     *         the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note>
     *         <p>
     *         You can't specify an IAM service-linked role for this parameter. You must create a unique role.
     *         </p>
     */
    public final String iamRole() {
        return iamRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedInstanceRoleRequest)) {
            return false;
        }
        UpdateManagedInstanceRoleRequest other = (UpdateManagedInstanceRoleRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(iamRole(), other.iamRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateManagedInstanceRoleRequest").add("InstanceId", instanceId()).add("IamRole", iamRole())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateManagedInstanceRoleRequest, T> g) {
        return obj -> g.apply((UpdateManagedInstanceRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateManagedInstanceRoleRequest> {
        /**
         * <p>
         * The ID of the managed node where you want to update the role.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed node where you want to update the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the Identity and Access Management (IAM) role that you want to assign to the managed node. This
         * IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service principal
         * <code>ssm.amazonaws.com</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html"
         * >Create the IAM service role required for Systems Manager in hybrid and multicloud environments</a> in the
         * <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * <note>
         * <p>
         * You can't specify an IAM service-linked role for this parameter. You must create a unique role.
         * </p>
         * </note>
         * 
         * @param iamRole
         *        The name of the Identity and Access Management (IAM) role that you want to assign to the managed node.
         *        This IAM role must provide AssumeRole permissions for the Amazon Web Services Systems Manager service
         *        principal <code>ssm.amazonaws.com</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html"
         *        >Create the IAM service role required for Systems Manager in hybrid and multicloud environments</a> in
         *        the <i>Amazon Web Services Systems Manager User Guide</i>.</p> <note>
         *        <p>
         *        You can't specify an IAM service-linked role for this parameter. You must create a unique role.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String iamRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedInstanceRoleRequest model) {
            super(model);
            instanceId(model.instanceId);
            iamRole(model.iamRole);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateManagedInstanceRoleRequest build() {
            return new UpdateManagedInstanceRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
