/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInventoryEntriesResponse extends SsmResponse implements
        ToCopyableBuilder<ListInventoryEntriesResponse.Builder, ListInventoryEntriesResponse> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ListInventoryEntriesResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListInventoryEntriesResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersion").getter(getter(ListInventoryEntriesResponse::schemaVersion))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()).build();

    private static final SdkField<String> CAPTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptureTime").getter(getter(ListInventoryEntriesResponse::captureTime))
            .setter(setter(Builder::captureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()).build();

    private static final SdkField<List<Map<String, String>>> ENTRIES_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(ListInventoryEntriesResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInventoryEntriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            INSTANCE_ID_FIELD, SCHEMA_VERSION_FIELD, CAPTURE_TIME_FIELD, ENTRIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TypeName", TYPE_NAME_FIELD);
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("SchemaVersion", SCHEMA_VERSION_FIELD);
                    put("CaptureTime", CAPTURE_TIME_FIELD);
                    put("Entries", ENTRIES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String typeName;

    private final String instanceId;

    private final String schemaVersion;

    private final String captureTime;

    private final List<Map<String, String>> entries;

    private final String nextToken;

    private ListInventoryEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.instanceId = builder.instanceId;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of inventory item returned by the request.
     * </p>
     * 
     * @return The type of inventory item returned by the request.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The managed node ID targeted by the request to query inventory information.
     * </p>
     * 
     * @return The managed node ID targeted by the request to query inventory information.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The inventory schema version used by the managed nodes.
     * </p>
     * 
     * @return The inventory schema version used by the managed nodes.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The time that inventory information was collected for the managed nodes.
     * </p>
     * 
     * @return The time that inventory information was collected for the managed nodes.
     */
    public final String captureTime() {
        return captureTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of inventory items on the managed nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return A list of inventory items on the managed nodes.
     */
    public final List<Map<String, String>> entries() {
        return entries;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesResponse)) {
            return false;
        }
        ListInventoryEntriesResponse other = (ListInventoryEntriesResponse) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(captureTime(), other.captureTime())
                && hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInventoryEntriesResponse").add("TypeName", typeName()).add("InstanceId", instanceId())
                .add("SchemaVersion", schemaVersion()).add("CaptureTime", captureTime())
                .add("Entries", hasEntries() ? entries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "CaptureTime":
            return Optional.ofNullable(clazz.cast(captureTime()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInventoryEntriesResponse, T> g) {
        return obj -> g.apply((ListInventoryEntriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInventoryEntriesResponse> {
        /**
         * <p>
         * The type of inventory item returned by the request.
         * </p>
         * 
         * @param typeName
         *        The type of inventory item returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The managed node ID targeted by the request to query inventory information.
         * </p>
         * 
         * @param instanceId
         *        The managed node ID targeted by the request to query inventory information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The inventory schema version used by the managed nodes.
         * </p>
         * 
         * @param schemaVersion
         *        The inventory schema version used by the managed nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The time that inventory information was collected for the managed nodes.
         * </p>
         * 
         * @param captureTime
         *        The time that inventory information was collected for the managed nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureTime(String captureTime);

        /**
         * <p>
         * A list of inventory items on the managed nodes.
         * </p>
         * 
         * @param entries
         *        A list of inventory items on the managed nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<? extends Map<String, String>> entries);

        /**
         * <p>
         * A list of inventory items on the managed nodes.
         * </p>
         * 
         * @param entries
         *        A list of inventory items on the managed nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Map<String, String>... entries);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String typeName;

        private String instanceId;

        private String schemaVersion;

        private String captureTime;

        private List<Map<String, String>> entries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesResponse model) {
            super(model);
            typeName(model.typeName);
            instanceId(model.instanceId);
            schemaVersion(model.schemaVersion);
            captureTime(model.captureTime);
            entries(model.entries);
            nextToken(model.nextToken);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getCaptureTime() {
            return captureTime;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final Collection<? extends Map<String, String>> getEntries() {
            if (entries instanceof SdkAutoConstructList) {
                return null;
            }
            return entries;
        }

        public final void setEntries(Collection<? extends Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
        }

        @Override
        public final Builder entries(Collection<? extends Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Map<String, String>... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInventoryEntriesResponse build() {
            return new ListInventoryEntriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
