/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifying information about a document attachment, including the file name and a key-value pair that identifies the
 * location of an attachment to a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachmentsSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AttachmentsSource.Builder, AttachmentsSource> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(AttachmentsSource::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(AttachmentsSource::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AttachmentsSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD,
            NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Key", KEY_FIELD);
                    put("Values", VALUES_FIELD);
                    put("Name", NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private final String name;

    private AttachmentsSource(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.name = builder.name;
    }

    /**
     * <p>
     * The key of a key-value pair that identifies the location of an attachment to a document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AttachmentsSourceKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The key of a key-value pair that identifies the location of an attachment to a document.
     * @see AttachmentsSourceKey
     */
    public final AttachmentsSourceKey key() {
        return AttachmentsSourceKey.fromValue(key);
    }

    /**
     * <p>
     * The key of a key-value pair that identifies the location of an attachment to a document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link AttachmentsSourceKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The key of a key-value pair that identifies the location of an attachment to a document.
     * @see AttachmentsSourceKey
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value of a key-value pair that identifies the location of an attachment to a document. The format for
     * <b>Value</b> depends on the type of key you specify.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:
     * </p>
     * <p>
     * <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:
     * </p>
     * <p>
     * <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document in your
     * account, a version number of that document, and a file attached to that document version that you want to reuse.
     * For example:
     * </p>
     * <p>
     * <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
     * </p>
     * <p>
     * However, if the SSM document is shared with you from another account, the full SSM document ARN must be specified
     * instead of the document name only. For example:
     * </p>
     * <p>
     * <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The value of a key-value pair that identifies the location of an attachment to a document. The format for
     *         <b>Value</b> depends on the type of key you specify.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:
     *         </p>
     *         <p>
     *         <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:
     *         </p>
     *         <p>
     *         <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document in
     *         your account, a version number of that document, and a file attached to that document version that you
     *         want to reuse. For example:
     *         </p>
     *         <p>
     *         <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
     *         </p>
     *         <p>
     *         However, if the SSM document is shared with you from another account, the full SSM document ARN must be
     *         specified instead of the document name only. For example:
     *         </p>
     *         <p>
     *         <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code>
     *         </p>
     *         </li>
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The name of the document attachment file.
     * </p>
     * 
     * @return The name of the document attachment file.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentsSource)) {
            return false;
        }
        AttachmentsSource other = (AttachmentsSource) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachmentsSource").add("Key", keyAsString()).add("Values", hasValues() ? values() : null)
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttachmentsSource, T> g) {
        return obj -> g.apply((AttachmentsSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttachmentsSource> {
        /**
         * <p>
         * The key of a key-value pair that identifies the location of an attachment to a document.
         * </p>
         * 
         * @param key
         *        The key of a key-value pair that identifies the location of an attachment to a document.
         * @see AttachmentsSourceKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentsSourceKey
         */
        Builder key(String key);

        /**
         * <p>
         * The key of a key-value pair that identifies the location of an attachment to a document.
         * </p>
         * 
         * @param key
         *        The key of a key-value pair that identifies the location of an attachment to a document.
         * @see AttachmentsSourceKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttachmentsSourceKey
         */
        Builder key(AttachmentsSourceKey key);

        /**
         * <p>
         * The value of a key-value pair that identifies the location of an attachment to a document. The format for
         * <b>Value</b> depends on the type of key you specify.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:
         * </p>
         * <p>
         * <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:
         * </p>
         * <p>
         * <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document in
         * your account, a version number of that document, and a file attached to that document version that you want
         * to reuse. For example:
         * </p>
         * <p>
         * <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
         * </p>
         * <p>
         * However, if the SSM document is shared with you from another account, the full SSM document ARN must be
         * specified instead of the document name only. For example:
         * </p>
         * <p>
         * <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The value of a key-value pair that identifies the location of an attachment to a document. The format
         *        for <b>Value</b> depends on the type of key you specify.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document
         *        in your account, a version number of that document, and a file attached to that document version that
         *        you want to reuse. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
         *        </p>
         *        <p>
         *        However, if the SSM document is shared with you from another account, the full SSM document ARN must
         *        be specified instead of the document name only. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value of a key-value pair that identifies the location of an attachment to a document. The format for
         * <b>Value</b> depends on the type of key you specify.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:
         * </p>
         * <p>
         * <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:
         * </p>
         * <p>
         * <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document in
         * your account, a version number of that document, and a file attached to that document version that you want
         * to reuse. For example:
         * </p>
         * <p>
         * <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
         * </p>
         * <p>
         * However, if the SSM document is shared with you from another account, the full SSM document ARN must be
         * specified instead of the document name only. For example:
         * </p>
         * <p>
         * <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The value of a key-value pair that identifies the location of an attachment to a document. The format
         *        for <b>Value</b> depends on the type of key you specify.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the key <i>SourceUrl</i>, the value is an S3 bucket location. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix" ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the key <i>S3FileUrl</i>, the value is a file in an S3 bucket. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "s3://amzn-s3-demo-bucket/my-prefix/my-file.py" ]</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the key <i>AttachmentReference</i>, the value is constructed from the name of another SSM document
         *        in your account, a version number of that document, and a file attached to that document version that
         *        you want to reuse. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "MyOtherDocument/3/my-other-file.py" ]</code>
         *        </p>
         *        <p>
         *        However, if the SSM document is shared with you from another account, the full SSM document ARN must
         *        be specified instead of the document name only. For example:
         *        </p>
         *        <p>
         *        <code>"Values": [ "arn:aws:ssm:us-east-2:111122223333:document/OtherAccountDocument/3/their-file.py" ]</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The name of the document attachment file.
         * </p>
         * 
         * @param name
         *        The name of the document attachment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentsSource model) {
            key(model.key);
            values(model.values);
            name(model.name);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(AttachmentsSourceKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = AttachmentsSourceValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = AttachmentsSourceValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public AttachmentsSource build() {
            return new AttachmentsSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
