/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteParametersResponse extends SsmResponse implements
        ToCopyableBuilder<DeleteParametersResponse.Builder, DeleteParametersResponse> {
    private static final SdkField<List<String>> DELETED_PARAMETERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeletedParameters")
            .getter(getter(DeleteParametersResponse::deletedParameters))
            .setter(setter(Builder::deletedParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INVALID_PARAMETERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InvalidParameters")
            .getter(getter(DeleteParametersResponse::invalidParameters))
            .setter(setter(Builder::invalidParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETED_PARAMETERS_FIELD,
            INVALID_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeletedParameters", DELETED_PARAMETERS_FIELD);
                    put("InvalidParameters", INVALID_PARAMETERS_FIELD);
                }
            });

    private final List<String> deletedParameters;

    private final List<String> invalidParameters;

    private DeleteParametersResponse(BuilderImpl builder) {
        super(builder);
        this.deletedParameters = builder.deletedParameters;
        this.invalidParameters = builder.invalidParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeletedParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeletedParameters() {
        return deletedParameters != null && !(deletedParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the deleted parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeletedParameters} method.
     * </p>
     * 
     * @return The names of the deleted parameters.
     */
    public final List<String> deletedParameters() {
        return deletedParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InvalidParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvalidParameters() {
        return invalidParameters != null && !(invalidParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of parameters that weren't deleted because the parameters aren't valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvalidParameters} method.
     * </p>
     * 
     * @return The names of parameters that weren't deleted because the parameters aren't valid.
     */
    public final List<String> invalidParameters() {
        return invalidParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeletedParameters() ? deletedParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInvalidParameters() ? invalidParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersResponse)) {
            return false;
        }
        DeleteParametersResponse other = (DeleteParametersResponse) obj;
        return hasDeletedParameters() == other.hasDeletedParameters()
                && Objects.equals(deletedParameters(), other.deletedParameters())
                && hasInvalidParameters() == other.hasInvalidParameters()
                && Objects.equals(invalidParameters(), other.invalidParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteParametersResponse")
                .add("DeletedParameters", hasDeletedParameters() ? deletedParameters() : null)
                .add("InvalidParameters", hasInvalidParameters() ? invalidParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeletedParameters":
            return Optional.ofNullable(clazz.cast(deletedParameters()));
        case "InvalidParameters":
            return Optional.ofNullable(clazz.cast(invalidParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteParametersResponse, T> g) {
        return obj -> g.apply((DeleteParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteParametersResponse> {
        /**
         * <p>
         * The names of the deleted parameters.
         * </p>
         * 
         * @param deletedParameters
         *        The names of the deleted parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedParameters(Collection<String> deletedParameters);

        /**
         * <p>
         * The names of the deleted parameters.
         * </p>
         * 
         * @param deletedParameters
         *        The names of the deleted parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedParameters(String... deletedParameters);

        /**
         * <p>
         * The names of parameters that weren't deleted because the parameters aren't valid.
         * </p>
         * 
         * @param invalidParameters
         *        The names of parameters that weren't deleted because the parameters aren't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(Collection<String> invalidParameters);

        /**
         * <p>
         * The names of parameters that weren't deleted because the parameters aren't valid.
         * </p>
         * 
         * @param invalidParameters
         *        The names of parameters that weren't deleted because the parameters aren't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(String... invalidParameters);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<String> deletedParameters = DefaultSdkAutoConstructList.getInstance();

        private List<String> invalidParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersResponse model) {
            super(model);
            deletedParameters(model.deletedParameters);
            invalidParameters(model.invalidParameters);
        }

        public final Collection<String> getDeletedParameters() {
            if (deletedParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return deletedParameters;
        }

        public final void setDeletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
        }

        @Override
        public final Builder deletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedParameters(String... deletedParameters) {
            deletedParameters(Arrays.asList(deletedParameters));
            return this;
        }

        public final Collection<String> getInvalidParameters() {
            if (invalidParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return invalidParameters;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String... invalidParameters) {
            invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        @Override
        public DeleteParametersResponse build() {
            return new DeleteParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
