/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowExecutionTasksResponse extends SsmResponse
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTasksResponse.Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
    private static final SdkField<List<MaintenanceWindowExecutionTaskIdentity>> WINDOW_EXECUTION_TASK_IDENTITIES_FIELD = SdkField
            .<List<MaintenanceWindowExecutionTaskIdentity>> builder(MarshallingType.LIST)
            .memberName("WindowExecutionTaskIdentities")
            .getter(getter(DescribeMaintenanceWindowExecutionTasksResponse::windowExecutionTaskIdentities))
            .setter(setter(Builder::windowExecutionTaskIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionTaskIdentities")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MaintenanceWindowExecutionTaskIdentity> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindowExecutionTaskIdentity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMaintenanceWindowExecutionTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WINDOW_EXECUTION_TASK_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("WindowExecutionTaskIdentities", WINDOW_EXECUTION_TASK_IDENTITIES_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionTaskIdentities = builder.windowExecutionTaskIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WindowExecutionTaskIdentities property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasWindowExecutionTaskIdentities() {
        return windowExecutionTaskIdentities != null && !(windowExecutionTaskIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the task executions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWindowExecutionTaskIdentities} method.
     * </p>
     * 
     * @return Information about the task executions.
     */
    public final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return windowExecutionTaskIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWindowExecutionTaskIdentities() ? windowExecutionTaskIdentities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTasksResponse other = (DescribeMaintenanceWindowExecutionTasksResponse) obj;
        return hasWindowExecutionTaskIdentities() == other.hasWindowExecutionTaskIdentities()
                && Objects.equals(windowExecutionTaskIdentities(), other.windowExecutionTaskIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeMaintenanceWindowExecutionTasksResponse")
                .add("WindowExecutionTaskIdentities", hasWindowExecutionTaskIdentities() ? windowExecutionTaskIdentities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionTaskIdentities":
            return Optional.ofNullable(clazz.cast(windowExecutionTaskIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowExecutionTasksResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowExecutionTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
        /**
         * <p>
         * Information about the task executions.
         * </p>
         * 
         * @param windowExecutionTaskIdentities
         *        Information about the task executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities);

        /**
         * <p>
         * Information about the task executions.
         * </p>
         * 
         * @param windowExecutionTaskIdentities
         *        Information about the task executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities);

        /**
         * <p>
         * Information about the task executions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #windowExecutionTaskIdentities(List<MaintenanceWindowExecutionTaskIdentity>)}.
         * 
         * @param windowExecutionTaskIdentities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowExecutionTaskIdentities(java.util.Collection<MaintenanceWindowExecutionTaskIdentity>)
         */
        Builder windowExecutionTaskIdentities(
                Consumer<MaintenanceWindowExecutionTaskIdentity.Builder>... windowExecutionTaskIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTasksResponse model) {
            super(model);
            windowExecutionTaskIdentities(model.windowExecutionTaskIdentities);
            nextToken(model.nextToken);
        }

        public final List<MaintenanceWindowExecutionTaskIdentity.Builder> getWindowExecutionTaskIdentities() {
            List<MaintenanceWindowExecutionTaskIdentity.Builder> result = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copyToBuilder(this.windowExecutionTaskIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWindowExecutionTaskIdentities(
                Collection<MaintenanceWindowExecutionTaskIdentity.BuilderImpl> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copyFromBuilder(windowExecutionTaskIdentities);
        }

        @Override
        public final Builder windowExecutionTaskIdentities(
                Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier
                    .copy(windowExecutionTaskIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(
                MaintenanceWindowExecutionTaskIdentity... windowExecutionTaskIdentities) {
            windowExecutionTaskIdentities(Arrays.asList(windowExecutionTaskIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(
                Consumer<MaintenanceWindowExecutionTaskIdentity.Builder>... windowExecutionTaskIdentities) {
            windowExecutionTaskIdentities(Stream.of(windowExecutionTaskIdentities)
                    .map(c -> MaintenanceWindowExecutionTaskIdentity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTasksResponse build() {
            return new DescribeMaintenanceWindowExecutionTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
