/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExecutionPreviewRequest extends SsmRequest implements
        ToCopyableBuilder<StartExecutionPreviewRequest.Builder, StartExecutionPreviewRequest> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(StartExecutionPreviewRequest::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(StartExecutionPreviewRequest::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<ExecutionInputs> EXECUTION_INPUTS_FIELD = SdkField
            .<ExecutionInputs> builder(MarshallingType.SDK_POJO).memberName("ExecutionInputs")
            .getter(getter(StartExecutionPreviewRequest::executionInputs)).setter(setter(Builder::executionInputs))
            .constructor(ExecutionInputs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionInputs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD,
            DOCUMENT_VERSION_FIELD, EXECUTION_INPUTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DocumentName", DOCUMENT_NAME_FIELD);
                    put("DocumentVersion", DOCUMENT_VERSION_FIELD);
                    put("ExecutionInputs", EXECUTION_INPUTS_FIELD);
                }
            });

    private final String documentName;

    private final String documentVersion;

    private final ExecutionInputs executionInputs;

    private StartExecutionPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.executionInputs = builder.executionInputs;
    }

    /**
     * <p>
     * The name of the Automation runbook to run. The result of the execution preview indicates what the impact would be
     * of running this runbook.
     * </p>
     * 
     * @return The name of the Automation runbook to run. The result of the execution preview indicates what the impact
     *         would be of running this runbook.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the Automation runbook to run. The default value is <code>$DEFAULT</code>.
     * </p>
     * 
     * @return The version of the Automation runbook to run. The default value is <code>$DEFAULT</code>.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * Information about the inputs that can be specified for the preview operation.
     * </p>
     * 
     * @return Information about the inputs that can be specified for the preview operation.
     */
    public final ExecutionInputs executionInputs() {
        return executionInputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(executionInputs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionPreviewRequest)) {
            return false;
        }
        StartExecutionPreviewRequest other = (StartExecutionPreviewRequest) obj;
        return Objects.equals(documentName(), other.documentName()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(executionInputs(), other.executionInputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExecutionPreviewRequest").add("DocumentName", documentName())
                .add("DocumentVersion", documentVersion()).add("ExecutionInputs", executionInputs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "ExecutionInputs":
            return Optional.ofNullable(clazz.cast(executionInputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionPreviewRequest, T> g) {
        return obj -> g.apply((StartExecutionPreviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartExecutionPreviewRequest> {
        /**
         * <p>
         * The name of the Automation runbook to run. The result of the execution preview indicates what the impact
         * would be of running this runbook.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation runbook to run. The result of the execution preview indicates what the
         *        impact would be of running this runbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the Automation runbook to run. The default value is <code>$DEFAULT</code>.
         * </p>
         * 
         * @param documentVersion
         *        The version of the Automation runbook to run. The default value is <code>$DEFAULT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * Information about the inputs that can be specified for the preview operation.
         * </p>
         * 
         * @param executionInputs
         *        Information about the inputs that can be specified for the preview operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionInputs(ExecutionInputs executionInputs);

        /**
         * <p>
         * Information about the inputs that can be specified for the preview operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionInputs.Builder} avoiding the
         * need to create one manually via {@link ExecutionInputs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionInputs.Builder#build()} is called immediately and its
         * result is passed to {@link #executionInputs(ExecutionInputs)}.
         * 
         * @param executionInputs
         *        a consumer that will call methods on {@link ExecutionInputs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionInputs(ExecutionInputs)
         */
        default Builder executionInputs(Consumer<ExecutionInputs.Builder> executionInputs) {
            return executionInputs(ExecutionInputs.builder().applyMutation(executionInputs).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String documentName;

        private String documentVersion;

        private ExecutionInputs executionInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionPreviewRequest model) {
            super(model);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            executionInputs(model.executionInputs);
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final ExecutionInputs.Builder getExecutionInputs() {
            return executionInputs != null ? executionInputs.toBuilder() : null;
        }

        public final void setExecutionInputs(ExecutionInputs.BuilderImpl executionInputs) {
            this.executionInputs = executionInputs != null ? executionInputs.build() : null;
        }

        @Override
        public final Builder executionInputs(ExecutionInputs executionInputs) {
            this.executionInputs = executionInputs;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExecutionPreviewRequest build() {
            return new StartExecutionPreviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
