/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchOutputConfig> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupName").getter(CloudWatchOutputConfig.getter(CloudWatchOutputConfig::cloudWatchLogGroupName)).setter(CloudWatchOutputConfig.setter(Builder::cloudWatchLogGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupName").build()}).build();
    private static final SdkField<Boolean> CLOUD_WATCH_OUTPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudWatchOutputEnabled").getter(CloudWatchOutputConfig.getter(CloudWatchOutputConfig::cloudWatchOutputEnabled)).setter(CloudWatchOutputConfig.setter(Builder::cloudWatchOutputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_GROUP_NAME_FIELD, CLOUD_WATCH_OUTPUT_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CloudWatchLogGroupName", CLOUD_WATCH_LOG_GROUP_NAME_FIELD);
            this.put("CloudWatchOutputEnabled", CLOUD_WATCH_OUTPUT_ENABLED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String cloudWatchLogGroupName;
    private final Boolean cloudWatchOutputEnabled;

    private CloudWatchOutputConfig(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.cloudWatchOutputEnabled = builder.cloudWatchOutputEnabled;
    }

    public final String cloudWatchLogGroupName() {
        return this.cloudWatchLogGroupName;
    }

    public final Boolean cloudWatchOutputEnabled() {
        return this.cloudWatchOutputEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchOutputConfig)) {
            return false;
        }
        CloudWatchOutputConfig other = (CloudWatchOutputConfig)obj;
        return Objects.equals(this.cloudWatchLogGroupName(), other.cloudWatchLogGroupName()) && Objects.equals(this.cloudWatchOutputEnabled(), other.cloudWatchOutputEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchOutputConfig").add("CloudWatchLogGroupName", (Object)this.cloudWatchLogGroupName()).add("CloudWatchOutputEnabled", (Object)this.cloudWatchOutputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLogGroupName": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupName()));
            }
            case "CloudWatchOutputEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchOutputConfig, T> g) {
        return obj -> g.apply((CloudWatchOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLogGroupName;
        private Boolean cloudWatchOutputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchOutputConfig model) {
            this.cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            this.cloudWatchOutputEnabled(model.cloudWatchOutputEnabled);
        }

        public final String getCloudWatchLogGroupName() {
            return this.cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final Boolean getCloudWatchOutputEnabled() {
            return this.cloudWatchOutputEnabled;
        }

        public final void setCloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
        }

        @Override
        public final Builder cloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
            return this;
        }

        public CloudWatchOutputConfig build() {
            return new CloudWatchOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchOutputConfig> {
        public Builder cloudWatchLogGroupName(String var1);

        public Builder cloudWatchOutputEnabled(Boolean var1);
    }
}

