/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.EffectivePatch;

public class DescribeEffectivePatchesForPatchBaselinePublisher
implements SdkPublisher<DescribeEffectivePatchesForPatchBaselineResponse> {
    private final SsmAsyncClient client;
    private final DescribeEffectivePatchesForPatchBaselineRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEffectivePatchesForPatchBaselinePublisher(SsmAsyncClient client, DescribeEffectivePatchesForPatchBaselineRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEffectivePatchesForPatchBaselinePublisher(SsmAsyncClient client, DescribeEffectivePatchesForPatchBaselineRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEffectivePatchesForPatchBaselineResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEffectivePatchesForPatchBaselineResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EffectivePatch> effectivePatches() {
        Function<DescribeEffectivePatchesForPatchBaselineResponse, Iterator> getIterator = response -> {
            if (response != null && response.effectivePatches() != null) {
                return response.effectivePatches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEffectivePatchesForPatchBaselineResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEffectivePatchesForPatchBaselineResponseFetcher
    implements AsyncPageFetcher<DescribeEffectivePatchesForPatchBaselineResponse> {
        private DescribeEffectivePatchesForPatchBaselineResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEffectivePatchesForPatchBaselineResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> nextPage(DescribeEffectivePatchesForPatchBaselineResponse previousPage) {
            if (previousPage == null) {
                return DescribeEffectivePatchesForPatchBaselinePublisher.this.client.describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselinePublisher.this.firstRequest);
            }
            return DescribeEffectivePatchesForPatchBaselinePublisher.this.client.describeEffectivePatchesForPatchBaseline((DescribeEffectivePatchesForPatchBaselineRequest)((Object)DescribeEffectivePatchesForPatchBaselinePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

