/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the inputs for an execution preview.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionInputs implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionInputs.Builder, ExecutionInputs> {
    private static final SdkField<AutomationExecutionInputs> AUTOMATION_FIELD = SdkField
            .<AutomationExecutionInputs> builder(MarshallingType.SDK_POJO).memberName("Automation")
            .getter(getter(ExecutionInputs::automation)).setter(setter(Builder::automation))
            .constructor(AutomationExecutionInputs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Automation", AUTOMATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AutomationExecutionInputs automation;

    private final Type type;

    private ExecutionInputs(BuilderImpl builder) {
        this.automation = builder.automation;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about the optional inputs that can be specified for an automation execution preview.
     * </p>
     * 
     * @return Information about the optional inputs that can be specified for an automation execution preview.
     */
    public final AutomationExecutionInputs automation() {
        return automation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionInputs)) {
            return false;
        }
        ExecutionInputs other = (ExecutionInputs) obj;
        return Objects.equals(automation(), other.automation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionInputs").add("Automation", automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #automation()} initialized to the given value.
     *
     * <p>
     * Information about the optional inputs that can be specified for an automation execution preview.
     * </p>
     * 
     * @param automation
     *        Information about the optional inputs that can be specified for an automation execution preview.
     */
    public static ExecutionInputs fromAutomation(AutomationExecutionInputs automation) {
        return builder().automation(automation).build();
    }

    /**
     * Create an instance of this class with {@link #automation()} initialized to the given value.
     *
     * <p>
     * Information about the optional inputs that can be specified for an automation execution preview.
     * </p>
     * 
     * @param automation
     *        Information about the optional inputs that can be specified for an automation execution preview.
     */
    public static ExecutionInputs fromAutomation(Consumer<AutomationExecutionInputs.Builder> automation) {
        AutomationExecutionInputs.Builder builder = AutomationExecutionInputs.builder();
        automation.accept(builder);
        return fromAutomation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionInputs, T> g) {
        return obj -> g.apply((ExecutionInputs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionInputs> {
        /**
         * <p>
         * Information about the optional inputs that can be specified for an automation execution preview.
         * </p>
         * 
         * @param automation
         *        Information about the optional inputs that can be specified for an automation execution preview.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(AutomationExecutionInputs automation);

        /**
         * <p>
         * Information about the optional inputs that can be specified for an automation execution preview.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomationExecutionInputs.Builder}
         * avoiding the need to create one manually via {@link AutomationExecutionInputs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomationExecutionInputs.Builder#build()} is called immediately
         * and its result is passed to {@link #automation(AutomationExecutionInputs)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link AutomationExecutionInputs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(AutomationExecutionInputs)
         */
        default Builder automation(Consumer<AutomationExecutionInputs.Builder> automation) {
            return automation(AutomationExecutionInputs.builder().applyMutation(automation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutomationExecutionInputs automation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionInputs model) {
            automation(model.automation);
        }

        public final AutomationExecutionInputs.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        public final void setAutomation(AutomationExecutionInputs.BuilderImpl automation) {
            Object oldValue = this.automation;
            this.automation = automation != null ? automation.build() : null;
            handleUnionValueChange(Type.AUTOMATION, oldValue, this.automation);
        }

        @Override
        public final Builder automation(AutomationExecutionInputs automation) {
            Object oldValue = this.automation;
            this.automation = automation;
            handleUnionValueChange(Type.AUTOMATION, oldValue, this.automation);
            return this;
        }

        @Override
        public ExecutionInputs build() {
            return new ExecutionInputs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ExecutionInputs#type()
     */
    public enum Type {
        AUTOMATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
