/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a specific managed node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceInfo implements SdkPojo, Serializable, ToCopyableBuilder<InstanceInfo.Builder, InstanceInfo> {
    private static final SdkField<String> AGENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentType").getter(getter(InstanceInfo::agentType)).setter(setter(Builder::agentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentType").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(InstanceInfo::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputerName").getter(getter(InstanceInfo::computerName)).setter(setter(Builder::computerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()).build();

    private static final SdkField<String> INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceStatus").getter(getter(InstanceInfo::instanceStatus)).setter(setter(Builder::instanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(InstanceInfo::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> MANAGED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedStatus").getter(getter(InstanceInfo::managedStatusAsString))
            .setter(setter(Builder::managedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedStatus").build()).build();

    private static final SdkField<String> PLATFORM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformType").getter(getter(InstanceInfo::platformTypeAsString)).setter(setter(Builder::platformType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformType").build()).build();

    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformName").getter(getter(InstanceInfo::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(InstanceInfo::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(InstanceInfo::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_TYPE_FIELD,
            AGENT_VERSION_FIELD, COMPUTER_NAME_FIELD, INSTANCE_STATUS_FIELD, IP_ADDRESS_FIELD, MANAGED_STATUS_FIELD,
            PLATFORM_TYPE_FIELD, PLATFORM_NAME_FIELD, PLATFORM_VERSION_FIELD, RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AgentType", AGENT_TYPE_FIELD);
                    put("AgentVersion", AGENT_VERSION_FIELD);
                    put("ComputerName", COMPUTER_NAME_FIELD);
                    put("InstanceStatus", INSTANCE_STATUS_FIELD);
                    put("IpAddress", IP_ADDRESS_FIELD);
                    put("ManagedStatus", MANAGED_STATUS_FIELD);
                    put("PlatformType", PLATFORM_TYPE_FIELD);
                    put("PlatformName", PLATFORM_NAME_FIELD);
                    put("PlatformVersion", PLATFORM_VERSION_FIELD);
                    put("ResourceType", RESOURCE_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String agentType;

    private final String agentVersion;

    private final String computerName;

    private final String instanceStatus;

    private final String ipAddress;

    private final String managedStatus;

    private final String platformType;

    private final String platformName;

    private final String platformVersion;

    private final String resourceType;

    private InstanceInfo(BuilderImpl builder) {
        this.agentType = builder.agentType;
        this.agentVersion = builder.agentVersion;
        this.computerName = builder.computerName;
        this.instanceStatus = builder.instanceStatus;
        this.ipAddress = builder.ipAddress;
        this.managedStatus = builder.managedStatus;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The type of agent installed on the node.
     * </p>
     * 
     * @return The type of agent installed on the node.
     */
    public final String agentType() {
        return agentType;
    }

    /**
     * <p>
     * The version number of the agent installed on the node.
     * </p>
     * 
     * @return The version number of the agent installed on the node.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The fully qualified host name of the managed node.
     * </p>
     * 
     * @return The fully qualified host name of the managed node.
     */
    public final String computerName() {
        return computerName;
    }

    /**
     * <p>
     * The current status of the managed node.
     * </p>
     * 
     * @return The current status of the managed node.
     */
    public final String instanceStatus() {
        return instanceStatus;
    }

    /**
     * <p>
     * The IP address of the managed node.
     * </p>
     * 
     * @return The IP address of the managed node.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Indicates whether the node is managed by Systems Manager.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedStatus}
     * will return {@link ManagedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #managedStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the node is managed by Systems Manager.
     * @see ManagedStatus
     */
    public final ManagedStatus managedStatus() {
        return ManagedStatus.fromValue(managedStatus);
    }

    /**
     * <p>
     * Indicates whether the node is managed by Systems Manager.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedStatus}
     * will return {@link ManagedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #managedStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the node is managed by Systems Manager.
     * @see ManagedStatus
     */
    public final String managedStatusAsString() {
        return managedStatus;
    }

    /**
     * <p>
     * The operating system platform type of the managed node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeAsString}.
     * </p>
     * 
     * @return The operating system platform type of the managed node.
     * @see PlatformType
     */
    public final PlatformType platformType() {
        return PlatformType.fromValue(platformType);
    }

    /**
     * <p>
     * The operating system platform type of the managed node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platformType} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformTypeAsString}.
     * </p>
     * 
     * @return The operating system platform type of the managed node.
     * @see PlatformType
     */
    public final String platformTypeAsString() {
        return platformType;
    }

    /**
     * <p>
     * The name of the operating system platform running on your managed node.
     * </p>
     * 
     * @return The name of the operating system platform running on your managed node.
     */
    public final String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The version of the OS platform running on your managed node.
     * </p>
     * 
     * @return The version of the OS platform running on your managed node.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentType());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(computerName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(managedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo) obj;
        return Objects.equals(agentType(), other.agentType()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(computerName(), other.computerName())
                && Objects.equals(instanceStatus(), other.instanceStatus()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(managedStatusAsString(), other.managedStatusAsString())
                && Objects.equals(platformTypeAsString(), other.platformTypeAsString())
                && Objects.equals(platformName(), other.platformName())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceInfo").add("AgentType", agentType()).add("AgentVersion", agentVersion())
                .add("ComputerName", computerName()).add("InstanceStatus", instanceStatus())
                .add("IpAddress", ipAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ManagedStatus", managedStatusAsString()).add("PlatformType", platformTypeAsString())
                .add("PlatformName", platformName()).add("PlatformVersion", platformVersion())
                .add("ResourceType", resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentType":
            return Optional.ofNullable(clazz.cast(agentType()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "ComputerName":
            return Optional.ofNullable(clazz.cast(computerName()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatus()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "ManagedStatus":
            return Optional.ofNullable(clazz.cast(managedStatusAsString()));
        case "PlatformType":
            return Optional.ofNullable(clazz.cast(platformTypeAsString()));
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceInfo, T> g) {
        return obj -> g.apply((InstanceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceInfo> {
        /**
         * <p>
         * The type of agent installed on the node.
         * </p>
         * 
         * @param agentType
         *        The type of agent installed on the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentType(String agentType);

        /**
         * <p>
         * The version number of the agent installed on the node.
         * </p>
         * 
         * @param agentVersion
         *        The version number of the agent installed on the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The fully qualified host name of the managed node.
         * </p>
         * 
         * @param computerName
         *        The fully qualified host name of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * The current status of the managed node.
         * </p>
         * 
         * @param instanceStatus
         *        The current status of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatus(String instanceStatus);

        /**
         * <p>
         * The IP address of the managed node.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Indicates whether the node is managed by Systems Manager.
         * </p>
         * 
         * @param managedStatus
         *        Indicates whether the node is managed by Systems Manager.
         * @see ManagedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedStatus
         */
        Builder managedStatus(String managedStatus);

        /**
         * <p>
         * Indicates whether the node is managed by Systems Manager.
         * </p>
         * 
         * @param managedStatus
         *        Indicates whether the node is managed by Systems Manager.
         * @see ManagedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedStatus
         */
        Builder managedStatus(ManagedStatus managedStatus);

        /**
         * <p>
         * The operating system platform type of the managed node.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type of the managed node.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(String platformType);

        /**
         * <p>
         * The operating system platform type of the managed node.
         * </p>
         * 
         * @param platformType
         *        The operating system platform type of the managed node.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platformType(PlatformType platformType);

        /**
         * <p>
         * The name of the operating system platform running on your managed node.
         * </p>
         * 
         * @param platformName
         *        The name of the operating system platform running on your managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The version of the OS platform running on your managed node.
         * </p>
         * 
         * @param platformVersion
         *        The version of the OS platform running on your managed node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
         * </p>
         * 
         * @param resourceType
         *        The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
         * </p>
         * 
         * @param resourceType
         *        The type of instance, either an EC2 instance or another supported machine type in a hybrid fleet.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);
    }

    static final class BuilderImpl implements Builder {
        private String agentType;

        private String agentVersion;

        private String computerName;

        private String instanceStatus;

        private String ipAddress;

        private String managedStatus;

        private String platformType;

        private String platformName;

        private String platformVersion;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            agentType(model.agentType);
            agentVersion(model.agentVersion);
            computerName(model.computerName);
            instanceStatus(model.instanceStatus);
            ipAddress(model.ipAddress);
            managedStatus(model.managedStatus);
            platformType(model.platformType);
            platformName(model.platformName);
            platformVersion(model.platformVersion);
            resourceType(model.resourceType);
        }

        public final String getAgentType() {
            return agentType;
        }

        public final void setAgentType(String agentType) {
            this.agentType = agentType;
        }

        @Override
        public final Builder agentType(String agentType) {
            this.agentType = agentType;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getComputerName() {
            return computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final String getInstanceStatus() {
            return instanceStatus;
        }

        public final void setInstanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
        }

        @Override
        public final Builder instanceStatus(String instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getManagedStatus() {
            return managedStatus;
        }

        public final void setManagedStatus(String managedStatus) {
            this.managedStatus = managedStatus;
        }

        @Override
        public final Builder managedStatus(String managedStatus) {
            this.managedStatus = managedStatus;
            return this;
        }

        @Override
        public final Builder managedStatus(ManagedStatus managedStatus) {
            this.managedStatus(managedStatus == null ? null : managedStatus.toString());
            return this;
        }

        public final String getPlatformType() {
            return platformType;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType == null ? null : platformType.toString());
            return this;
        }

        public final String getPlatformName() {
            return platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public InstanceInfo build() {
            return new InstanceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
