/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExecutionPreviewResponse extends SsmResponse implements
        ToCopyableBuilder<StartExecutionPreviewResponse.Builder, StartExecutionPreviewResponse> {
    private static final SdkField<String> EXECUTION_PREVIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionPreviewId").getter(getter(StartExecutionPreviewResponse::executionPreviewId))
            .setter(setter(Builder::executionPreviewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionPreviewId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_PREVIEW_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ExecutionPreviewId", EXECUTION_PREVIEW_ID_FIELD);
                }
            });

    private final String executionPreviewId;

    private StartExecutionPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.executionPreviewId = builder.executionPreviewId;
    }

    /**
     * <p>
     * The ID of the execution preview generated by the system.
     * </p>
     * 
     * @return The ID of the execution preview generated by the system.
     */
    public final String executionPreviewId() {
        return executionPreviewId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionPreviewId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExecutionPreviewResponse)) {
            return false;
        }
        StartExecutionPreviewResponse other = (StartExecutionPreviewResponse) obj;
        return Objects.equals(executionPreviewId(), other.executionPreviewId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExecutionPreviewResponse").add("ExecutionPreviewId", executionPreviewId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionPreviewId":
            return Optional.ofNullable(clazz.cast(executionPreviewId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartExecutionPreviewResponse, T> g) {
        return obj -> g.apply((StartExecutionPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartExecutionPreviewResponse> {
        /**
         * <p>
         * The ID of the execution preview generated by the system.
         * </p>
         * 
         * @param executionPreviewId
         *        The ID of the execution preview generated by the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionPreviewId(String executionPreviewId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String executionPreviewId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExecutionPreviewResponse model) {
            super(model);
            executionPreviewId(model.executionPreviewId);
        }

        public final String getExecutionPreviewId() {
            return executionPreviewId;
        }

        public final void setExecutionPreviewId(String executionPreviewId) {
            this.executionPreviewId = executionPreviewId;
        }

        @Override
        public final Builder executionPreviewId(String executionPreviewId) {
            this.executionPreviewId = executionPreviewId;
            return this;
        }

        @Override
        public StartExecutionPreviewResponse build() {
            return new StartExecutionPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
