/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstancePatchState;
import software.amazon.awssdk.services.ssm.model.InstancePatchStateListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstancePatchStatesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
    private static final SdkField<List<InstancePatchState>> INSTANCE_PATCH_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstancePatchStates").getter(DescribeInstancePatchStatesResponse.getter(DescribeInstancePatchStatesResponse::instancePatchStates)).setter(DescribeInstancePatchStatesResponse.setter(Builder::instancePatchStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePatchStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePatchState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstancePatchStatesResponse.getter(DescribeInstancePatchStatesResponse::nextToken)).setter(DescribeInstancePatchStatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PATCH_STATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstancePatchStates", INSTANCE_PATCH_STATES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<InstancePatchState> instancePatchStates;
    private final String nextToken;

    private DescribeInstancePatchStatesResponse(BuilderImpl builder) {
        super(builder);
        this.instancePatchStates = builder.instancePatchStates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstancePatchStates() {
        return this.instancePatchStates != null && !(this.instancePatchStates instanceof SdkAutoConstructList);
    }

    public final List<InstancePatchState> instancePatchStates() {
        return this.instancePatchStates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstancePatchStates() ? this.instancePatchStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancePatchStatesResponse)) {
            return false;
        }
        DescribeInstancePatchStatesResponse other = (DescribeInstancePatchStatesResponse)((Object)obj);
        return this.hasInstancePatchStates() == other.hasInstancePatchStates() && Objects.equals(this.instancePatchStates(), other.instancePatchStates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstancePatchStatesResponse").add("InstancePatchStates", this.hasInstancePatchStates() ? this.instancePatchStates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancePatchStates": {
                return Optional.ofNullable(clazz.cast(this.instancePatchStates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstancePatchStatesResponse, T> g) {
        return obj -> g.apply((DescribeInstancePatchStatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<InstancePatchState> instancePatchStates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancePatchStatesResponse model) {
            super(model);
            this.instancePatchStates(model.instancePatchStates);
            this.nextToken(model.nextToken);
        }

        public final List<InstancePatchState.Builder> getInstancePatchStates() {
            List<InstancePatchState.Builder> result = InstancePatchStateListCopier.copyToBuilder(this.instancePatchStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstancePatchStates(Collection<InstancePatchState.BuilderImpl> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copyFromBuilder(instancePatchStates);
        }

        @Override
        public final Builder instancePatchStates(Collection<InstancePatchState> instancePatchStates) {
            this.instancePatchStates = InstancePatchStateListCopier.copy(instancePatchStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePatchStates(InstancePatchState ... instancePatchStates) {
            this.instancePatchStates(Arrays.asList(instancePatchStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePatchStates(Consumer<InstancePatchState.Builder> ... instancePatchStates) {
            this.instancePatchStates(Stream.of(instancePatchStates).map(c -> (InstancePatchState)((InstancePatchState.Builder)InstancePatchState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeInstancePatchStatesResponse build() {
            return new DescribeInstancePatchStatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstancePatchStatesResponse> {
        public Builder instancePatchStates(Collection<InstancePatchState> var1);

        public Builder instancePatchStates(InstancePatchState ... var1);

        public Builder instancePatchStates(Consumer<InstancePatchState.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

