/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputSource> {
    private static final SdkField<String> OUTPUT_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputSourceId").getter(OutputSource.getter(OutputSource::outputSourceId)).setter(OutputSource.setter(Builder::outputSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSourceId").build()}).build();
    private static final SdkField<String> OUTPUT_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputSourceType").getter(OutputSource.getter(OutputSource::outputSourceType)).setter(OutputSource.setter(Builder::outputSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputSourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SOURCE_ID_FIELD, OUTPUT_SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OutputSourceId", OUTPUT_SOURCE_ID_FIELD);
            this.put("OutputSourceType", OUTPUT_SOURCE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String outputSourceId;
    private final String outputSourceType;

    private OutputSource(BuilderImpl builder) {
        this.outputSourceId = builder.outputSourceId;
        this.outputSourceType = builder.outputSourceType;
    }

    public final String outputSourceId() {
        return this.outputSourceId;
    }

    public final String outputSourceType() {
        return this.outputSourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputSourceType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSource)) {
            return false;
        }
        OutputSource other = (OutputSource)obj;
        return Objects.equals(this.outputSourceId(), other.outputSourceId()) && Objects.equals(this.outputSourceType(), other.outputSourceType());
    }

    public final String toString() {
        return ToString.builder((String)"OutputSource").add("OutputSourceId", (Object)this.outputSourceId()).add("OutputSourceType", (Object)this.outputSourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputSourceId": {
                return Optional.ofNullable(clazz.cast(this.outputSourceId()));
            }
            case "OutputSourceType": {
                return Optional.ofNullable(clazz.cast(this.outputSourceType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OutputSource, T> g) {
        return obj -> g.apply((OutputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputSourceId;
        private String outputSourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSource model) {
            this.outputSourceId(model.outputSourceId);
            this.outputSourceType(model.outputSourceType);
        }

        public final String getOutputSourceId() {
            return this.outputSourceId;
        }

        public final void setOutputSourceId(String outputSourceId) {
            this.outputSourceId = outputSourceId;
        }

        @Override
        public final Builder outputSourceId(String outputSourceId) {
            this.outputSourceId = outputSourceId;
            return this;
        }

        public final String getOutputSourceType() {
            return this.outputSourceType;
        }

        public final void setOutputSourceType(String outputSourceType) {
            this.outputSourceType = outputSourceType;
        }

        @Override
        public final Builder outputSourceType(String outputSourceType) {
            this.outputSourceType = outputSourceType;
            return this;
        }

        public OutputSource build() {
            return new OutputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputSource> {
        public Builder outputSourceId(String var1);

        public Builder outputSourceType(String var1);
    }
}

