/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetLocationsCopier;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecutionInputs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecutionInputs> {
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(AutomationExecutionInputs.getter(AutomationExecutionInputs::parameters)).setter(AutomationExecutionInputs.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetParameterName").getter(AutomationExecutionInputs.getter(AutomationExecutionInputs::targetParameterName)).setter(AutomationExecutionInputs.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(AutomationExecutionInputs.getter(AutomationExecutionInputs::targets)).setter(AutomationExecutionInputs.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetMaps").getter(AutomationExecutionInputs.getter(AutomationExecutionInputs::targetMaps)).setter(AutomationExecutionInputs.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetLocations").getter(AutomationExecutionInputs.getter(AutomationExecutionInputs::targetLocations)).setter(AutomationExecutionInputs.setter(Builder::targetLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_LOCATIONS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLocationsURL").getter(AutomationExecutionInputs.getter(AutomationExecutionInputs::targetLocationsURL)).setter(AutomationExecutionInputs.setter(Builder::targetLocationsURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationsURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETERS_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, TARGET_LOCATIONS_FIELD, TARGET_LOCATIONS_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Parameters", PARAMETERS_FIELD);
            this.put("TargetParameterName", TARGET_PARAMETER_NAME_FIELD);
            this.put("Targets", TARGETS_FIELD);
            this.put("TargetMaps", TARGET_MAPS_FIELD);
            this.put("TargetLocations", TARGET_LOCATIONS_FIELD);
            this.put("TargetLocationsURL", TARGET_LOCATIONS_URL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, List<String>> parameters;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final List<TargetLocation> targetLocations;
    private final String targetLocationsURL;

    private AutomationExecutionInputs(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.targetLocations = builder.targetLocations;
        this.targetLocationsURL = builder.targetLocationsURL;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final String targetParameterName() {
        return this.targetParameterName;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final boolean hasTargetMaps() {
        return this.targetMaps != null && !(this.targetMaps instanceof SdkAutoConstructList);
    }

    public final List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public final boolean hasTargetLocations() {
        return this.targetLocations != null && !(this.targetLocations instanceof SdkAutoConstructList);
    }

    public final List<TargetLocation> targetLocations() {
        return this.targetLocations;
    }

    public final String targetLocationsURL() {
        return this.targetLocationsURL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetMaps() ? this.targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetLocations() ? this.targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocationsURL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionInputs)) {
            return false;
        }
        AutomationExecutionInputs other = (AutomationExecutionInputs)obj;
        return this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasTargetMaps() == other.hasTargetMaps() && Objects.equals(this.targetMaps(), other.targetMaps()) && this.hasTargetLocations() == other.hasTargetLocations() && Objects.equals(this.targetLocations(), other.targetLocations()) && Objects.equals(this.targetLocationsURL(), other.targetLocationsURL());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationExecutionInputs").add("Parameters", this.hasParameters() ? this.parameters() : null).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.hasTargets() ? this.targets() : null).add("TargetMaps", this.hasTargetMaps() ? this.targetMaps() : null).add("TargetLocations", this.hasTargetLocations() ? this.targetLocations() : null).add("TargetLocationsURL", (Object)this.targetLocationsURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "TargetLocations": {
                return Optional.ofNullable(clazz.cast(this.targetLocations()));
            }
            case "TargetLocationsURL": {
                return Optional.ofNullable(clazz.cast(this.targetLocationsURL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionInputs, T> g) {
        return obj -> g.apply((AutomationExecutionInputs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();
        private String targetLocationsURL;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionInputs model) {
            this.parameters(model.parameters);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.targetLocations(model.targetLocations);
            this.targetLocationsURL(model.targetLocationsURL);
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (this.targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation ... targetLocations) {
            this.targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder> ... targetLocations) {
            this.targetLocations(Stream.of(targetLocations).map(c -> (TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTargetLocationsURL() {
            return this.targetLocationsURL;
        }

        public final void setTargetLocationsURL(String targetLocationsURL) {
            this.targetLocationsURL = targetLocationsURL;
        }

        @Override
        public final Builder targetLocationsURL(String targetLocationsURL) {
            this.targetLocationsURL = targetLocationsURL;
            return this;
        }

        public AutomationExecutionInputs build() {
            return new AutomationExecutionInputs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecutionInputs> {
        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder targetLocations(Collection<TargetLocation> var1);

        public Builder targetLocations(TargetLocation ... var1);

        public Builder targetLocations(Consumer<TargetLocation.Builder> ... var1);

        public Builder targetLocationsURL(String var1);
    }
}

