/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePatchGroupStateResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribePatchGroupStateResponse> {
    private static final SdkField<Integer> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Instances").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instances)).setter(DescribePatchGroupStateResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithInstalledPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithInstalledOtherPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledOtherPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledOtherPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledOtherPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_PENDING_REBOOT_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithInstalledPendingRebootPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledPendingRebootPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledPendingRebootPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledPendingRebootPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithInstalledRejectedPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithInstalledRejectedPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithInstalledRejectedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithInstalledRejectedPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_MISSING_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithMissingPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithMissingPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithMissingPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithMissingPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_FAILED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithFailedPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithFailedPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithFailedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithFailedPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithNotApplicablePatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithNotApplicablePatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithNotApplicablePatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithNotApplicablePatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithUnreportedNotApplicablePatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithUnreportedNotApplicablePatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithUnreportedNotApplicablePatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithUnreportedNotApplicablePatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_CRITICAL_NON_COMPLIANT_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithCriticalNonCompliantPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithCriticalNonCompliantPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithCriticalNonCompliantPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithCriticalNonCompliantPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_SECURITY_NON_COMPLIANT_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithSecurityNonCompliantPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithSecurityNonCompliantPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithSecurityNonCompliantPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithSecurityNonCompliantPatches").build()}).build();
    private static final SdkField<Integer> INSTANCES_WITH_OTHER_NON_COMPLIANT_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancesWithOtherNonCompliantPatches").getter(DescribePatchGroupStateResponse.getter(DescribePatchGroupStateResponse::instancesWithOtherNonCompliantPatches)).setter(DescribePatchGroupStateResponse.setter(Builder::instancesWithOtherNonCompliantPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesWithOtherNonCompliantPatches").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, INSTANCES_WITH_INSTALLED_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_PENDING_REBOOT_PATCHES_FIELD, INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD, INSTANCES_WITH_MISSING_PATCHES_FIELD, INSTANCES_WITH_FAILED_PATCHES_FIELD, INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD, INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD, INSTANCES_WITH_CRITICAL_NON_COMPLIANT_PATCHES_FIELD, INSTANCES_WITH_SECURITY_NON_COMPLIANT_PATCHES_FIELD, INSTANCES_WITH_OTHER_NON_COMPLIANT_PATCHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Instances", INSTANCES_FIELD);
            this.put("InstancesWithInstalledPatches", INSTANCES_WITH_INSTALLED_PATCHES_FIELD);
            this.put("InstancesWithInstalledOtherPatches", INSTANCES_WITH_INSTALLED_OTHER_PATCHES_FIELD);
            this.put("InstancesWithInstalledPendingRebootPatches", INSTANCES_WITH_INSTALLED_PENDING_REBOOT_PATCHES_FIELD);
            this.put("InstancesWithInstalledRejectedPatches", INSTANCES_WITH_INSTALLED_REJECTED_PATCHES_FIELD);
            this.put("InstancesWithMissingPatches", INSTANCES_WITH_MISSING_PATCHES_FIELD);
            this.put("InstancesWithFailedPatches", INSTANCES_WITH_FAILED_PATCHES_FIELD);
            this.put("InstancesWithNotApplicablePatches", INSTANCES_WITH_NOT_APPLICABLE_PATCHES_FIELD);
            this.put("InstancesWithUnreportedNotApplicablePatches", INSTANCES_WITH_UNREPORTED_NOT_APPLICABLE_PATCHES_FIELD);
            this.put("InstancesWithCriticalNonCompliantPatches", INSTANCES_WITH_CRITICAL_NON_COMPLIANT_PATCHES_FIELD);
            this.put("InstancesWithSecurityNonCompliantPatches", INSTANCES_WITH_SECURITY_NON_COMPLIANT_PATCHES_FIELD);
            this.put("InstancesWithOtherNonCompliantPatches", INSTANCES_WITH_OTHER_NON_COMPLIANT_PATCHES_FIELD);
        }
    });
    private final Integer instances;
    private final Integer instancesWithInstalledPatches;
    private final Integer instancesWithInstalledOtherPatches;
    private final Integer instancesWithInstalledPendingRebootPatches;
    private final Integer instancesWithInstalledRejectedPatches;
    private final Integer instancesWithMissingPatches;
    private final Integer instancesWithFailedPatches;
    private final Integer instancesWithNotApplicablePatches;
    private final Integer instancesWithUnreportedNotApplicablePatches;
    private final Integer instancesWithCriticalNonCompliantPatches;
    private final Integer instancesWithSecurityNonCompliantPatches;
    private final Integer instancesWithOtherNonCompliantPatches;

    private DescribePatchGroupStateResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.instancesWithInstalledPatches = builder.instancesWithInstalledPatches;
        this.instancesWithInstalledOtherPatches = builder.instancesWithInstalledOtherPatches;
        this.instancesWithInstalledPendingRebootPatches = builder.instancesWithInstalledPendingRebootPatches;
        this.instancesWithInstalledRejectedPatches = builder.instancesWithInstalledRejectedPatches;
        this.instancesWithMissingPatches = builder.instancesWithMissingPatches;
        this.instancesWithFailedPatches = builder.instancesWithFailedPatches;
        this.instancesWithNotApplicablePatches = builder.instancesWithNotApplicablePatches;
        this.instancesWithUnreportedNotApplicablePatches = builder.instancesWithUnreportedNotApplicablePatches;
        this.instancesWithCriticalNonCompliantPatches = builder.instancesWithCriticalNonCompliantPatches;
        this.instancesWithSecurityNonCompliantPatches = builder.instancesWithSecurityNonCompliantPatches;
        this.instancesWithOtherNonCompliantPatches = builder.instancesWithOtherNonCompliantPatches;
    }

    public final Integer instances() {
        return this.instances;
    }

    public final Integer instancesWithInstalledPatches() {
        return this.instancesWithInstalledPatches;
    }

    public final Integer instancesWithInstalledOtherPatches() {
        return this.instancesWithInstalledOtherPatches;
    }

    public final Integer instancesWithInstalledPendingRebootPatches() {
        return this.instancesWithInstalledPendingRebootPatches;
    }

    public final Integer instancesWithInstalledRejectedPatches() {
        return this.instancesWithInstalledRejectedPatches;
    }

    public final Integer instancesWithMissingPatches() {
        return this.instancesWithMissingPatches;
    }

    public final Integer instancesWithFailedPatches() {
        return this.instancesWithFailedPatches;
    }

    public final Integer instancesWithNotApplicablePatches() {
        return this.instancesWithNotApplicablePatches;
    }

    public final Integer instancesWithUnreportedNotApplicablePatches() {
        return this.instancesWithUnreportedNotApplicablePatches;
    }

    public final Integer instancesWithCriticalNonCompliantPatches() {
        return this.instancesWithCriticalNonCompliantPatches;
    }

    public final Integer instancesWithSecurityNonCompliantPatches() {
        return this.instancesWithSecurityNonCompliantPatches;
    }

    public final Integer instancesWithOtherNonCompliantPatches() {
        return this.instancesWithOtherNonCompliantPatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledOtherPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledPendingRebootPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithInstalledRejectedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithMissingPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithFailedPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithNotApplicablePatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithUnreportedNotApplicablePatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithCriticalNonCompliantPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithSecurityNonCompliantPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesWithOtherNonCompliantPatches());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupStateResponse)) {
            return false;
        }
        DescribePatchGroupStateResponse other = (DescribePatchGroupStateResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances()) && Objects.equals(this.instancesWithInstalledPatches(), other.instancesWithInstalledPatches()) && Objects.equals(this.instancesWithInstalledOtherPatches(), other.instancesWithInstalledOtherPatches()) && Objects.equals(this.instancesWithInstalledPendingRebootPatches(), other.instancesWithInstalledPendingRebootPatches()) && Objects.equals(this.instancesWithInstalledRejectedPatches(), other.instancesWithInstalledRejectedPatches()) && Objects.equals(this.instancesWithMissingPatches(), other.instancesWithMissingPatches()) && Objects.equals(this.instancesWithFailedPatches(), other.instancesWithFailedPatches()) && Objects.equals(this.instancesWithNotApplicablePatches(), other.instancesWithNotApplicablePatches()) && Objects.equals(this.instancesWithUnreportedNotApplicablePatches(), other.instancesWithUnreportedNotApplicablePatches()) && Objects.equals(this.instancesWithCriticalNonCompliantPatches(), other.instancesWithCriticalNonCompliantPatches()) && Objects.equals(this.instancesWithSecurityNonCompliantPatches(), other.instancesWithSecurityNonCompliantPatches()) && Objects.equals(this.instancesWithOtherNonCompliantPatches(), other.instancesWithOtherNonCompliantPatches());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePatchGroupStateResponse").add("Instances", (Object)this.instances()).add("InstancesWithInstalledPatches", (Object)this.instancesWithInstalledPatches()).add("InstancesWithInstalledOtherPatches", (Object)this.instancesWithInstalledOtherPatches()).add("InstancesWithInstalledPendingRebootPatches", (Object)this.instancesWithInstalledPendingRebootPatches()).add("InstancesWithInstalledRejectedPatches", (Object)this.instancesWithInstalledRejectedPatches()).add("InstancesWithMissingPatches", (Object)this.instancesWithMissingPatches()).add("InstancesWithFailedPatches", (Object)this.instancesWithFailedPatches()).add("InstancesWithNotApplicablePatches", (Object)this.instancesWithNotApplicablePatches()).add("InstancesWithUnreportedNotApplicablePatches", (Object)this.instancesWithUnreportedNotApplicablePatches()).add("InstancesWithCriticalNonCompliantPatches", (Object)this.instancesWithCriticalNonCompliantPatches()).add("InstancesWithSecurityNonCompliantPatches", (Object)this.instancesWithSecurityNonCompliantPatches()).add("InstancesWithOtherNonCompliantPatches", (Object)this.instancesWithOtherNonCompliantPatches()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "InstancesWithInstalledPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledPatches()));
            }
            case "InstancesWithInstalledOtherPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledOtherPatches()));
            }
            case "InstancesWithInstalledPendingRebootPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledPendingRebootPatches()));
            }
            case "InstancesWithInstalledRejectedPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithInstalledRejectedPatches()));
            }
            case "InstancesWithMissingPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithMissingPatches()));
            }
            case "InstancesWithFailedPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithFailedPatches()));
            }
            case "InstancesWithNotApplicablePatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithNotApplicablePatches()));
            }
            case "InstancesWithUnreportedNotApplicablePatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithUnreportedNotApplicablePatches()));
            }
            case "InstancesWithCriticalNonCompliantPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithCriticalNonCompliantPatches()));
            }
            case "InstancesWithSecurityNonCompliantPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithSecurityNonCompliantPatches()));
            }
            case "InstancesWithOtherNonCompliantPatches": {
                return Optional.ofNullable(clazz.cast(this.instancesWithOtherNonCompliantPatches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchGroupStateResponse, T> g) {
        return obj -> g.apply((DescribePatchGroupStateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private Integer instances;
        private Integer instancesWithInstalledPatches;
        private Integer instancesWithInstalledOtherPatches;
        private Integer instancesWithInstalledPendingRebootPatches;
        private Integer instancesWithInstalledRejectedPatches;
        private Integer instancesWithMissingPatches;
        private Integer instancesWithFailedPatches;
        private Integer instancesWithNotApplicablePatches;
        private Integer instancesWithUnreportedNotApplicablePatches;
        private Integer instancesWithCriticalNonCompliantPatches;
        private Integer instancesWithSecurityNonCompliantPatches;
        private Integer instancesWithOtherNonCompliantPatches;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupStateResponse model) {
            super(model);
            this.instances(model.instances);
            this.instancesWithInstalledPatches(model.instancesWithInstalledPatches);
            this.instancesWithInstalledOtherPatches(model.instancesWithInstalledOtherPatches);
            this.instancesWithInstalledPendingRebootPatches(model.instancesWithInstalledPendingRebootPatches);
            this.instancesWithInstalledRejectedPatches(model.instancesWithInstalledRejectedPatches);
            this.instancesWithMissingPatches(model.instancesWithMissingPatches);
            this.instancesWithFailedPatches(model.instancesWithFailedPatches);
            this.instancesWithNotApplicablePatches(model.instancesWithNotApplicablePatches);
            this.instancesWithUnreportedNotApplicablePatches(model.instancesWithUnreportedNotApplicablePatches);
            this.instancesWithCriticalNonCompliantPatches(model.instancesWithCriticalNonCompliantPatches);
            this.instancesWithSecurityNonCompliantPatches(model.instancesWithSecurityNonCompliantPatches);
            this.instancesWithOtherNonCompliantPatches(model.instancesWithOtherNonCompliantPatches);
        }

        public final Integer getInstances() {
            return this.instances;
        }

        public final void setInstances(Integer instances) {
            this.instances = instances;
        }

        @Override
        public final Builder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public final Integer getInstancesWithInstalledPatches() {
            return this.instancesWithInstalledPatches;
        }

        public final void setInstancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
        }

        @Override
        public final Builder instancesWithInstalledPatches(Integer instancesWithInstalledPatches) {
            this.instancesWithInstalledPatches = instancesWithInstalledPatches;
            return this;
        }

        public final Integer getInstancesWithInstalledOtherPatches() {
            return this.instancesWithInstalledOtherPatches;
        }

        public final void setInstancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
        }

        @Override
        public final Builder instancesWithInstalledOtherPatches(Integer instancesWithInstalledOtherPatches) {
            this.instancesWithInstalledOtherPatches = instancesWithInstalledOtherPatches;
            return this;
        }

        public final Integer getInstancesWithInstalledPendingRebootPatches() {
            return this.instancesWithInstalledPendingRebootPatches;
        }

        public final void setInstancesWithInstalledPendingRebootPatches(Integer instancesWithInstalledPendingRebootPatches) {
            this.instancesWithInstalledPendingRebootPatches = instancesWithInstalledPendingRebootPatches;
        }

        @Override
        public final Builder instancesWithInstalledPendingRebootPatches(Integer instancesWithInstalledPendingRebootPatches) {
            this.instancesWithInstalledPendingRebootPatches = instancesWithInstalledPendingRebootPatches;
            return this;
        }

        public final Integer getInstancesWithInstalledRejectedPatches() {
            return this.instancesWithInstalledRejectedPatches;
        }

        public final void setInstancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches) {
            this.instancesWithInstalledRejectedPatches = instancesWithInstalledRejectedPatches;
        }

        @Override
        public final Builder instancesWithInstalledRejectedPatches(Integer instancesWithInstalledRejectedPatches) {
            this.instancesWithInstalledRejectedPatches = instancesWithInstalledRejectedPatches;
            return this;
        }

        public final Integer getInstancesWithMissingPatches() {
            return this.instancesWithMissingPatches;
        }

        public final void setInstancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
        }

        @Override
        public final Builder instancesWithMissingPatches(Integer instancesWithMissingPatches) {
            this.instancesWithMissingPatches = instancesWithMissingPatches;
            return this;
        }

        public final Integer getInstancesWithFailedPatches() {
            return this.instancesWithFailedPatches;
        }

        public final void setInstancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
        }

        @Override
        public final Builder instancesWithFailedPatches(Integer instancesWithFailedPatches) {
            this.instancesWithFailedPatches = instancesWithFailedPatches;
            return this;
        }

        public final Integer getInstancesWithNotApplicablePatches() {
            return this.instancesWithNotApplicablePatches;
        }

        public final void setInstancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithNotApplicablePatches(Integer instancesWithNotApplicablePatches) {
            this.instancesWithNotApplicablePatches = instancesWithNotApplicablePatches;
            return this;
        }

        public final Integer getInstancesWithUnreportedNotApplicablePatches() {
            return this.instancesWithUnreportedNotApplicablePatches;
        }

        public final void setInstancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches) {
            this.instancesWithUnreportedNotApplicablePatches = instancesWithUnreportedNotApplicablePatches;
        }

        @Override
        public final Builder instancesWithUnreportedNotApplicablePatches(Integer instancesWithUnreportedNotApplicablePatches) {
            this.instancesWithUnreportedNotApplicablePatches = instancesWithUnreportedNotApplicablePatches;
            return this;
        }

        public final Integer getInstancesWithCriticalNonCompliantPatches() {
            return this.instancesWithCriticalNonCompliantPatches;
        }

        public final void setInstancesWithCriticalNonCompliantPatches(Integer instancesWithCriticalNonCompliantPatches) {
            this.instancesWithCriticalNonCompliantPatches = instancesWithCriticalNonCompliantPatches;
        }

        @Override
        public final Builder instancesWithCriticalNonCompliantPatches(Integer instancesWithCriticalNonCompliantPatches) {
            this.instancesWithCriticalNonCompliantPatches = instancesWithCriticalNonCompliantPatches;
            return this;
        }

        public final Integer getInstancesWithSecurityNonCompliantPatches() {
            return this.instancesWithSecurityNonCompliantPatches;
        }

        public final void setInstancesWithSecurityNonCompliantPatches(Integer instancesWithSecurityNonCompliantPatches) {
            this.instancesWithSecurityNonCompliantPatches = instancesWithSecurityNonCompliantPatches;
        }

        @Override
        public final Builder instancesWithSecurityNonCompliantPatches(Integer instancesWithSecurityNonCompliantPatches) {
            this.instancesWithSecurityNonCompliantPatches = instancesWithSecurityNonCompliantPatches;
            return this;
        }

        public final Integer getInstancesWithOtherNonCompliantPatches() {
            return this.instancesWithOtherNonCompliantPatches;
        }

        public final void setInstancesWithOtherNonCompliantPatches(Integer instancesWithOtherNonCompliantPatches) {
            this.instancesWithOtherNonCompliantPatches = instancesWithOtherNonCompliantPatches;
        }

        @Override
        public final Builder instancesWithOtherNonCompliantPatches(Integer instancesWithOtherNonCompliantPatches) {
            this.instancesWithOtherNonCompliantPatches = instancesWithOtherNonCompliantPatches;
            return this;
        }

        @Override
        public DescribePatchGroupStateResponse build() {
            return new DescribePatchGroupStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePatchGroupStateResponse> {
        public Builder instances(Integer var1);

        public Builder instancesWithInstalledPatches(Integer var1);

        public Builder instancesWithInstalledOtherPatches(Integer var1);

        public Builder instancesWithInstalledPendingRebootPatches(Integer var1);

        public Builder instancesWithInstalledRejectedPatches(Integer var1);

        public Builder instancesWithMissingPatches(Integer var1);

        public Builder instancesWithFailedPatches(Integer var1);

        public Builder instancesWithNotApplicablePatches(Integer var1);

        public Builder instancesWithUnreportedNotApplicablePatches(Integer var1);

        public Builder instancesWithCriticalNonCompliantPatches(Integer var1);

        public Builder instancesWithSecurityNonCompliantPatches(Integer var1);

        public Builder instancesWithOtherNonCompliantPatches(Integer var1);
    }
}

