/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionStatusResponse extends SsmResponse implements
        ToCopyableBuilder<GetConnectionStatusResponse.Builder, GetConnectionStatusResponse> {
    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(GetConnectionStatusResponse::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetConnectionStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Target", TARGET_FIELD);
                    put("Status", STATUS_FIELD);
                }
            });

    private final String target;

    private final String status;

    private GetConnectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.target = builder.target;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the managed node to check connection status.
     * </p>
     * 
     * @return The ID of the managed node to check connection status.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The status of the connection to the managed node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the connection to the managed node.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the connection to the managed node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the connection to the managed node.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionStatusResponse)) {
            return false;
        }
        GetConnectionStatusResponse other = (GetConnectionStatusResponse) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionStatusResponse").add("Target", target()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionStatusResponse, T> g) {
        return obj -> g.apply((GetConnectionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectionStatusResponse> {
        /**
         * <p>
         * The ID of the managed node to check connection status.
         * </p>
         * 
         * @param target
         *        The ID of the managed node to check connection status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The status of the connection to the managed node.
         * </p>
         * 
         * @param status
         *        The status of the connection to the managed node.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the connection to the managed node.
         * </p>
         * 
         * @param status
         *        The status of the connection to the managed node.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String target;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionStatusResponse model) {
            super(model);
            target(model.target);
            status(model.status);
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetConnectionStatusResponse build() {
            return new GetConnectionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
