/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the maintenance window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowIdentity implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindowIdentity.Builder, MaintenanceWindowIdentity> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowId").getter(getter(MaintenanceWindowIdentity::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MaintenanceWindowIdentity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(MaintenanceWindowIdentity::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(MaintenanceWindowIdentity::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(MaintenanceWindowIdentity::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Cutoff").getter(getter(MaintenanceWindowIdentity::cutoff)).setter(setter(Builder::cutoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(MaintenanceWindowIdentity::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleTimezone").getter(getter(MaintenanceWindowIdentity::scheduleTimezone))
            .setter(setter(Builder::scheduleTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()).build();

    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScheduleOffset").getter(getter(MaintenanceWindowIdentity::scheduleOffset))
            .setter(setter(Builder::scheduleOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDate").getter(getter(MaintenanceWindowIdentity::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDate").getter(getter(MaintenanceWindowIdentity::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> NEXT_EXECUTION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextExecutionTime").getter(getter(MaintenanceWindowIdentity::nextExecutionTime))
            .setter(setter(Builder::nextExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextExecutionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, ENABLED_FIELD, DURATION_FIELD, CUTOFF_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD,
            SCHEDULE_OFFSET_FIELD, END_DATE_FIELD, START_DATE_FIELD, NEXT_EXECUTION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("WindowId", WINDOW_ID_FIELD);
                    put("Name", NAME_FIELD);
                    put("Description", DESCRIPTION_FIELD);
                    put("Enabled", ENABLED_FIELD);
                    put("Duration", DURATION_FIELD);
                    put("Cutoff", CUTOFF_FIELD);
                    put("Schedule", SCHEDULE_FIELD);
                    put("ScheduleTimezone", SCHEDULE_TIMEZONE_FIELD);
                    put("ScheduleOffset", SCHEDULE_OFFSET_FIELD);
                    put("EndDate", END_DATE_FIELD);
                    put("StartDate", START_DATE_FIELD);
                    put("NextExecutionTime", NEXT_EXECUTION_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String windowId;

    private final String name;

    private final String description;

    private final Boolean enabled;

    private final Integer duration;

    private final Integer cutoff;

    private final String schedule;

    private final String scheduleTimezone;

    private final Integer scheduleOffset;

    private final String endDate;

    private final String startDate;

    private final String nextExecutionTime;

    private MaintenanceWindowIdentity(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.endDate = builder.endDate;
        this.startDate = builder.startDate;
        this.nextExecutionTime = builder.nextExecutionTime;
    }

    /**
     * <p>
     * The ID of the maintenance window.
     * </p>
     * 
     * @return The ID of the maintenance window.
     */
    public final String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The name of the maintenance window.
     * </p>
     * 
     * @return The name of the maintenance window.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the maintenance window.
     * </p>
     * 
     * @return A description of the maintenance window.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the maintenance window is enabled.
     * </p>
     * 
     * @return Indicates whether the maintenance window is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The duration of the maintenance window in hours.
     * </p>
     * 
     * @return The duration of the maintenance window in hours.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops
     * scheduling new tasks for execution.
     * </p>
     * 
     * @return The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager
     *         stops scheduling new tasks for execution.
     */
    public final Integer cutoff() {
        return cutoff;
    }

    /**
     * <p>
     * The schedule of the maintenance window in the form of a cron or rate expression.
     * </p>
     * 
     * @return The schedule of the maintenance window in the form of a cron or rate expression.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     * Authority (IANA) format.
     * </p>
     * 
     * @return The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     *         Authority (IANA) format.
     */
    public final String scheduleTimezone() {
        return scheduleTimezone;
    }

    /**
     * <p>
     * The number of days to wait to run a maintenance window after the scheduled cron expression date and time.
     * </p>
     * 
     * @return The number of days to wait to run a maintenance window after the scheduled cron expression date and time.
     */
    public final Integer scheduleOffset() {
        return scheduleOffset;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become inactive.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become
     *         inactive.
     */
    public final String endDate() {
        return endDate;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become active.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become
     *         active.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The next time the maintenance window will actually run, taking into account any specified times for the
     * maintenance window to become active or inactive.
     * </p>
     * 
     * @return The next time the maintenance window will actually run, taking into account any specified times for the
     *         maintenance window to become active or inactive.
     */
    public final String nextExecutionTime() {
        return nextExecutionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(nextExecutionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowIdentity)) {
            return false;
        }
        MaintenanceWindowIdentity other = (MaintenanceWindowIdentity) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(duration(), other.duration()) && Objects.equals(cutoff(), other.cutoff())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(scheduleTimezone(), other.scheduleTimezone())
                && Objects.equals(scheduleOffset(), other.scheduleOffset()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(startDate(), other.startDate())
                && Objects.equals(nextExecutionTime(), other.nextExecutionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceWindowIdentity").add("WindowId", windowId()).add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Enabled", enabled())
                .add("Duration", duration()).add("Cutoff", cutoff()).add("Schedule", schedule())
                .add("ScheduleTimezone", scheduleTimezone()).add("ScheduleOffset", scheduleOffset()).add("EndDate", endDate())
                .add("StartDate", startDate()).add("NextExecutionTime", nextExecutionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Cutoff":
            return Optional.ofNullable(clazz.cast(cutoff()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ScheduleTimezone":
            return Optional.ofNullable(clazz.cast(scheduleTimezone()));
        case "ScheduleOffset":
            return Optional.ofNullable(clazz.cast(scheduleOffset()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "NextExecutionTime":
            return Optional.ofNullable(clazz.cast(nextExecutionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowIdentity, T> g) {
        return obj -> g.apply((MaintenanceWindowIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindowIdentity> {
        /**
         * <p>
         * The ID of the maintenance window.
         * </p>
         * 
         * @param windowId
         *        The ID of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The name of the maintenance window.
         * </p>
         * 
         * @param name
         *        The name of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the maintenance window.
         * </p>
         * 
         * @param description
         *        A description of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the maintenance window is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the maintenance window is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The duration of the maintenance window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the maintenance window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops
         * scheduling new tasks for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager
         *        stops scheduling new tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);

        /**
         * <p>
         * The schedule of the maintenance window in the form of a cron or rate expression.
         * </p>
         * 
         * @param schedule
         *        The schedule of the maintenance window in the form of a cron or rate expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
         * Authority (IANA) format.
         * </p>
         * 
         * @param scheduleTimezone
         *        The time zone that the scheduled maintenance window executions are based on, in Internet Assigned
         *        Numbers Authority (IANA) format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleTimezone(String scheduleTimezone);

        /**
         * <p>
         * The number of days to wait to run a maintenance window after the scheduled cron expression date and time.
         * </p>
         * 
         * @param scheduleOffset
         *        The number of days to wait to run a maintenance window after the scheduled cron expression date and
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleOffset(Integer scheduleOffset);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become
         * inactive.
         * </p>
         * 
         * @param endDate
         *        The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become
         *        inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become
         * active.
         * </p>
         * 
         * @param startDate
         *        The date and time, in ISO-8601 Extended format, for when the maintenance window is scheduled to become
         *        active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The next time the maintenance window will actually run, taking into account any specified times for the
         * maintenance window to become active or inactive.
         * </p>
         * 
         * @param nextExecutionTime
         *        The next time the maintenance window will actually run, taking into account any specified times for
         *        the maintenance window to become active or inactive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextExecutionTime(String nextExecutionTime);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String name;

        private String description;

        private Boolean enabled;

        private Integer duration;

        private Integer cutoff;

        private String schedule;

        private String scheduleTimezone;

        private Integer scheduleOffset;

        private String endDate;

        private String startDate;

        private String nextExecutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowIdentity model) {
            windowId(model.windowId);
            name(model.name);
            description(model.description);
            enabled(model.enabled);
            duration(model.duration);
            cutoff(model.cutoff);
            schedule(model.schedule);
            scheduleTimezone(model.scheduleTimezone);
            scheduleOffset(model.scheduleOffset);
            endDate(model.endDate);
            startDate(model.startDate);
            nextExecutionTime(model.nextExecutionTime);
        }

        public final String getWindowId() {
            return windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getDuration() {
            return duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduleTimezone() {
            return scheduleTimezone;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final Integer getScheduleOffset() {
            return scheduleOffset;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final String getEndDate() {
            return endDate;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getStartDate() {
            return startDate;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getNextExecutionTime() {
            return nextExecutionTime;
        }

        public final void setNextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
        }

        @Override
        public final Builder nextExecutionTime(String nextExecutionTime) {
            this.nextExecutionTime = nextExecutionTime;
            return this;
        }

        @Override
        public MaintenanceWindowIdentity build() {
            return new MaintenanceWindowIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
