/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.NodeAggregatorListCopier;
import software.amazon.awssdk.services.ssm.model.NodeAggregatorType;
import software.amazon.awssdk.services.ssm.model.NodeAttributeName;
import software.amazon.awssdk.services.ssm.model.NodeTypeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeAggregator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeAggregator> {
    private static final SdkField<String> AGGREGATOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregatorType").getter(NodeAggregator.getter(NodeAggregator::aggregatorTypeAsString)).setter(NodeAggregator.setter(Builder::aggregatorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorType").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(NodeAggregator.getter(NodeAggregator::typeNameAsString)).setter(NodeAggregator.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(NodeAggregator.getter(NodeAggregator::attributeNameAsString)).setter(NodeAggregator.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<NodeAggregator>> AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aggregators").getter(NodeAggregator.getter(NodeAggregator::aggregators)).setter(NodeAggregator.setter(Builder::aggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_TYPE_FIELD, TYPE_NAME_FIELD, ATTRIBUTE_NAME_FIELD, AGGREGATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AggregatorType", AGGREGATOR_TYPE_FIELD);
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("AttributeName", ATTRIBUTE_NAME_FIELD);
            this.put("Aggregators", AGGREGATORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String aggregatorType;
    private final String typeName;
    private final String attributeName;
    private final List<NodeAggregator> aggregators;

    private NodeAggregator(BuilderImpl builder) {
        this.aggregatorType = builder.aggregatorType;
        this.typeName = builder.typeName;
        this.attributeName = builder.attributeName;
        this.aggregators = builder.aggregators;
    }

    public final NodeAggregatorType aggregatorType() {
        return NodeAggregatorType.fromValue(this.aggregatorType);
    }

    public final String aggregatorTypeAsString() {
        return this.aggregatorType;
    }

    public final NodeTypeName typeName() {
        return NodeTypeName.fromValue(this.typeName);
    }

    public final String typeNameAsString() {
        return this.typeName;
    }

    public final NodeAttributeName attributeName() {
        return NodeAttributeName.fromValue(this.attributeName);
    }

    public final String attributeNameAsString() {
        return this.attributeName;
    }

    public final boolean hasAggregators() {
        return this.aggregators != null && !(this.aggregators instanceof SdkAutoConstructList);
    }

    public final List<NodeAggregator> aggregators() {
        return this.aggregators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregators() ? this.aggregators() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeAggregator)) {
            return false;
        }
        NodeAggregator other = (NodeAggregator)obj;
        return Objects.equals(this.aggregatorTypeAsString(), other.aggregatorTypeAsString()) && Objects.equals(this.typeNameAsString(), other.typeNameAsString()) && Objects.equals(this.attributeNameAsString(), other.attributeNameAsString()) && this.hasAggregators() == other.hasAggregators() && Objects.equals(this.aggregators(), other.aggregators());
    }

    public final String toString() {
        return ToString.builder((String)"NodeAggregator").add("AggregatorType", (Object)this.aggregatorTypeAsString()).add("TypeName", (Object)this.typeNameAsString()).add("AttributeName", (Object)this.attributeNameAsString()).add("Aggregators", this.hasAggregators() ? this.aggregators() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregatorType": {
                return Optional.ofNullable(clazz.cast(this.aggregatorTypeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeNameAsString()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeNameAsString()));
            }
            case "Aggregators": {
                return Optional.ofNullable(clazz.cast(this.aggregators()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NodeAggregator, T> g) {
        return obj -> g.apply((NodeAggregator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregatorType;
        private String typeName;
        private String attributeName;
        private List<NodeAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeAggregator model) {
            this.aggregatorType(model.aggregatorType);
            this.typeName(model.typeName);
            this.attributeName(model.attributeName);
            this.aggregators(model.aggregators);
        }

        public final String getAggregatorType() {
            return this.aggregatorType;
        }

        public final void setAggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
        }

        @Override
        public final Builder aggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
            return this;
        }

        @Override
        public final Builder aggregatorType(NodeAggregatorType aggregatorType) {
            this.aggregatorType(aggregatorType == null ? null : aggregatorType.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Override
        public final Builder typeName(NodeTypeName typeName) {
            this.typeName(typeName == null ? null : typeName.toString());
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public final Builder attributeName(NodeAttributeName attributeName) {
            this.attributeName(attributeName == null ? null : attributeName.toString());
            return this;
        }

        public final List<Builder> getAggregators() {
            List<Builder> result = NodeAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = NodeAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<NodeAggregator> aggregators) {
            this.aggregators = NodeAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(NodeAggregator ... aggregators) {
            this.aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder> ... aggregators) {
            this.aggregators(Stream.of(aggregators).map(c -> (NodeAggregator)((Builder)NodeAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NodeAggregator build() {
            return new NodeAggregator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeAggregator> {
        public Builder aggregatorType(String var1);

        public Builder aggregatorType(NodeAggregatorType var1);

        public Builder typeName(String var1);

        public Builder typeName(NodeTypeName var1);

        public Builder attributeName(String var1);

        public Builder attributeName(NodeAttributeName var1);

        public Builder aggregators(Collection<NodeAggregator> var1);

        public Builder aggregators(NodeAggregator ... var1);

        public Builder aggregators(Consumer<Builder> ... var1);
    }
}

