/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a specific Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationExecutionMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationExecutionMetadata.Builder, AutomationExecutionMetadata> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomationExecutionId").getter(getter(AutomationExecutionMetadata::automationExecutionId))
            .setter(setter(Builder::automationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build())
            .build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(AutomationExecutionMetadata::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(AutomationExecutionMetadata::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomationExecutionStatus")
            .getter(getter(AutomationExecutionMetadata::automationExecutionStatusAsString))
            .setter(setter(Builder::automationExecutionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build())
            .build();

    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExecutionStartTime").getter(getter(AutomationExecutionMetadata::executionStartTime))
            .setter(setter(Builder::executionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build())
            .build();

    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExecutionEndTime").getter(getter(AutomationExecutionMetadata::executionEndTime))
            .setter(setter(Builder::executionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()).build();

    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutedBy").getter(getter(AutomationExecutionMetadata::executedBy)).setter(setter(Builder::executedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()).build();

    private static final SdkField<String> LOG_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFile").getter(getter(AutomationExecutionMetadata::logFile)).setter(setter(Builder::logFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFile").build()).build();

    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Outputs")
            .getter(getter(AutomationExecutionMetadata::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(AutomationExecutionMetadata::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> PARENT_AUTOMATION_EXECUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ParentAutomationExecutionId")
            .getter(getter(AutomationExecutionMetadata::parentAutomationExecutionId))
            .setter(setter(Builder::parentAutomationExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentAutomationExecutionId")
                    .build()).build();

    private static final SdkField<String> CURRENT_STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentStepName").getter(getter(AutomationExecutionMetadata::currentStepName))
            .setter(setter(Builder::currentStepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStepName").build()).build();

    private static final SdkField<String> CURRENT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentAction").getter(getter(AutomationExecutionMetadata::currentAction))
            .setter(setter(Builder::currentAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAction").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(AutomationExecutionMetadata::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetParameterName").getter(getter(AutomationExecutionMetadata::targetParameterName))
            .setter(setter(Builder::targetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build())
            .build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(AutomationExecutionMetadata::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField
            .<List<Map<String, List<String>>>> builder(MarshallingType.LIST)
            .memberName("TargetMaps")
            .getter(getter(AutomationExecutionMetadata::targetMaps))
            .setter(setter(Builder::targetMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<ResolvedTargets> RESOLVED_TARGETS_FIELD = SdkField
            .<ResolvedTargets> builder(MarshallingType.SDK_POJO).memberName("ResolvedTargets")
            .getter(getter(AutomationExecutionMetadata::resolvedTargets)).setter(setter(Builder::resolvedTargets))
            .constructor(ResolvedTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedTargets").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(AutomationExecutionMetadata::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(AutomationExecutionMetadata::maxErrors)).setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(AutomationExecutionMetadata::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> AUTOMATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomationType").getter(getter(AutomationExecutionMetadata::automationTypeAsString))
            .setter(setter(Builder::automationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationType").build()).build();

    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField
            .<AlarmConfiguration> builder(MarshallingType.SDK_POJO).memberName("AlarmConfiguration")
            .getter(getter(AutomationExecutionMetadata::alarmConfiguration)).setter(setter(Builder::alarmConfiguration))
            .constructor(AlarmConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build())
            .build();

    private static final SdkField<List<AlarmStateInformation>> TRIGGERED_ALARMS_FIELD = SdkField
            .<List<AlarmStateInformation>> builder(MarshallingType.LIST)
            .memberName("TriggeredAlarms")
            .getter(getter(AutomationExecutionMetadata::triggeredAlarms))
            .setter(setter(Builder::triggeredAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredAlarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlarmStateInformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlarmStateInformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_LOCATIONS_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetLocationsURL").getter(getter(AutomationExecutionMetadata::targetLocationsURL))
            .setter(setter(Builder::targetLocationsURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocationsURL").build())
            .build();

    private static final SdkField<String> AUTOMATION_SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutomationSubtype").getter(getter(AutomationExecutionMetadata::automationSubtypeAsString))
            .setter(setter(Builder::automationSubtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationSubtype").build()).build();

    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledTime").getter(getter(AutomationExecutionMetadata::scheduledTime))
            .setter(setter(Builder::scheduledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()).build();

    private static final SdkField<List<Runbook>> RUNBOOKS_FIELD = SdkField
            .<List<Runbook>> builder(MarshallingType.LIST)
            .memberName("Runbooks")
            .getter(getter(AutomationExecutionMetadata::runbooks))
            .setter(setter(Builder::runbooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runbooks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Runbook> builder(MarshallingType.SDK_POJO)
                                            .constructor(Runbook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(AutomationExecutionMetadata::opsItemId)).setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(AutomationExecutionMetadata::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> CHANGE_REQUEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeRequestName").getter(getter(AutomationExecutionMetadata::changeRequestName))
            .setter(setter(Builder::changeRequestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeRequestName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD,
            DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, EXECUTION_START_TIME_FIELD,
            EXECUTION_END_TIME_FIELD, EXECUTED_BY_FIELD, LOG_FILE_FIELD, OUTPUTS_FIELD, MODE_FIELD,
            PARENT_AUTOMATION_EXECUTION_ID_FIELD, CURRENT_STEP_NAME_FIELD, CURRENT_ACTION_FIELD, FAILURE_MESSAGE_FIELD,
            TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, RESOLVED_TARGETS_FIELD, MAX_CONCURRENCY_FIELD,
            MAX_ERRORS_FIELD, TARGET_FIELD, AUTOMATION_TYPE_FIELD, ALARM_CONFIGURATION_FIELD, TRIGGERED_ALARMS_FIELD,
            TARGET_LOCATIONS_URL_FIELD, AUTOMATION_SUBTYPE_FIELD, SCHEDULED_TIME_FIELD, RUNBOOKS_FIELD, OPS_ITEM_ID_FIELD,
            ASSOCIATION_ID_FIELD, CHANGE_REQUEST_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AutomationExecutionId", AUTOMATION_EXECUTION_ID_FIELD);
                    put("DocumentName", DOCUMENT_NAME_FIELD);
                    put("DocumentVersion", DOCUMENT_VERSION_FIELD);
                    put("AutomationExecutionStatus", AUTOMATION_EXECUTION_STATUS_FIELD);
                    put("ExecutionStartTime", EXECUTION_START_TIME_FIELD);
                    put("ExecutionEndTime", EXECUTION_END_TIME_FIELD);
                    put("ExecutedBy", EXECUTED_BY_FIELD);
                    put("LogFile", LOG_FILE_FIELD);
                    put("Outputs", OUTPUTS_FIELD);
                    put("Mode", MODE_FIELD);
                    put("ParentAutomationExecutionId", PARENT_AUTOMATION_EXECUTION_ID_FIELD);
                    put("CurrentStepName", CURRENT_STEP_NAME_FIELD);
                    put("CurrentAction", CURRENT_ACTION_FIELD);
                    put("FailureMessage", FAILURE_MESSAGE_FIELD);
                    put("TargetParameterName", TARGET_PARAMETER_NAME_FIELD);
                    put("Targets", TARGETS_FIELD);
                    put("TargetMaps", TARGET_MAPS_FIELD);
                    put("ResolvedTargets", RESOLVED_TARGETS_FIELD);
                    put("MaxConcurrency", MAX_CONCURRENCY_FIELD);
                    put("MaxErrors", MAX_ERRORS_FIELD);
                    put("Target", TARGET_FIELD);
                    put("AutomationType", AUTOMATION_TYPE_FIELD);
                    put("AlarmConfiguration", ALARM_CONFIGURATION_FIELD);
                    put("TriggeredAlarms", TRIGGERED_ALARMS_FIELD);
                    put("TargetLocationsURL", TARGET_LOCATIONS_URL_FIELD);
                    put("AutomationSubtype", AUTOMATION_SUBTYPE_FIELD);
                    put("ScheduledTime", SCHEDULED_TIME_FIELD);
                    put("Runbooks", RUNBOOKS_FIELD);
                    put("OpsItemId", OPS_ITEM_ID_FIELD);
                    put("AssociationId", ASSOCIATION_ID_FIELD);
                    put("ChangeRequestName", CHANGE_REQUEST_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String automationExecutionId;

    private final String documentName;

    private final String documentVersion;

    private final String automationExecutionStatus;

    private final Instant executionStartTime;

    private final Instant executionEndTime;

    private final String executedBy;

    private final String logFile;

    private final Map<String, List<String>> outputs;

    private final String mode;

    private final String parentAutomationExecutionId;

    private final String currentStepName;

    private final String currentAction;

    private final String failureMessage;

    private final String targetParameterName;

    private final List<Target> targets;

    private final List<Map<String, List<String>>> targetMaps;

    private final ResolvedTargets resolvedTargets;

    private final String maxConcurrency;

    private final String maxErrors;

    private final String target;

    private final String automationType;

    private final AlarmConfiguration alarmConfiguration;

    private final List<AlarmStateInformation> triggeredAlarms;

    private final String targetLocationsURL;

    private final String automationSubtype;

    private final Instant scheduledTime;

    private final List<Runbook> runbooks;

    private final String opsItemId;

    private final String associationId;

    private final String changeRequestName;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
        this.mode = builder.mode;
        this.parentAutomationExecutionId = builder.parentAutomationExecutionId;
        this.currentStepName = builder.currentStepName;
        this.currentAction = builder.currentAction;
        this.failureMessage = builder.failureMessage;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.resolvedTargets = builder.resolvedTargets;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.target = builder.target;
        this.automationType = builder.automationType;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.triggeredAlarms = builder.triggeredAlarms;
        this.targetLocationsURL = builder.targetLocationsURL;
        this.automationSubtype = builder.automationSubtype;
        this.scheduledTime = builder.scheduledTime;
        this.runbooks = builder.runbooks;
        this.opsItemId = builder.opsItemId;
        this.associationId = builder.associationId;
        this.changeRequestName = builder.changeRequestName;
    }

    /**
     * <p>
     * The execution ID.
     * </p>
     * 
     * @return The execution ID.
     */
    public final String automationExecutionId() {
        return automationExecutionId;
    }

    /**
     * <p>
     * The name of the Automation runbook used during execution.
     * </p>
     * 
     * @return The name of the Automation runbook used during execution.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The document version used during the execution.
     * </p>
     * 
     * @return The document version used during the execution.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the execution.
     * @see AutomationExecutionStatus
     */
    public final AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(automationExecutionStatus);
    }

    /**
     * <p>
     * The status of the execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #automationExecutionStatus} will return {@link AutomationExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #automationExecutionStatusAsString}.
     * </p>
     * 
     * @return The status of the execution.
     * @see AutomationExecutionStatus
     */
    public final String automationExecutionStatusAsString() {
        return automationExecutionStatus;
    }

    /**
     * <p>
     * The time the execution started.
     * </p>
     * 
     * @return The time the execution started.
     */
    public final Instant executionStartTime() {
        return executionStartTime;
    }

    /**
     * <p>
     * The time the execution finished. This isn't populated if the execution is still in progress.
     * </p>
     * 
     * @return The time the execution finished. This isn't populated if the execution is still in progress.
     */
    public final Instant executionEndTime() {
        return executionEndTime;
    }

    /**
     * <p>
     * The IAM role ARN of the user who ran the automation.
     * </p>
     * 
     * @return The IAM role ARN of the user who ran the automation.
     */
    public final String executedBy() {
        return executedBy;
    }

    /**
     * <p>
     * An S3 bucket where execution information is stored.
     * </p>
     * 
     * @return An S3 bucket where execution information is stored.
     */
    public final String logFile() {
        return logFile;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation runbook.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation runbook.
     */
    public final Map<String, List<String>> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The Automation execution mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The Automation execution mode.
     * @see ExecutionMode
     */
    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(mode);
    }

    /**
     * <p>
     * The Automation execution mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The Automation execution mode.
     * @see ExecutionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The execution ID of the parent automation.
     * </p>
     * 
     * @return The execution ID of the parent automation.
     */
    public final String parentAutomationExecutionId() {
        return parentAutomationExecutionId;
    }

    /**
     * <p>
     * The name of the step that is currently running.
     * </p>
     * 
     * @return The name of the step that is currently running.
     */
    public final String currentStepName() {
        return currentStepName;
    }

    /**
     * <p>
     * The action of the step that is currently running.
     * </p>
     * 
     * @return The action of the step that is currently running.
     */
    public final String currentAction() {
        return currentAction;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation runbook.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation runbook.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation runbook.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation runbook.
     */
    public final String targetParameterName() {
        return targetParameterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets defined by the user when starting the automation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets defined by the user when starting the automation.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetMaps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetMaps() {
        return targetMaps != null && !(targetMaps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specified key-value mapping of document parameters to target resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetMaps} method.
     * </p>
     * 
     * @return The specified key-value mapping of document parameters to target resources.
     */
    public final List<Map<String, List<String>>> targetMaps() {
        return targetMaps;
    }

    /**
     * <p>
     * A list of targets that resolved during the execution.
     * </p>
     * 
     * @return A list of targets that resolved during the execution.
     */
    public final ResolvedTargets resolvedTargets() {
        return resolvedTargets;
    }

    /**
     * <p>
     * The <code>MaxConcurrency</code> value specified by the user when starting the automation.
     * </p>
     * 
     * @return The <code>MaxConcurrency</code> value specified by the user when starting the automation.
     */
    public final String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The <code>MaxErrors</code> value specified by the user when starting the automation.
     * </p>
     * 
     * @return The <code>MaxErrors</code> value specified by the user when starting the automation.
     */
    public final String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The list of execution outputs as defined in the Automation runbook.
     * </p>
     * 
     * @return The list of execution outputs as defined in the Automation runbook.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount. CrossAccount is
     * an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services accounts. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
     * >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web Services
     * Systems Manager User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automationType}
     * will return {@link AutomationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #automationTypeAsString}.
     * </p>
     * 
     * @return Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount.
     *         CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services
     *         accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
     *         >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web
     *         Services Systems Manager User Guide</i>.
     * @see AutomationType
     */
    public final AutomationType automationType() {
        return AutomationType.fromValue(automationType);
    }

    /**
     * <p>
     * Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount. CrossAccount is
     * an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services accounts. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
     * >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web Services
     * Systems Manager User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automationType}
     * will return {@link AutomationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #automationTypeAsString}.
     * </p>
     * 
     * @return Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount.
     *         CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services
     *         accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
     *         >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web
     *         Services Systems Manager User Guide</i>.
     * @see AutomationType
     */
    public final String automationTypeAsString() {
        return automationType;
    }

    /**
     * <p>
     * The details for the CloudWatch alarm applied to your automation.
     * </p>
     * 
     * @return The details for the CloudWatch alarm applied to your automation.
     */
    public final AlarmConfiguration alarmConfiguration() {
        return alarmConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the TriggeredAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTriggeredAlarms() {
        return triggeredAlarms != null && !(triggeredAlarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CloudWatch alarm that was invoked by the automation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggeredAlarms} method.
     * </p>
     * 
     * @return The CloudWatch alarm that was invoked by the automation.
     */
    public final List<AlarmStateInformation> triggeredAlarms() {
        return triggeredAlarms;
    }

    /**
     * <p>
     * A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently, only files
     * in presigned Amazon S3 buckets are supported
     * </p>
     * 
     * @return A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently, only
     *         files in presigned Amazon S3 buckets are supported
     */
    public final String targetLocationsURL() {
        return targetLocationsURL;
    }

    /**
     * <p>
     * The subtype of the Automation operation. Currently, the only supported value is <code>ChangeRequest</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automationSubtype}
     * will return {@link AutomationSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #automationSubtypeAsString}.
     * </p>
     * 
     * @return The subtype of the Automation operation. Currently, the only supported value is
     *         <code>ChangeRequest</code>.
     * @see AutomationSubtype
     */
    public final AutomationSubtype automationSubtype() {
        return AutomationSubtype.fromValue(automationSubtype);
    }

    /**
     * <p>
     * The subtype of the Automation operation. Currently, the only supported value is <code>ChangeRequest</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #automationSubtype}
     * will return {@link AutomationSubtype#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #automationSubtypeAsString}.
     * </p>
     * 
     * @return The subtype of the Automation operation. Currently, the only supported value is
     *         <code>ChangeRequest</code>.
     * @see AutomationSubtype
     */
    public final String automationSubtypeAsString() {
        return automationSubtype;
    }

    /**
     * <p>
     * The date and time the Automation operation is scheduled to start.
     * </p>
     * 
     * @return The date and time the Automation operation is scheduled to start.
     */
    public final Instant scheduledTime() {
        return scheduledTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Runbooks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRunbooks() {
        return runbooks != null && !(runbooks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Automation runbooks that are run during a runbook workflow in Change Manager.
     * </p>
     * <note>
     * <p>
     * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change
     * request have been received.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRunbooks} method.
     * </p>
     * 
     * @return Information about the Automation runbooks that are run during a runbook workflow in Change Manager.</p>
     *         <note>
     *         <p>
     *         The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
     *         change request have been received.
     *         </p>
     */
    public final List<Runbook> runbooks() {
        return runbooks;
    }

    /**
     * <p>
     * The ID of an OpsItem that is created to represent a Change Manager change request.
     * </p>
     * 
     * @return The ID of an OpsItem that is created to represent a Change Manager change request.
     */
    public final String opsItemId() {
        return opsItemId;
    }

    /**
     * <p>
     * The ID of a State Manager association used in the Automation operation.
     * </p>
     * 
     * @return The ID of a State Manager association used in the Automation operation.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The name of the Change Manager change request.
     * </p>
     * 
     * @return The name of the Change Manager change request.
     */
    public final String changeRequestName() {
        return changeRequestName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(logFile());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parentAutomationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(currentStepName());
        hashCode = 31 * hashCode + Objects.hashCode(currentAction());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetMaps() ? targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolvedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(automationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggeredAlarms() ? triggeredAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetLocationsURL());
        hashCode = 31 * hashCode + Objects.hashCode(automationSubtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasRunbooks() ? runbooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(changeRequestName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata) obj;
        return Objects.equals(automationExecutionId(), other.automationExecutionId())
                && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(automationExecutionStatusAsString(), other.automationExecutionStatusAsString())
                && Objects.equals(executionStartTime(), other.executionStartTime())
                && Objects.equals(executionEndTime(), other.executionEndTime())
                && Objects.equals(executedBy(), other.executedBy()) && Objects.equals(logFile(), other.logFile())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(parentAutomationExecutionId(), other.parentAutomationExecutionId())
                && Objects.equals(currentStepName(), other.currentStepName())
                && Objects.equals(currentAction(), other.currentAction())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(targetParameterName(), other.targetParameterName()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && hasTargetMaps() == other.hasTargetMaps()
                && Objects.equals(targetMaps(), other.targetMaps()) && Objects.equals(resolvedTargets(), other.resolvedTargets())
                && Objects.equals(maxConcurrency(), other.maxConcurrency()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(target(), other.target())
                && Objects.equals(automationTypeAsString(), other.automationTypeAsString())
                && Objects.equals(alarmConfiguration(), other.alarmConfiguration())
                && hasTriggeredAlarms() == other.hasTriggeredAlarms()
                && Objects.equals(triggeredAlarms(), other.triggeredAlarms())
                && Objects.equals(targetLocationsURL(), other.targetLocationsURL())
                && Objects.equals(automationSubtypeAsString(), other.automationSubtypeAsString())
                && Objects.equals(scheduledTime(), other.scheduledTime()) && hasRunbooks() == other.hasRunbooks()
                && Objects.equals(runbooks(), other.runbooks()) && Objects.equals(opsItemId(), other.opsItemId())
                && Objects.equals(associationId(), other.associationId())
                && Objects.equals(changeRequestName(), other.changeRequestName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationExecutionMetadata").add("AutomationExecutionId", automationExecutionId())
                .add("DocumentName", documentName()).add("DocumentVersion", documentVersion())
                .add("AutomationExecutionStatus", automationExecutionStatusAsString())
                .add("ExecutionStartTime", executionStartTime()).add("ExecutionEndTime", executionEndTime())
                .add("ExecutedBy", executedBy()).add("LogFile", logFile()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("Mode", modeAsString()).add("ParentAutomationExecutionId", parentAutomationExecutionId())
                .add("CurrentStepName", currentStepName()).add("CurrentAction", currentAction())
                .add("FailureMessage", failureMessage()).add("TargetParameterName", targetParameterName())
                .add("Targets", hasTargets() ? targets() : null).add("TargetMaps", hasTargetMaps() ? targetMaps() : null)
                .add("ResolvedTargets", resolvedTargets()).add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors())
                .add("Target", target()).add("AutomationType", automationTypeAsString())
                .add("AlarmConfiguration", alarmConfiguration())
                .add("TriggeredAlarms", hasTriggeredAlarms() ? triggeredAlarms() : null)
                .add("TargetLocationsURL", targetLocationsURL()).add("AutomationSubtype", automationSubtypeAsString())
                .add("ScheduledTime", scheduledTime()).add("Runbooks", hasRunbooks() ? runbooks() : null)
                .add("OpsItemId", opsItemId()).add("AssociationId", associationId())
                .add("ChangeRequestName", changeRequestName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecutionId":
            return Optional.ofNullable(clazz.cast(automationExecutionId()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "AutomationExecutionStatus":
            return Optional.ofNullable(clazz.cast(automationExecutionStatusAsString()));
        case "ExecutionStartTime":
            return Optional.ofNullable(clazz.cast(executionStartTime()));
        case "ExecutionEndTime":
            return Optional.ofNullable(clazz.cast(executionEndTime()));
        case "ExecutedBy":
            return Optional.ofNullable(clazz.cast(executedBy()));
        case "LogFile":
            return Optional.ofNullable(clazz.cast(logFile()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "ParentAutomationExecutionId":
            return Optional.ofNullable(clazz.cast(parentAutomationExecutionId()));
        case "CurrentStepName":
            return Optional.ofNullable(clazz.cast(currentStepName()));
        case "CurrentAction":
            return Optional.ofNullable(clazz.cast(currentAction()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "TargetParameterName":
            return Optional.ofNullable(clazz.cast(targetParameterName()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TargetMaps":
            return Optional.ofNullable(clazz.cast(targetMaps()));
        case "ResolvedTargets":
            return Optional.ofNullable(clazz.cast(resolvedTargets()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "AutomationType":
            return Optional.ofNullable(clazz.cast(automationTypeAsString()));
        case "AlarmConfiguration":
            return Optional.ofNullable(clazz.cast(alarmConfiguration()));
        case "TriggeredAlarms":
            return Optional.ofNullable(clazz.cast(triggeredAlarms()));
        case "TargetLocationsURL":
            return Optional.ofNullable(clazz.cast(targetLocationsURL()));
        case "AutomationSubtype":
            return Optional.ofNullable(clazz.cast(automationSubtypeAsString()));
        case "ScheduledTime":
            return Optional.ofNullable(clazz.cast(scheduledTime()));
        case "Runbooks":
            return Optional.ofNullable(clazz.cast(runbooks()));
        case "OpsItemId":
            return Optional.ofNullable(clazz.cast(opsItemId()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "ChangeRequestName":
            return Optional.ofNullable(clazz.cast(changeRequestName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionMetadata, T> g) {
        return obj -> g.apply((AutomationExecutionMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationExecutionMetadata> {
        /**
         * <p>
         * The execution ID.
         * </p>
         * 
         * @param automationExecutionId
         *        The execution ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecutionId(String automationExecutionId);

        /**
         * <p>
         * The name of the Automation runbook used during execution.
         * </p>
         * 
         * @param documentName
         *        The name of the Automation runbook used during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The document version used during the execution.
         * </p>
         * 
         * @param documentVersion
         *        The document version used during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The status of the execution.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(String automationExecutionStatus);

        /**
         * <p>
         * The status of the execution.
         * </p>
         * 
         * @param automationExecutionStatus
         *        The status of the execution.
         * @see AutomationExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationExecutionStatus
         */
        Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus);

        /**
         * <p>
         * The time the execution started.
         * </p>
         * 
         * @param executionStartTime
         *        The time the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartTime(Instant executionStartTime);

        /**
         * <p>
         * The time the execution finished. This isn't populated if the execution is still in progress.
         * </p>
         * 
         * @param executionEndTime
         *        The time the execution finished. This isn't populated if the execution is still in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndTime(Instant executionEndTime);

        /**
         * <p>
         * The IAM role ARN of the user who ran the automation.
         * </p>
         * 
         * @param executedBy
         *        The IAM role ARN of the user who ran the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedBy(String executedBy);

        /**
         * <p>
         * An S3 bucket where execution information is stored.
         * </p>
         * 
         * @param logFile
         *        An S3 bucket where execution information is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFile(String logFile);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation runbook.
         * </p>
         * 
         * @param outputs
         *        The list of execution outputs as defined in the Automation runbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Map<String, ? extends Collection<String>> outputs);

        /**
         * <p>
         * The Automation execution mode.
         * </p>
         * 
         * @param mode
         *        The Automation execution mode.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The Automation execution mode.
         * </p>
         * 
         * @param mode
         *        The Automation execution mode.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(ExecutionMode mode);

        /**
         * <p>
         * The execution ID of the parent automation.
         * </p>
         * 
         * @param parentAutomationExecutionId
         *        The execution ID of the parent automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentAutomationExecutionId(String parentAutomationExecutionId);

        /**
         * <p>
         * The name of the step that is currently running.
         * </p>
         * 
         * @param currentStepName
         *        The name of the step that is currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentStepName(String currentStepName);

        /**
         * <p>
         * The action of the step that is currently running.
         * </p>
         * 
         * @param currentAction
         *        The action of the step that is currently running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAction(String currentAction);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation runbook.
         * </p>
         * 
         * @param failureMessage
         *        The list of execution outputs as defined in the Automation runbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation runbook.
         * </p>
         * 
         * @param targetParameterName
         *        The list of execution outputs as defined in the Automation runbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameterName(String targetParameterName);

        /**
         * <p>
         * The targets defined by the user when starting the automation.
         * </p>
         * 
         * @param targets
         *        The targets defined by the user when starting the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets defined by the user when starting the automation.
         * </p>
         * 
         * @param targets
         *        The targets defined by the user when starting the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The targets defined by the user when starting the automation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Target.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ssm.model.Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ssm.model.Target.Builder#build()}
         * is called immediately and its result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(java.util.Collection<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The specified key-value mapping of document parameters to target resources.
         * </p>
         * 
         * @param targetMaps
         *        The specified key-value mapping of document parameters to target resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps);

        /**
         * <p>
         * The specified key-value mapping of document parameters to target resources.
         * </p>
         * 
         * @param targetMaps
         *        The specified key-value mapping of document parameters to target resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps);

        /**
         * <p>
         * A list of targets that resolved during the execution.
         * </p>
         * 
         * @param resolvedTargets
         *        A list of targets that resolved during the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedTargets(ResolvedTargets resolvedTargets);

        /**
         * <p>
         * A list of targets that resolved during the execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResolvedTargets.Builder} avoiding the
         * need to create one manually via {@link ResolvedTargets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResolvedTargets.Builder#build()} is called immediately and its
         * result is passed to {@link #resolvedTargets(ResolvedTargets)}.
         * 
         * @param resolvedTargets
         *        a consumer that will call methods on {@link ResolvedTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvedTargets(ResolvedTargets)
         */
        default Builder resolvedTargets(Consumer<ResolvedTargets.Builder> resolvedTargets) {
            return resolvedTargets(ResolvedTargets.builder().applyMutation(resolvedTargets).build());
        }

        /**
         * <p>
         * The <code>MaxConcurrency</code> value specified by the user when starting the automation.
         * </p>
         * 
         * @param maxConcurrency
         *        The <code>MaxConcurrency</code> value specified by the user when starting the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The <code>MaxErrors</code> value specified by the user when starting the automation.
         * </p>
         * 
         * @param maxErrors
         *        The <code>MaxErrors</code> value specified by the user when starting the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The list of execution outputs as defined in the Automation runbook.
         * </p>
         * 
         * @param target
         *        The list of execution outputs as defined in the Automation runbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount. CrossAccount
         * is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services accounts. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         * >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web Services
         * Systems Manager User Guide</i>.
         * </p>
         * 
         * @param automationType
         *        Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount.
         *        CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web
         *        Services accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         *        >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web
         *        Services Systems Manager User Guide</i>.
         * @see AutomationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationType
         */
        Builder automationType(String automationType);

        /**
         * <p>
         * Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount. CrossAccount
         * is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web Services accounts. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         * >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web Services
         * Systems Manager User Guide</i>.
         * </p>
         * 
         * @param automationType
         *        Use this filter with <a>DescribeAutomationExecutions</a>. Specify either Local or CrossAccount.
         *        CrossAccount is an Automation that runs in multiple Amazon Web Services Regions and Amazon Web
         *        Services accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         *        >Running automations in multiple Amazon Web Services Regions and accounts</a> in the <i>Amazon Web
         *        Services Systems Manager User Guide</i>.
         * @see AutomationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationType
         */
        Builder automationType(AutomationType automationType);

        /**
         * <p>
         * The details for the CloudWatch alarm applied to your automation.
         * </p>
         * 
         * @param alarmConfiguration
         *        The details for the CloudWatch alarm applied to your automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmConfiguration(AlarmConfiguration alarmConfiguration);

        /**
         * <p>
         * The details for the CloudWatch alarm applied to your automation.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlarmConfiguration.Builder} avoiding the
         * need to create one manually via {@link AlarmConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AlarmConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #alarmConfiguration(AlarmConfiguration)}.
         * 
         * @param alarmConfiguration
         *        a consumer that will call methods on {@link AlarmConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmConfiguration(AlarmConfiguration)
         */
        default Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return alarmConfiguration(AlarmConfiguration.builder().applyMutation(alarmConfiguration).build());
        }

        /**
         * <p>
         * The CloudWatch alarm that was invoked by the automation.
         * </p>
         * 
         * @param triggeredAlarms
         *        The CloudWatch alarm that was invoked by the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms);

        /**
         * <p>
         * The CloudWatch alarm that was invoked by the automation.
         * </p>
         * 
         * @param triggeredAlarms
         *        The CloudWatch alarm that was invoked by the automation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggeredAlarms(AlarmStateInformation... triggeredAlarms);

        /**
         * <p>
         * The CloudWatch alarm that was invoked by the automation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.AlarmStateInformation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssm.model.AlarmStateInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.AlarmStateInformation.Builder#build()} is called immediately
         * and its result is passed to {@link #triggeredAlarms(List<AlarmStateInformation>)}.
         * 
         * @param triggeredAlarms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.AlarmStateInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggeredAlarms(java.util.Collection<AlarmStateInformation>)
         */
        Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder>... triggeredAlarms);

        /**
         * <p>
         * A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently, only
         * files in presigned Amazon S3 buckets are supported
         * </p>
         * 
         * @param targetLocationsURL
         *        A publicly accessible URL for a file that contains the <code>TargetLocations</code> body. Currently,
         *        only files in presigned Amazon S3 buckets are supported
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocationsURL(String targetLocationsURL);

        /**
         * <p>
         * The subtype of the Automation operation. Currently, the only supported value is <code>ChangeRequest</code>.
         * </p>
         * 
         * @param automationSubtype
         *        The subtype of the Automation operation. Currently, the only supported value is
         *        <code>ChangeRequest</code>.
         * @see AutomationSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationSubtype
         */
        Builder automationSubtype(String automationSubtype);

        /**
         * <p>
         * The subtype of the Automation operation. Currently, the only supported value is <code>ChangeRequest</code>.
         * </p>
         * 
         * @param automationSubtype
         *        The subtype of the Automation operation. Currently, the only supported value is
         *        <code>ChangeRequest</code>.
         * @see AutomationSubtype
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationSubtype
         */
        Builder automationSubtype(AutomationSubtype automationSubtype);

        /**
         * <p>
         * The date and time the Automation operation is scheduled to start.
         * </p>
         * 
         * @param scheduledTime
         *        The date and time the Automation operation is scheduled to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTime(Instant scheduledTime);

        /**
         * <p>
         * Information about the Automation runbooks that are run during a runbook workflow in Change Manager.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note>
         * 
         * @param runbooks
         *        Information about the Automation runbooks that are run during a runbook workflow in Change
         *        Manager.</p> <note>
         *        <p>
         *        The Automation runbooks specified for the runbook workflow can't run until all required approvals for
         *        the change request have been received.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runbooks(Collection<Runbook> runbooks);

        /**
         * <p>
         * Information about the Automation runbooks that are run during a runbook workflow in Change Manager.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note>
         * 
         * @param runbooks
         *        Information about the Automation runbooks that are run during a runbook workflow in Change
         *        Manager.</p> <note>
         *        <p>
         *        The Automation runbooks specified for the runbook workflow can't run until all required approvals for
         *        the change request have been received.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runbooks(Runbook... runbooks);

        /**
         * <p>
         * Information about the Automation runbooks that are run during a runbook workflow in Change Manager.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.Runbook.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ssm.model.Runbook#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.Runbook.Builder#build()} is called immediately and its
         * result is passed to {@link #runbooks(List<Runbook>)}.
         * 
         * @param runbooks
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ssm.model.Runbook.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runbooks(java.util.Collection<Runbook>)
         */
        Builder runbooks(Consumer<Runbook.Builder>... runbooks);

        /**
         * <p>
         * The ID of an OpsItem that is created to represent a Change Manager change request.
         * </p>
         * 
         * @param opsItemId
         *        The ID of an OpsItem that is created to represent a Change Manager change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        /**
         * <p>
         * The ID of a State Manager association used in the Automation operation.
         * </p>
         * 
         * @param associationId
         *        The ID of a State Manager association used in the Automation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The name of the Change Manager change request.
         * </p>
         * 
         * @param changeRequestName
         *        The name of the Change Manager change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequestName(String changeRequestName);
    }

    static final class BuilderImpl implements Builder {
        private String automationExecutionId;

        private String documentName;

        private String documentVersion;

        private String automationExecutionStatus;

        private Instant executionStartTime;

        private Instant executionEndTime;

        private String executedBy;

        private String logFile;

        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();

        private String mode;

        private String parentAutomationExecutionId;

        private String currentStepName;

        private String currentAction;

        private String failureMessage;

        private String targetParameterName;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();

        private ResolvedTargets resolvedTargets;

        private String maxConcurrency;

        private String maxErrors;

        private String target;

        private String automationType;

        private AlarmConfiguration alarmConfiguration;

        private List<AlarmStateInformation> triggeredAlarms = DefaultSdkAutoConstructList.getInstance();

        private String targetLocationsURL;

        private String automationSubtype;

        private Instant scheduledTime;

        private List<Runbook> runbooks = DefaultSdkAutoConstructList.getInstance();

        private String opsItemId;

        private String associationId;

        private String changeRequestName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            automationExecutionId(model.automationExecutionId);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            automationExecutionStatus(model.automationExecutionStatus);
            executionStartTime(model.executionStartTime);
            executionEndTime(model.executionEndTime);
            executedBy(model.executedBy);
            logFile(model.logFile);
            outputs(model.outputs);
            mode(model.mode);
            parentAutomationExecutionId(model.parentAutomationExecutionId);
            currentStepName(model.currentStepName);
            currentAction(model.currentAction);
            failureMessage(model.failureMessage);
            targetParameterName(model.targetParameterName);
            targets(model.targets);
            targetMaps(model.targetMaps);
            resolvedTargets(model.resolvedTargets);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            target(model.target);
            automationType(model.automationType);
            alarmConfiguration(model.alarmConfiguration);
            triggeredAlarms(model.triggeredAlarms);
            targetLocationsURL(model.targetLocationsURL);
            automationSubtype(model.automationSubtype);
            scheduledTime(model.scheduledTime);
            runbooks(model.runbooks);
            opsItemId(model.opsItemId);
            associationId(model.associationId);
            changeRequestName(model.changeRequestName);
        }

        public final String getAutomationExecutionId() {
            return automationExecutionId;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getAutomationExecutionStatus() {
            return automationExecutionStatus;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus == null ? null : automationExecutionStatus.toString());
            return this;
        }

        public final Instant getExecutionStartTime() {
            return executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final String getExecutedBy() {
            return executedBy;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final String getLogFile() {
            return logFile;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            if (outputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return outputs;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getParentAutomationExecutionId() {
            return parentAutomationExecutionId;
        }

        public final void setParentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
        }

        @Override
        public final Builder parentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
            return this;
        }

        public final String getCurrentStepName() {
            return currentStepName;
        }

        public final void setCurrentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
        }

        @Override
        public final Builder currentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
            return this;
        }

        public final String getCurrentAction() {
            return currentAction;
        }

        public final void setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
        }

        @Override
        public final Builder currentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getTargetParameterName() {
            return targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps) {
            targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final ResolvedTargets.Builder getResolvedTargets() {
            return resolvedTargets != null ? resolvedTargets.toBuilder() : null;
        }

        public final void setResolvedTargets(ResolvedTargets.BuilderImpl resolvedTargets) {
            this.resolvedTargets = resolvedTargets != null ? resolvedTargets.build() : null;
        }

        @Override
        public final Builder resolvedTargets(ResolvedTargets resolvedTargets) {
            this.resolvedTargets = resolvedTargets;
            return this;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getAutomationType() {
            return automationType;
        }

        public final void setAutomationType(String automationType) {
            this.automationType = automationType;
        }

        @Override
        public final Builder automationType(String automationType) {
            this.automationType = automationType;
            return this;
        }

        @Override
        public final Builder automationType(AutomationType automationType) {
            this.automationType(automationType == null ? null : automationType.toString());
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return alarmConfiguration != null ? alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final List<AlarmStateInformation.Builder> getTriggeredAlarms() {
            List<AlarmStateInformation.Builder> result = AlarmStateInformationListCopier.copyToBuilder(this.triggeredAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggeredAlarms(Collection<AlarmStateInformation.BuilderImpl> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copyFromBuilder(triggeredAlarms);
        }

        @Override
        public final Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copy(triggeredAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(AlarmStateInformation... triggeredAlarms) {
            triggeredAlarms(Arrays.asList(triggeredAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder>... triggeredAlarms) {
            triggeredAlarms(Stream.of(triggeredAlarms).map(c -> AlarmStateInformation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTargetLocationsURL() {
            return targetLocationsURL;
        }

        public final void setTargetLocationsURL(String targetLocationsURL) {
            this.targetLocationsURL = targetLocationsURL;
        }

        @Override
        public final Builder targetLocationsURL(String targetLocationsURL) {
            this.targetLocationsURL = targetLocationsURL;
            return this;
        }

        public final String getAutomationSubtype() {
            return automationSubtype;
        }

        public final void setAutomationSubtype(String automationSubtype) {
            this.automationSubtype = automationSubtype;
        }

        @Override
        public final Builder automationSubtype(String automationSubtype) {
            this.automationSubtype = automationSubtype;
            return this;
        }

        @Override
        public final Builder automationSubtype(AutomationSubtype automationSubtype) {
            this.automationSubtype(automationSubtype == null ? null : automationSubtype.toString());
            return this;
        }

        public final Instant getScheduledTime() {
            return scheduledTime;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final List<Runbook.Builder> getRunbooks() {
            List<Runbook.Builder> result = RunbooksCopier.copyToBuilder(this.runbooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRunbooks(Collection<Runbook.BuilderImpl> runbooks) {
            this.runbooks = RunbooksCopier.copyFromBuilder(runbooks);
        }

        @Override
        public final Builder runbooks(Collection<Runbook> runbooks) {
            this.runbooks = RunbooksCopier.copy(runbooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Runbook... runbooks) {
            runbooks(Arrays.asList(runbooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Consumer<Runbook.Builder>... runbooks) {
            runbooks(Stream.of(runbooks).map(c -> Runbook.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getChangeRequestName() {
            return changeRequestName;
        }

        public final void setChangeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
        }

        @Override
        public final Builder changeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
            return this;
        }

        @Override
        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
