/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCommandInvocationsResponse extends SsmResponse implements
        ToCopyableBuilder<ListCommandInvocationsResponse.Builder, ListCommandInvocationsResponse> {
    private static final SdkField<List<CommandInvocation>> COMMAND_INVOCATIONS_FIELD = SdkField
            .<List<CommandInvocation>> builder(MarshallingType.LIST)
            .getter(getter(ListCommandInvocationsResponse::commandInvocations))
            .setter(setter(Builder::commandInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandInvocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CommandInvocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(CommandInvocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCommandInvocationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_INVOCATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CommandInvocation> commandInvocations;

    private final String nextToken;

    private ListCommandInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.commandInvocations = builder.commandInvocations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * (Optional) A list of all invocations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) A list of all invocations.
     */
    public List<CommandInvocation> commandInvocations() {
        return commandInvocations;
    }

    /**
     * <p>
     * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return (Optional) The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsResponse)) {
            return false;
        }
        ListCommandInvocationsResponse other = (ListCommandInvocationsResponse) obj;
        return Objects.equals(commandInvocations(), other.commandInvocations()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListCommandInvocationsResponse").add("CommandInvocations", commandInvocations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandInvocations":
            return Optional.ofNullable(clazz.cast(commandInvocations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCommandInvocationsResponse, T> g) {
        return obj -> g.apply((ListCommandInvocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCommandInvocationsResponse> {
        /**
         * <p>
         * (Optional) A list of all invocations.
         * </p>
         * 
         * @param commandInvocations
         *        (Optional) A list of all invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandInvocations(Collection<CommandInvocation> commandInvocations);

        /**
         * <p>
         * (Optional) A list of all invocations.
         * </p>
         * 
         * @param commandInvocations
         *        (Optional) A list of all invocations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandInvocations(CommandInvocation... commandInvocations);

        /**
         * <p>
         * (Optional) A list of all invocations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CommandInvocation>.Builder} avoiding the
         * need to create one manually via {@link List<CommandInvocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CommandInvocation>.Builder#build()} is called immediately
         * and its result is passed to {@link #commandInvocations(List<CommandInvocation>)}.
         * 
         * @param commandInvocations
         *        a consumer that will call methods on {@link List<CommandInvocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commandInvocations(List<CommandInvocation>)
         */
        Builder commandInvocations(Consumer<CommandInvocation.Builder>... commandInvocations);

        /**
         * <p>
         * (Optional) The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        (Optional) The token for the next set of items to return. (You received this token from a previous
         *        call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<CommandInvocation> commandInvocations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommandInvocationsResponse model) {
            super(model);
            commandInvocations(model.commandInvocations);
            nextToken(model.nextToken);
        }

        public final Collection<CommandInvocation.Builder> getCommandInvocations() {
            return commandInvocations != null ? commandInvocations.stream().map(CommandInvocation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commandInvocations(Collection<CommandInvocation> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copy(commandInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandInvocations(CommandInvocation... commandInvocations) {
            commandInvocations(Arrays.asList(commandInvocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandInvocations(Consumer<CommandInvocation.Builder>... commandInvocations) {
            commandInvocations(Stream.of(commandInvocations).map(c -> CommandInvocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCommandInvocations(Collection<CommandInvocation.BuilderImpl> commandInvocations) {
            this.commandInvocations = CommandInvocationListCopier.copyFromBuilder(commandInvocations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCommandInvocationsResponse build() {
            return new ListCommandInvocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
