/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeTypeName {
    INSTANCE("Instance"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeTypeName> VALUE_MAP;
    private final String value;

    private NodeTypeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeTypeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeTypeName> knownValues() {
        EnumSet<NodeTypeName> knownValues = EnumSet.allOf(NodeTypeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeTypeName.class, NodeTypeName::toString);
    }
}

