/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status information about the aggregated associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceAggregatedAssociationOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceAggregatedAssociationOverview.Builder, InstanceAggregatedAssociationOverview> {
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailedStatus").getter(getter(InstanceAggregatedAssociationOverview::detailedStatus))
            .setter(setter(Builder::detailedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()).build();

    private static final SdkField<Map<String, Integer>> INSTANCE_ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("InstanceAssociationStatusAggregatedCount")
            .getter(getter(InstanceAggregatedAssociationOverview::instanceAssociationStatusAggregatedCount))
            .setter(setter(Builder::instanceAssociationStatusAggregatedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceAssociationStatusAggregatedCount").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_STATUS_FIELD,
            INSTANCE_ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String detailedStatus;

    private final Map<String, Integer> instanceAssociationStatusAggregatedCount;

    private InstanceAggregatedAssociationOverview(BuilderImpl builder) {
        this.detailedStatus = builder.detailedStatus;
        this.instanceAssociationStatusAggregatedCount = builder.instanceAssociationStatusAggregatedCount;
    }

    /**
     * <p>
     * Detailed status information about the aggregated associations.
     * </p>
     * 
     * @return Detailed status information about the aggregated associations.
     */
    public final String detailedStatus() {
        return detailedStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceAssociationStatusAggregatedCount
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasInstanceAssociationStatusAggregatedCount() {
        return instanceAssociationStatusAggregatedCount != null
                && !(instanceAssociationStatusAggregatedCount instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of associations for the managed nodes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasInstanceAssociationStatusAggregatedCount} method.
     * </p>
     * 
     * @return The number of associations for the managed nodes.
     */
    public final Map<String, Integer> instanceAssociationStatusAggregatedCount() {
        return instanceAssociationStatusAggregatedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailedStatus());
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasInstanceAssociationStatusAggregatedCount() ? instanceAssociationStatusAggregatedCount()
                        : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAggregatedAssociationOverview)) {
            return false;
        }
        InstanceAggregatedAssociationOverview other = (InstanceAggregatedAssociationOverview) obj;
        return Objects.equals(detailedStatus(), other.detailedStatus())
                && hasInstanceAssociationStatusAggregatedCount() == other.hasInstanceAssociationStatusAggregatedCount()
                && Objects.equals(instanceAssociationStatusAggregatedCount(), other.instanceAssociationStatusAggregatedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("InstanceAggregatedAssociationOverview")
                .add("DetailedStatus", detailedStatus())
                .add("InstanceAssociationStatusAggregatedCount",
                        hasInstanceAssociationStatusAggregatedCount() ? instanceAssociationStatusAggregatedCount() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailedStatus":
            return Optional.ofNullable(clazz.cast(detailedStatus()));
        case "InstanceAssociationStatusAggregatedCount":
            return Optional.ofNullable(clazz.cast(instanceAssociationStatusAggregatedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DetailedStatus", DETAILED_STATUS_FIELD);
        map.put("InstanceAssociationStatusAggregatedCount", INSTANCE_ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceAggregatedAssociationOverview, T> g) {
        return obj -> g.apply((InstanceAggregatedAssociationOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceAggregatedAssociationOverview> {
        /**
         * <p>
         * Detailed status information about the aggregated associations.
         * </p>
         * 
         * @param detailedStatus
         *        Detailed status information about the aggregated associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailedStatus(String detailedStatus);

        /**
         * <p>
         * The number of associations for the managed nodes.
         * </p>
         * 
         * @param instanceAssociationStatusAggregatedCount
         *        The number of associations for the managed nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceAssociationStatusAggregatedCount(Map<String, Integer> instanceAssociationStatusAggregatedCount);
    }

    static final class BuilderImpl implements Builder {
        private String detailedStatus;

        private Map<String, Integer> instanceAssociationStatusAggregatedCount = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAggregatedAssociationOverview model) {
            detailedStatus(model.detailedStatus);
            instanceAssociationStatusAggregatedCount(model.instanceAssociationStatusAggregatedCount);
        }

        public final String getDetailedStatus() {
            return detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final Map<String, Integer> getInstanceAssociationStatusAggregatedCount() {
            if (instanceAssociationStatusAggregatedCount instanceof SdkAutoConstructMap) {
                return null;
            }
            return instanceAssociationStatusAggregatedCount;
        }

        public final void setInstanceAssociationStatusAggregatedCount(
                Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier
                    .copy(instanceAssociationStatusAggregatedCount);
        }

        @Override
        public final Builder instanceAssociationStatusAggregatedCount(
                Map<String, Integer> instanceAssociationStatusAggregatedCount) {
            this.instanceAssociationStatusAggregatedCount = InstanceAssociationStatusAggregatedCountCopier
                    .copy(instanceAssociationStatusAggregatedCount);
            return this;
        }

        @Override
        public InstanceAggregatedAssociationOverview build() {
            return new InstanceAggregatedAssociationOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
