/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterPatchBaselineForPatchGroupResponse extends SsmResponse implements
        ToCopyableBuilder<RegisterPatchBaselineForPatchGroupResponse.Builder, RegisterPatchBaselineForPatchGroupResponse> {
    private static final SdkField<String> BASELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaselineId").getter(getter(RegisterPatchBaselineForPatchGroupResponse::baselineId))
            .setter(setter(Builder::baselineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineId").build()).build();

    private static final SdkField<String> PATCH_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchGroup").getter(getter(RegisterPatchBaselineForPatchGroupResponse::patchGroup))
            .setter(setter(Builder::patchGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_ID_FIELD,
            PATCH_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String baselineId;

    private final String patchGroup;

    private RegisterPatchBaselineForPatchGroupResponse(BuilderImpl builder) {
        super(builder);
        this.baselineId = builder.baselineId;
        this.patchGroup = builder.patchGroup;
    }

    /**
     * <p>
     * The ID of the patch baseline the patch group was registered with.
     * </p>
     * 
     * @return The ID of the patch baseline the patch group was registered with.
     */
    public final String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch group registered with the patch baseline.
     * </p>
     * 
     * @return The name of the patch group registered with the patch baseline.
     */
    public final String patchGroup() {
        return patchGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(patchGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterPatchBaselineForPatchGroupResponse)) {
            return false;
        }
        RegisterPatchBaselineForPatchGroupResponse other = (RegisterPatchBaselineForPatchGroupResponse) obj;
        return Objects.equals(baselineId(), other.baselineId()) && Objects.equals(patchGroup(), other.patchGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterPatchBaselineForPatchGroupResponse").add("BaselineId", baselineId())
                .add("PatchGroup", patchGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineId":
            return Optional.ofNullable(clazz.cast(baselineId()));
        case "PatchGroup":
            return Optional.ofNullable(clazz.cast(patchGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaselineId", BASELINE_ID_FIELD);
        map.put("PatchGroup", PATCH_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterPatchBaselineForPatchGroupResponse, T> g) {
        return obj -> g.apply((RegisterPatchBaselineForPatchGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterPatchBaselineForPatchGroupResponse> {
        /**
         * <p>
         * The ID of the patch baseline the patch group was registered with.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline the patch group was registered with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch group registered with the patch baseline.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group registered with the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String baselineId;

        private String patchGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterPatchBaselineForPatchGroupResponse model) {
            super(model);
            baselineId(model.baselineId);
            patchGroup(model.patchGroup);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        @Override
        public RegisterPatchBaselineForPatchGroupResponse build() {
            return new RegisterPatchBaselineForPatchGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
