/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Operational metadata for an application in Application Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsMetadata implements SdkPojo, Serializable, ToCopyableBuilder<OpsMetadata.Builder, OpsMetadata> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(OpsMetadata::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> OPS_METADATA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsMetadataArn").getter(getter(OpsMetadata::opsMetadataArn)).setter(setter(Builder::opsMetadataArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsMetadataArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(OpsMetadata::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedUser").getter(getter(OpsMetadata::lastModifiedUser))
            .setter(setter(Builder::lastModifiedUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedUser").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(OpsMetadata::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            OPS_METADATA_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_USER_FIELD, CREATION_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String opsMetadataArn;

    private final Instant lastModifiedDate;

    private final String lastModifiedUser;

    private final Instant creationDate;

    private OpsMetadata(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.opsMetadataArn = builder.opsMetadataArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The ID of the Application Manager application.
     * </p>
     * 
     * @return The ID of the Application Manager application.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.
     */
    public final String opsMetadataArn() {
        return opsMetadataArn;
    }

    /**
     * <p>
     * The date the OpsMetadata object was last updated.
     * </p>
     * 
     * @return The date the OpsMetadata object was last updated.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The user name who last updated the OpsMetadata object.
     * </p>
     * 
     * @return The user name who last updated the OpsMetadata object.
     */
    public final String lastModifiedUser() {
        return lastModifiedUser;
    }

    /**
     * <p>
     * The date the OpsMetadata objects was created.
     * </p>
     * 
     * @return The date the OpsMetadata objects was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(opsMetadataArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsMetadata)) {
            return false;
        }
        OpsMetadata other = (OpsMetadata) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(opsMetadataArn(), other.opsMetadataArn())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lastModifiedUser(), other.lastModifiedUser())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpsMetadata").add("ResourceId", resourceId()).add("OpsMetadataArn", opsMetadataArn())
                .add("LastModifiedDate", lastModifiedDate()).add("LastModifiedUser", lastModifiedUser())
                .add("CreationDate", creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "OpsMetadataArn":
            return Optional.ofNullable(clazz.cast(opsMetadataArn()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LastModifiedUser":
            return Optional.ofNullable(clazz.cast(lastModifiedUser()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("OpsMetadataArn", OPS_METADATA_ARN_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LastModifiedUser", LAST_MODIFIED_USER_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsMetadata, T> g) {
        return obj -> g.apply((OpsMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsMetadata> {
        /**
         * <p>
         * The ID of the Application Manager application.
         * </p>
         * 
         * @param resourceId
         *        The ID of the Application Manager application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.
         * </p>
         * 
         * @param opsMetadataArn
         *        The Amazon Resource Name (ARN) of the OpsMetadata Object or blob.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsMetadataArn(String opsMetadataArn);

        /**
         * <p>
         * The date the OpsMetadata object was last updated.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the OpsMetadata object was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The user name who last updated the OpsMetadata object.
         * </p>
         * 
         * @param lastModifiedUser
         *        The user name who last updated the OpsMetadata object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedUser(String lastModifiedUser);

        /**
         * <p>
         * The date the OpsMetadata objects was created.
         * </p>
         * 
         * @param creationDate
         *        The date the OpsMetadata objects was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String opsMetadataArn;

        private Instant lastModifiedDate;

        private String lastModifiedUser;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsMetadata model) {
            resourceId(model.resourceId);
            opsMetadataArn(model.opsMetadataArn);
            lastModifiedDate(model.lastModifiedDate);
            lastModifiedUser(model.lastModifiedUser);
            creationDate(model.creationDate);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getOpsMetadataArn() {
            return opsMetadataArn;
        }

        public final void setOpsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
        }

        @Override
        public final Builder opsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedUser() {
            return lastModifiedUser;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public OpsMetadata build() {
            return new OpsMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
