/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.AlarmConfiguration;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformation;
import software.amazon.awssdk.services.ssm.model.AlarmStateInformationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationExecution> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AssociationExecution.getter(AssociationExecution::associationId)).setter(AssociationExecution.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationVersion").getter(AssociationExecution.getter(AssociationExecution::associationVersion)).setter(AssociationExecution.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionId").getter(AssociationExecution.getter(AssociationExecution::executionId)).setter(AssociationExecution.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AssociationExecution.getter(AssociationExecution::status)).setter(AssociationExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailedStatus").getter(AssociationExecution.getter(AssociationExecution::detailedStatus)).setter(AssociationExecution.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AssociationExecution.getter(AssociationExecution::createdTime)).setter(AssociationExecution.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastExecutionDate").getter(AssociationExecution.getter(AssociationExecution::lastExecutionDate)).setter(AssociationExecution.setter(Builder::lastExecutionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()}).build();
    private static final SdkField<String> RESOURCE_COUNT_BY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCountByStatus").getter(AssociationExecution.getter(AssociationExecution::resourceCountByStatus)).setter(AssociationExecution.setter(Builder::resourceCountByStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCountByStatus").build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmConfiguration").getter(AssociationExecution.getter(AssociationExecution::alarmConfiguration)).setter(AssociationExecution.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmConfiguration").build()}).build();
    private static final SdkField<List<AlarmStateInformation>> TRIGGERED_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggeredAlarms").getter(AssociationExecution.getter(AssociationExecution::triggeredAlarms)).setter(AssociationExecution.setter(Builder::triggeredAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggeredAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmStateInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_VERSION_FIELD, EXECUTION_ID_FIELD, STATUS_FIELD, DETAILED_STATUS_FIELD, CREATED_TIME_FIELD, LAST_EXECUTION_DATE_FIELD, RESOURCE_COUNT_BY_STATUS_FIELD, ALARM_CONFIGURATION_FIELD, TRIGGERED_ALARMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociationExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String associationVersion;
    private final String executionId;
    private final String status;
    private final String detailedStatus;
    private final Instant createdTime;
    private final Instant lastExecutionDate;
    private final String resourceCountByStatus;
    private final AlarmConfiguration alarmConfiguration;
    private final List<AlarmStateInformation> triggeredAlarms;

    private AssociationExecution(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.executionId = builder.executionId;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.createdTime = builder.createdTime;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.resourceCountByStatus = builder.resourceCountByStatus;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.triggeredAlarms = builder.triggeredAlarms;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String associationVersion() {
        return this.associationVersion;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String status() {
        return this.status;
    }

    public final String detailedStatus() {
        return this.detailedStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public final String resourceCountByStatus() {
        return this.resourceCountByStatus;
    }

    public final AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public final boolean hasTriggeredAlarms() {
        return this.triggeredAlarms != null && !(this.triggeredAlarms instanceof SdkAutoConstructList);
    }

    public final List<AlarmStateInformation> triggeredAlarms() {
        return this.triggeredAlarms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCountByStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggeredAlarms() ? this.triggeredAlarms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationExecution)) {
            return false;
        }
        AssociationExecution other = (AssociationExecution)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate()) && Objects.equals(this.resourceCountByStatus(), other.resourceCountByStatus()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && this.hasTriggeredAlarms() == other.hasTriggeredAlarms() && Objects.equals(this.triggeredAlarms(), other.triggeredAlarms());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationExecution").add("AssociationId", (Object)this.associationId()).add("AssociationVersion", (Object)this.associationVersion()).add("ExecutionId", (Object)this.executionId()).add("Status", (Object)this.status()).add("DetailedStatus", (Object)this.detailedStatus()).add("CreatedTime", (Object)this.createdTime()).add("LastExecutionDate", (Object)this.lastExecutionDate()).add("ResourceCountByStatus", (Object)this.resourceCountByStatus()).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("TriggeredAlarms", this.hasTriggeredAlarms() ? this.triggeredAlarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "ExecutionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatus()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionDate()));
            }
            case "ResourceCountByStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceCountByStatus()));
            }
            case "AlarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "TriggeredAlarms": {
                return Optional.ofNullable(clazz.cast(this.triggeredAlarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("AssociationVersion", ASSOCIATION_VERSION_FIELD);
        map.put("ExecutionId", EXECUTION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DetailedStatus", DETAILED_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastExecutionDate", LAST_EXECUTION_DATE_FIELD);
        map.put("ResourceCountByStatus", RESOURCE_COUNT_BY_STATUS_FIELD);
        map.put("AlarmConfiguration", ALARM_CONFIGURATION_FIELD);
        map.put("TriggeredAlarms", TRIGGERED_ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociationExecution, T> g) {
        return obj -> g.apply((AssociationExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationVersion;
        private String executionId;
        private String status;
        private String detailedStatus;
        private Instant createdTime;
        private Instant lastExecutionDate;
        private String resourceCountByStatus;
        private AlarmConfiguration alarmConfiguration;
        private List<AlarmStateInformation> triggeredAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationExecution model) {
            this.associationId(model.associationId);
            this.associationVersion(model.associationVersion);
            this.executionId(model.executionId);
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.createdTime(model.createdTime);
            this.lastExecutionDate(model.lastExecutionDate);
            this.resourceCountByStatus(model.resourceCountByStatus);
            this.alarmConfiguration(model.alarmConfiguration);
            this.triggeredAlarms(model.triggeredAlarms);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final String getResourceCountByStatus() {
            return this.resourceCountByStatus;
        }

        public final void setResourceCountByStatus(String resourceCountByStatus) {
            this.resourceCountByStatus = resourceCountByStatus;
        }

        @Override
        public final Builder resourceCountByStatus(String resourceCountByStatus) {
            this.resourceCountByStatus = resourceCountByStatus;
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final List<AlarmStateInformation.Builder> getTriggeredAlarms() {
            List<AlarmStateInformation.Builder> result = AlarmStateInformationListCopier.copyToBuilder(this.triggeredAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggeredAlarms(Collection<AlarmStateInformation.BuilderImpl> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copyFromBuilder(triggeredAlarms);
        }

        @Override
        public final Builder triggeredAlarms(Collection<AlarmStateInformation> triggeredAlarms) {
            this.triggeredAlarms = AlarmStateInformationListCopier.copy(triggeredAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(AlarmStateInformation ... triggeredAlarms) {
            this.triggeredAlarms(Arrays.asList(triggeredAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... triggeredAlarms) {
            this.triggeredAlarms(Stream.of(triggeredAlarms).map(c -> (AlarmStateInformation)((AlarmStateInformation.Builder)AlarmStateInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssociationExecution build() {
            return new AssociationExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationExecution> {
        public Builder associationId(String var1);

        public Builder associationVersion(String var1);

        public Builder executionId(String var1);

        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastExecutionDate(Instant var1);

        public Builder resourceCountByStatus(String var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder triggeredAlarms(Collection<AlarmStateInformation> var1);

        public Builder triggeredAlarms(AlarmStateInformation ... var1);

        public Builder triggeredAlarms(Consumer<AlarmStateInformation.Builder> ... var1);
    }
}

