/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Web Services Systems Manager parameter in Parameter Store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Parameter implements SdkPojo, Serializable, ToCopyableBuilder<Parameter.Builder, Parameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Parameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Parameter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Parameter::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(Parameter::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> SELECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Selector").getter(getter(Parameter::selector)).setter(setter(Builder::selector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Selector").build()).build();

    private static final SdkField<String> SOURCE_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResult").getter(getter(Parameter::sourceResult)).setter(setter(Builder::sourceResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResult").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate").getter(getter(Parameter::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(Parameter::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataType").getter(getter(Parameter::dataType)).setter(setter(Builder::dataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NAME_FIELD, TYPE_FIELD, VALUE_FIELD, VERSION_FIELD, SELECTOR_FIELD, SOURCE_RESULT_FIELD,
                    LAST_MODIFIED_DATE_FIELD, ARN_FIELD, DATA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String value;

    private final Long version;

    private final String selector;

    private final String sourceResult;

    private final Instant lastModifiedDate;

    private final String arn;

    private final String dataType;

    private Parameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
        this.version = builder.version;
        this.selector = builder.selector;
        this.sourceResult = builder.sourceResult;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.arn = builder.arn;
        this.dataType = builder.dataType;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>, and
     * <code>SecureString</code>.
     * </p>
     * <note>
     * <p>
     * If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas in
     * the <code>Value</code> field.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>,
     *         and <code>SecureString</code>.</p> <note>
     *         <p>
     *         If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between
     *         commas in the <code>Value</code> field.
     *         </p>
     * @see ParameterType
     */
    public final ParameterType type() {
        return ParameterType.fromValue(type);
    }

    /**
     * <p>
     * The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>, and
     * <code>SecureString</code>.
     * </p>
     * <note>
     * <p>
     * If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas in
     * the <code>Value</code> field.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ParameterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>,
     *         and <code>SecureString</code>.</p> <note>
     *         <p>
     *         If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between
     *         commas in the <code>Value</code> field.
     *         </p>
     * @see ParameterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The parameter value.
     * </p>
     * <note>
     * <p>
     * If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas in
     * the <code>Value</code> field.
     * </p>
     * </note>
     * 
     * @return The parameter value.</p> <note>
     *         <p>
     *         If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between
     *         commas in the <code>Value</code> field.
     *         </p>
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The parameter version.
     * </p>
     * 
     * @return The parameter version.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * Either the version number or the label used to retrieve the parameter value. Specify selectors by using one of
     * the following formats:
     * </p>
     * <p>
     * parameter_name:version
     * </p>
     * <p>
     * parameter_name:label
     * </p>
     * 
     * @return Either the version number or the label used to retrieve the parameter value. Specify selectors by using
     *         one of the following formats:</p>
     *         <p>
     *         parameter_name:version
     *         </p>
     *         <p>
     *         parameter_name:label
     */
    public final String selector() {
        return selector;
    }

    /**
     * <p>
     * Applies to parameters that reference information in other Amazon Web Services services. <code>SourceResult</code>
     * is the raw result or response from the source.
     * </p>
     * 
     * @return Applies to parameters that reference information in other Amazon Web Services services.
     *         <code>SourceResult</code> is the raw result or response from the source.
     */
    public final String sourceResult() {
        return sourceResult;
    }

    /**
     * <p>
     * Date the parameter was last changed or updated and the parameter version was created.
     * </p>
     * 
     * @return Date the parameter was last changed or updated and the parameter version was created.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the parameter.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is
     * <code>text</code>.
     * </p>
     * 
     * @return The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is
     *         <code>text</code>.
     */
    public final String dataType() {
        return dataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(selector());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResult());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(dataType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(value(), other.value()) && Objects.equals(version(), other.version())
                && Objects.equals(selector(), other.selector()) && Objects.equals(sourceResult(), other.sourceResult())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(arn(), other.arn())
                && Objects.equals(dataType(), other.dataType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Parameter").add("Name", name()).add("Type", typeAsString())
                .add("Value", value() == null ? null : "*** Sensitive Data Redacted ***").add("Version", version())
                .add("Selector", selector()).add("SourceResult", sourceResult()).add("LastModifiedDate", lastModifiedDate())
                .add("ARN", arn()).add("DataType", dataType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Selector":
            return Optional.ofNullable(clazz.cast(selector()));
        case "SourceResult":
            return Optional.ofNullable(clazz.cast(sourceResult()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "DataType":
            return Optional.ofNullable(clazz.cast(dataType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Selector", SELECTOR_FIELD);
        map.put("SourceResult", SOURCE_RESULT_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("DataType", DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Parameter> {
        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param name
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>, and
         * <code>SecureString</code>.
         * </p>
         * <note>
         * <p>
         * If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas
         * in the <code>Value</code> field.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of parameter. Valid values include the following: <code>String</code>,
         *        <code>StringList</code>, and <code>SecureString</code>.</p> <note>
         *        <p>
         *        If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between
         *        commas in the <code>Value</code> field.
         *        </p>
         * @see ParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of parameter. Valid values include the following: <code>String</code>, <code>StringList</code>, and
         * <code>SecureString</code>.
         * </p>
         * <note>
         * <p>
         * If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas
         * in the <code>Value</code> field.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of parameter. Valid values include the following: <code>String</code>,
         *        <code>StringList</code>, and <code>SecureString</code>.</p> <note>
         *        <p>
         *        If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between
         *        commas in the <code>Value</code> field.
         *        </p>
         * @see ParameterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterType
         */
        Builder type(ParameterType type);

        /**
         * <p>
         * The parameter value.
         * </p>
         * <note>
         * <p>
         * If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between commas
         * in the <code>Value</code> field.
         * </p>
         * </note>
         * 
         * @param value
         *        The parameter value.</p> <note>
         *        <p>
         *        If type is <code>StringList</code>, the system returns a comma-separated string with no spaces between
         *        commas in the <code>Value</code> field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The parameter version.
         * </p>
         * 
         * @param version
         *        The parameter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * Either the version number or the label used to retrieve the parameter value. Specify selectors by using one
         * of the following formats:
         * </p>
         * <p>
         * parameter_name:version
         * </p>
         * <p>
         * parameter_name:label
         * </p>
         * 
         * @param selector
         *        Either the version number or the label used to retrieve the parameter value. Specify selectors by
         *        using one of the following formats:</p>
         *        <p>
         *        parameter_name:version
         *        </p>
         *        <p>
         *        parameter_name:label
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selector(String selector);

        /**
         * <p>
         * Applies to parameters that reference information in other Amazon Web Services services.
         * <code>SourceResult</code> is the raw result or response from the source.
         * </p>
         * 
         * @param sourceResult
         *        Applies to parameters that reference information in other Amazon Web Services services.
         *        <code>SourceResult</code> is the raw result or response from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResult(String sourceResult);

        /**
         * <p>
         * Date the parameter was last changed or updated and the parameter version was created.
         * </p>
         * 
         * @param lastModifiedDate
         *        Date the parameter was last changed or updated and the parameter version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the parameter.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default is
         * <code>text</code>.
         * </p>
         * 
         * @param dataType
         *        The data type of the parameter, such as <code>text</code> or <code>aws:ec2:image</code>. The default
         *        is <code>text</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataType(String dataType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String value;

        private Long version;

        private String selector;

        private String sourceResult;

        private Instant lastModifiedDate;

        private String arn;

        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            name(model.name);
            type(model.type);
            value(model.value);
            version(model.version);
            selector(model.selector);
            sourceResult(model.sourceResult);
            lastModifiedDate(model.lastModifiedDate);
            arn(model.arn);
            dataType(model.dataType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ParameterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getSelector() {
            return selector;
        }

        public final void setSelector(String selector) {
            this.selector = selector;
        }

        @Override
        public final Builder selector(String selector) {
            this.selector = selector;
            return this;
        }

        public final String getSourceResult() {
            return sourceResult;
        }

        public final void setSourceResult(String sourceResult) {
            this.sourceResult = sourceResult;
        }

        @Override
        public final Builder sourceResult(String sourceResult) {
            this.sourceResult = sourceResult;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDataType() {
            return dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public Parameter build() {
            return new Parameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
