/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of patch filters, typically used for approval rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchFilterGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<PatchFilterGroup.Builder, PatchFilterGroup> {
    private static final SdkField<List<PatchFilter>> PATCH_FILTERS_FIELD = SdkField
            .<List<PatchFilter>> builder(MarshallingType.LIST)
            .memberName("PatchFilters")
            .getter(getter(PatchFilterGroup::patchFilters))
            .setter(setter(Builder::patchFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<PatchFilter> patchFilters;

    private PatchFilterGroup(BuilderImpl builder) {
        this.patchFilters = builder.patchFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the PatchFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPatchFilters() {
        return patchFilters != null && !(patchFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The set of patch filters that make up the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatchFilters} method.
     * </p>
     * 
     * @return The set of patch filters that make up the group.
     */
    public final List<PatchFilter> patchFilters() {
        return patchFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPatchFilters() ? patchFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilterGroup)) {
            return false;
        }
        PatchFilterGroup other = (PatchFilterGroup) obj;
        return hasPatchFilters() == other.hasPatchFilters() && Objects.equals(patchFilters(), other.patchFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PatchFilterGroup").add("PatchFilters", hasPatchFilters() ? patchFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchFilters":
            return Optional.ofNullable(clazz.cast(patchFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PatchFilters", PATCH_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PatchFilterGroup, T> g) {
        return obj -> g.apply((PatchFilterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchFilterGroup> {
        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * 
         * @param patchFilters
         *        The set of patch filters that make up the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilters(Collection<PatchFilter> patchFilters);

        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * 
         * @param patchFilters
         *        The set of patch filters that make up the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchFilters(PatchFilter... patchFilters);

        /**
         * <p>
         * The set of patch filters that make up the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.PatchFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.PatchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.PatchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #patchFilters(List<PatchFilter>)}.
         * 
         * @param patchFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.PatchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchFilters(java.util.Collection<PatchFilter>)
         */
        Builder patchFilters(Consumer<PatchFilter.Builder>... patchFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<PatchFilter> patchFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilterGroup model) {
            patchFilters(model.patchFilters);
        }

        public final List<PatchFilter.Builder> getPatchFilters() {
            List<PatchFilter.Builder> result = PatchFilterListCopier.copyToBuilder(this.patchFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatchFilters(Collection<PatchFilter.BuilderImpl> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copyFromBuilder(patchFilters);
        }

        @Override
        public final Builder patchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(PatchFilter... patchFilters) {
            patchFilters(Arrays.asList(patchFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(Consumer<PatchFilter.Builder>... patchFilters) {
            patchFilters(Stream.of(patchFilters).map(c -> PatchFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PatchFilterGroup build() {
            return new PatchFilterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
