/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OpsItemFilterKey {
    STATUS("Status"),
    CREATED_BY("CreatedBy"),
    SOURCE("Source"),
    PRIORITY("Priority"),
    TITLE("Title"),
    OPS_ITEM_ID("OpsItemId"),
    CREATED_TIME("CreatedTime"),
    LAST_MODIFIED_TIME("LastModifiedTime"),
    ACTUAL_START_TIME("ActualStartTime"),
    ACTUAL_END_TIME("ActualEndTime"),
    PLANNED_START_TIME("PlannedStartTime"),
    PLANNED_END_TIME("PlannedEndTime"),
    OPERATIONAL_DATA("OperationalData"),
    OPERATIONAL_DATA_KEY("OperationalDataKey"),
    OPERATIONAL_DATA_VALUE("OperationalDataValue"),
    RESOURCE_ID("ResourceId"),
    AUTOMATION_ID("AutomationId"),
    CATEGORY("Category"),
    SEVERITY("Severity"),
    OPS_ITEM_TYPE("OpsItemType"),
    ACCESS_REQUEST_BY_REQUESTER_ARN("AccessRequestByRequesterArn"),
    ACCESS_REQUEST_BY_REQUESTER_ID("AccessRequestByRequesterId"),
    ACCESS_REQUEST_BY_APPROVER_ARN("AccessRequestByApproverArn"),
    ACCESS_REQUEST_BY_APPROVER_ID("AccessRequestByApproverId"),
    ACCESS_REQUEST_BY_SOURCE_ACCOUNT_ID("AccessRequestBySourceAccountId"),
    ACCESS_REQUEST_BY_SOURCE_OPS_ITEM_ID("AccessRequestBySourceOpsItemId"),
    ACCESS_REQUEST_BY_SOURCE_REGION("AccessRequestBySourceRegion"),
    ACCESS_REQUEST_BY_IS_REPLICA("AccessRequestByIsReplica"),
    ACCESS_REQUEST_BY_TARGET_RESOURCE_ID("AccessRequestByTargetResourceId"),
    CHANGE_REQUEST_BY_REQUESTER_ARN("ChangeRequestByRequesterArn"),
    CHANGE_REQUEST_BY_REQUESTER_NAME("ChangeRequestByRequesterName"),
    CHANGE_REQUEST_BY_APPROVER_ARN("ChangeRequestByApproverArn"),
    CHANGE_REQUEST_BY_APPROVER_NAME("ChangeRequestByApproverName"),
    CHANGE_REQUEST_BY_TEMPLATE("ChangeRequestByTemplate"),
    CHANGE_REQUEST_BY_TARGETS_RESOURCE_GROUP("ChangeRequestByTargetsResourceGroup"),
    INSIGHT_BY_TYPE("InsightByType"),
    ACCOUNT_ID("AccountId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpsItemFilterKey> VALUE_MAP;
    private final String value;

    private OpsItemFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OpsItemFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OpsItemFilterKey> knownValues() {
        EnumSet<OpsItemFilterKey> knownValues = EnumSet.allOf(OpsItemFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OpsItemFilterKey.class, OpsItemFilterKey::toString);
    }
}

