/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ssm.internal.SsmServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ssm.model.AccessDeniedException;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.AlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest;
import software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse;
import software.amazon.awssdk.services.ssm.model.AssociatedInstancesException;
import software.amazon.awssdk.services.ssm.model.AssociationAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AssociationVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotApprovedException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationStepNotFoundException;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.ComplianceTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.CustomSchemaCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.DeleteOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePropertiesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest;
import software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemResponse;
import software.amazon.awssdk.services.ssm.model.DocumentAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.DocumentLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionLimitException;
import software.amazon.awssdk.services.ssm.model.DocumentVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DoesNotExistException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentContentException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentVersionNameException;
import software.amazon.awssdk.services.ssm.model.DuplicateInstanceIdException;
import software.amazon.awssdk.services.ssm.model.FeatureNotAvailableException;
import software.amazon.awssdk.services.ssm.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.ssm.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetExecutionPreviewRequest;
import software.amazon.awssdk.services.ssm.model.GetExecutionPreviewResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ssm.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.HierarchyLevelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.HierarchyTypeMismatchException;
import software.amazon.awssdk.services.ssm.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ssm.model.IncompatiblePolicyException;
import software.amazon.awssdk.services.ssm.model.InternalServerErrorException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationIdException;
import software.amazon.awssdk.services.ssm.model.InvalidAggregatorException;
import software.amazon.awssdk.services.ssm.model.InvalidAllowedPatternException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationExecutionParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationSignalException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationStatusUpdateException;
import software.amazon.awssdk.services.ssm.model.InvalidCommandIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDeleteInventoryParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidDeletionIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentContentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentOperationException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentSchemaVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterKeyException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceInformationFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInstancePropertyFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryGroupException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryRequestException;
import software.amazon.awssdk.services.ssm.model.InvalidItemContentException;
import software.amazon.awssdk.services.ssm.model.InvalidKeyIdException;
import software.amazon.awssdk.services.ssm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ssm.model.InvalidNotificationConfigException;
import software.amazon.awssdk.services.ssm.model.InvalidOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputFolderException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputLocationException;
import software.amazon.awssdk.services.ssm.model.InvalidParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidPermissionTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidPluginNameException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResultAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidRoleException;
import software.amazon.awssdk.services.ssm.model.InvalidScheduleException;
import software.amazon.awssdk.services.ssm.model.InvalidTagException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetMapsException;
import software.amazon.awssdk.services.ssm.model.InvalidTypeNameException;
import software.amazon.awssdk.services.ssm.model.InvalidUpdateException;
import software.amazon.awssdk.services.ssm.model.InvocationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.ItemContentMismatchException;
import software.amazon.awssdk.services.ssm.model.ItemSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListNodesRequest;
import software.amazon.awssdk.services.ssm.model.ListNodesResponse;
import software.amazon.awssdk.services.ssm.model.ListNodesSummaryRequest;
import software.amazon.awssdk.services.ssm.model.ListNodesSummaryResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.MalformedResourcePolicyDocumentException;
import software.amazon.awssdk.services.ssm.model.MaxDocumentSizeExceededException;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemAccessDeniedException;
import software.amazon.awssdk.services.ssm.model.OpsItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemConflictException;
import software.amazon.awssdk.services.ssm.model.OpsItemInvalidParameterException;
import software.amazon.awssdk.services.ssm.model.OpsItemLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsItemNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemAssociationNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataInvalidArgumentException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataKeyLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataTooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.ParameterAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ParameterLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterMaxVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;
import software.amazon.awssdk.services.ssm.model.ParameterPatternMismatchException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionLabelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.PoliciesLimitExceededException;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.ssm.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncConflictException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncCountExceededException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncInvalidConfigurationException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncNotFoundException;
import software.amazon.awssdk.services.ssm.model.ResourceInUseException;
import software.amazon.awssdk.services.ssm.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssm.model.ResourcePolicyConflictException;
import software.amazon.awssdk.services.ssm.model.ResourcePolicyInvalidParameterException;
import software.amazon.awssdk.services.ssm.model.ResourcePolicyLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ResourcePolicyNotFoundException;
import software.amazon.awssdk.services.ssm.model.ResumeSessionRequest;
import software.amazon.awssdk.services.ssm.model.ResumeSessionResponse;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalResponse;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssm.model.ServiceSettingNotFoundException;
import software.amazon.awssdk.services.ssm.model.SsmException;
import software.amazon.awssdk.services.ssm.model.StartAccessRequestRequest;
import software.amazon.awssdk.services.ssm.model.StartAccessRequestResponse;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartExecutionPreviewRequest;
import software.amazon.awssdk.services.ssm.model.StartExecutionPreviewResponse;
import software.amazon.awssdk.services.ssm.model.StartSessionRequest;
import software.amazon.awssdk.services.ssm.model.StartSessionResponse;
import software.amazon.awssdk.services.ssm.model.StatusUnchangedException;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.SubTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.TargetInUseException;
import software.amazon.awssdk.services.ssm.model.TargetNotConnectedException;
import software.amazon.awssdk.services.ssm.model.TerminateSessionRequest;
import software.amazon.awssdk.services.ssm.model.TerminateSessionResponse;
import software.amazon.awssdk.services.ssm.model.ThrottlingException;
import software.amazon.awssdk.services.ssm.model.TooManyTagsErrorException;
import software.amazon.awssdk.services.ssm.model.TooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.TotalSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.UnsupportedCalendarException;
import software.amazon.awssdk.services.ssm.model.UnsupportedFeatureRequiredException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventorySchemaVersionException;
import software.amazon.awssdk.services.ssm.model.UnsupportedOperatingSystemException;
import software.amazon.awssdk.services.ssm.model.UnsupportedOperationException;
import software.amazon.awssdk.services.ssm.model.UnsupportedParameterTypeException;
import software.amazon.awssdk.services.ssm.model.UnsupportedPlatformTypeException;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.ValidationException;
import software.amazon.awssdk.services.ssm.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.AssociateOpsItemRelatedItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationBatchRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeletePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterManagedInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTargetFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTaskFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationExecutionTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationStepExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAvailablePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectiveInstanceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectivePatchesForPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceAssociationsStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceInformationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePropertiesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInventoryDeletionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowScheduleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsForTargetRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeOpsItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchBaselinesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchPropertiesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeSessionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DisassociateOpsItemRelatedItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCalendarStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCommandInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDeployablePatchSnapshotForInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetExecutionPreviewRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventorySchemaRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsSummaryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersByPathRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.LabelParameterVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListComplianceItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListComplianceSummariesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentMetadataHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListInventoryEntriesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListNodesSummaryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsItemEventsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsItemRelatedItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListResourceComplianceSummariesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ModifyDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutComplianceItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTargetWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTaskWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ResetServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ResumeSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendAutomationSignalRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAccessRequestRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAssociationsOnceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartChangeRequestExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartExecutionPreviewRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StopAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UnlabelParameterVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowTargetRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateManagedInstanceRoleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.waiters.SsmWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link SsmClient}.
 *
 * @see SsmClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSsmClient implements SsmClient {
    private static final Logger log = Logger.loggerFor(DefaultSsmClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSsmClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. <i>Tags</i> are metadata that you can assign to
     * your automations, documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines.
     * Tags enable you to categorize your resources in different ways, for example, by purpose, owner, or environment.
     * Each tag consists of a key and an optional value, both of which you define. For example, you could define a set
     * of tags for your account's managed nodes that helps you track each node's owner and stack level. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=Owner,Value=DbAdmin</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Owner,Value=SysAdmin</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Owner,Value=Dev</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Pre-Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Test</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Most resources can have a maximum of 50 tags. Automations can have a maximum of 5 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tag your Amazon EC2 resources</a> in
     * the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyTagsErrorException
     *         The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try the command
     *         again.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            TooManyTagsErrorException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsToResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident
     * Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are tools in Amazon Web Services
     * Systems Manager.
     * </p>
     *
     * @param associateOpsItemRelatedItemRequest
     * @return Result of the AssociateOpsItemRelatedItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws OpsItemRelatedItemAlreadyExistsException
     *         The Amazon Resource Name (ARN) is already associated with the OpsItem.
     * @throws OpsItemConflictException
     *         The specified OpsItem is in the process of being deleted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.AssociateOpsItemRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssociateOpsItemRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateOpsItemRelatedItemResponse associateOpsItemRelatedItem(
            AssociateOpsItemRelatedItemRequest associateOpsItemRelatedItemRequest) throws InternalServerErrorException,
            OpsItemNotFoundException, OpsItemLimitExceededException, OpsItemInvalidParameterException,
            OpsItemRelatedItemAlreadyExistsException, OpsItemConflictException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateOpsItemRelatedItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateOpsItemRelatedItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateOpsItemRelatedItemRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOpsItemRelatedItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOpsItemRelatedItem");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateOpsItemRelatedItemRequest, AssociateOpsItemRelatedItemResponse>()
                            .withOperationName("AssociateOpsItemRelatedItem").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateOpsItemRelatedItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateOpsItemRelatedItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return Result of the CancelCommand operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent (SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in a valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws DuplicateInstanceIdException
     *         You can't specify a managed node ID in more than one association.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelCommandResponse cancelCommand(CancelCommandRequest cancelCommandRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, DuplicateInstanceIdException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelCommandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCommandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCommand");

            return clientHandler.execute(new ClientExecutionParams<CancelCommandRequest, CancelCommandResponse>()
                    .withOperationName("CancelCommand").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelCommandRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelCommandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't
     * already starting running. Tasks already in progress will continue to completion.
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     * @return Result of the CancelMaintenanceWindowExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelMaintenanceWindowExecutionResponse cancelMaintenanceWindowExecution(
            CancelMaintenanceWindowExecutionRequest cancelMaintenanceWindowExecutionRequest) throws InternalServerErrorException,
            DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMaintenanceWindowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelMaintenanceWindowExecutionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMaintenanceWindowExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelMaintenanceWindowExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMaintenanceWindowExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelMaintenanceWindowExecutionRequest, CancelMaintenanceWindowExecutionResponse>()
                            .withOperationName("CancelMaintenanceWindowExecution").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelMaintenanceWindowExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelMaintenanceWindowExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or
     * virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager
     * makes it possible to manage them using Systems Manager tools. You use the activation code and ID when installing
     * SSM Agent on machines in your hybrid environment. For more information about requirements for managing
     * on-premises machines using Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-hybrid-multicloud.html">Using
     * Amazon Web Services Systems Manager in hybrid and multicloud environments</a> in the <i>Amazon Web Services
     * Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are
     * configured for Systems Manager are all called <i>managed nodes</i>.
     * </p>
     * </note>
     *
     * @param createActivationRequest
     * @return Result of the CreateActivation operation returned by the service.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateActivationResponse createActivation(CreateActivationRequest createActivationRequest)
            throws InvalidParametersException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateActivationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateActivationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createActivationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActivationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateActivation");

            return clientHandler.execute(new ClientExecutionParams<CreateActivationRequest, CreateActivationResponse>()
                    .withOperationName("CreateActivation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createActivationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateActivationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your managed nodes. For example, an
     * association can specify that anti-virus software must be installed and running on your managed nodes, or that
     * certain ports must be closed. For static targets, the association specifies a schedule for when the configuration
     * is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services
     * autoscaling group, State Manager, a tool in Amazon Web Services Systems Manager applies the configuration when
     * new managed nodes are added to the group. The association also specifies actions to take when applying the
     * configuration. For example, an association for anti-virus software might run once a day. If the software isn't
     * installed, then State Manager installs it. If the software is installed, but the service isn't running, then the
     * association might instruct State Manager to start the service.
     * </p>
     *
     * @param createAssociationRequest
     * @return Result of the CreateAssociation operation returned by the service.
     * @throws AssociationAlreadyExistsException
     *         The specified association already exists.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent (SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in a valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws UnsupportedPlatformTypeException
     *         The document doesn't support the platform type of the given managed node IDs. For example, you sent an
     *         document for a Windows managed node to a Linux node.
     * @throws InvalidOutputLocationException
     *         The output location isn't valid or doesn't exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws InvalidTargetException
     *         The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might not
     *         have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws InvalidTargetMapsException
     *         TargetMap parameter isn't valid.
     * @throws InvalidTagException
     *         The specified tag key or value isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAssociationResponse createAssociation(CreateAssociationRequest createAssociationRequest)
            throws AssociationAlreadyExistsException, AssociationLimitExceededException, InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidInstanceIdException,
            UnsupportedPlatformTypeException, InvalidOutputLocationException, InvalidParametersException, InvalidTargetException,
            InvalidScheduleException, InvalidTargetMapsException, InvalidTagException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssociation");

            return clientHandler.execute(new ClientExecutionParams<CreateAssociationRequest, CreateAssociationResponse>()
                    .withOperationName("CreateAssociation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed
     * nodes or targets.
     * </p>
     * <p>
     * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems
     * Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as
     * specified.
     * </p>
     * <p>
     * If you associate a document with a managed node that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return Result of the CreateAssociationBatch operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent (SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in a valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws DuplicateInstanceIdException
     *         You can't specify a managed node ID in more than one association.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws UnsupportedPlatformTypeException
     *         The document doesn't support the platform type of the given managed node IDs. For example, you sent an
     *         document for a Windows managed node to a Linux node.
     * @throws InvalidOutputLocationException
     *         The output location isn't valid or doesn't exist.
     * @throws InvalidTargetException
     *         The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might not
     *         have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws InvalidTargetMapsException
     *         TargetMap parameter isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAssociationBatchResponse createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException,
            InvalidInstanceIdException, InvalidParametersException, DuplicateInstanceIdException,
            AssociationLimitExceededException, UnsupportedPlatformTypeException, InvalidOutputLocationException,
            InvalidTargetException, InvalidScheduleException, InvalidTargetMapsException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssociationBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAssociationBatchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAssociationBatchRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssociationBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssociationBatch");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAssociationBatchRequest, CreateAssociationBatchResponse>()
                            .withOperationName("CreateAssociationBatch").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAssociationBatchRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAssociationBatchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems
     * Manager performs on your managed nodes. For more information about SSM documents, including information about
     * supported schemas, features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/documents.html">Amazon Web Services Systems
     * Manager Documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param createDocumentRequest
     * @return Result of the CreateDocument operation returned by the service.
     * @throws DocumentAlreadyExistsException
     *         The specified document already exists.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentContentException
     *         The content for the document isn't valid.
     * @throws DocumentLimitExceededException
     *         You can have at most 500 active SSM documents.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema isn't supported.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDocumentResponse createDocument(CreateDocumentRequest createDocumentRequest)
            throws DocumentAlreadyExistsException, MaxDocumentSizeExceededException, InternalServerErrorException,
            InvalidDocumentContentException, DocumentLimitExceededException, InvalidDocumentSchemaVersionException,
            TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocument");

            return clientHandler.execute(new ClientExecutionParams<CreateDocumentRequest, CreateDocumentResponse>()
                    .withOperationName("CreateDocument").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param createMaintenanceWindowRequest
     * @return Result of the CreateMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateMaintenanceWindowResponse createMaintenanceWindow(CreateMaintenanceWindowRequest createMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMaintenanceWindowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMaintenanceWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMaintenanceWindowRequest, CreateMaintenanceWindowResponse>()
                            .withOperationName("CreateMaintenanceWindow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html">Set up OpsCenter</a> in
     * the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems
     * Manager OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param createOpsItemRequest
     * @return Result of the CreateOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemAlreadyExistsException
     *         The OpsItem already exists.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws OpsItemAccessDeniedException
     *         You don't have permission to view OpsItems in the specified account. Verify that your account is
     *         configured either as a Systems Manager delegated administrator or that you are logged into the
     *         Organizations management account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateOpsItemResponse createOpsItem(CreateOpsItemRequest createOpsItemRequest) throws InternalServerErrorException,
            OpsItemAlreadyExistsException, OpsItemLimitExceededException, OpsItemInvalidParameterException,
            OpsItemAccessDeniedException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOpsItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOpsItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpsItem");

            return clientHandler.execute(new ClientExecutionParams<CreateOpsItemRequest, CreateOpsItemResponse>()
                    .withOperationName("CreateOpsItem").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOpsItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOpsItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API
     * operation to specify information about the new application, including the application type.
     * </p>
     *
     * @param createOpsMetadataRequest
     * @return Result of the CreateOpsMetadata operation returned by the service.
     * @throws OpsMetadataAlreadyExistsException
     *         An OpsMetadata object already exists for the selected resource.
     * @throws OpsMetadataTooManyUpdatesException
     *         The system is processing too many concurrent updates. Wait a few moments and try again.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws OpsMetadataLimitExceededException
     *         Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The
     *         maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateOpsMetadataResponse createOpsMetadata(CreateOpsMetadataRequest createOpsMetadataRequest)
            throws OpsMetadataAlreadyExistsException, OpsMetadataTooManyUpdatesException, OpsMetadataInvalidArgumentException,
            OpsMetadataLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOpsMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOpsMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<CreateOpsMetadataRequest, CreateOpsMetadataResponse>()
                    .withOperationName("CreateOpsMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a>PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param createPatchBaselineRequest
     * @return Result of the CreatePatchBaseline operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePatchBaselineResponse createPatchBaseline(CreatePatchBaselineRequest createPatchBaselineRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePatchBaselineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPatchBaselineRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePatchBaseline");

            return clientHandler.execute(new ClientExecutionParams<CreatePatchBaselineRequest, CreatePatchBaselineResponse>()
                    .withOperationName("CreatePatchBaseline").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPatchBaselineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems
     * Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3)
     * bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/inventory-create-resource-data-sync.html"
     * >Creating a resource data sync for Inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon
     * S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon
     * Web Services Regions or <code>EntireOrganization</code> by using Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>Amazon Web Services
     * Systems Manager User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note>
     *
     * @param createResourceDataSyncRequest
     * @return Result of the CreateResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncCountExceededException
     *         You have exceeded the allowed maximum sync configurations.
     * @throws ResourceDataSyncAlreadyExistsException
     *         A sync configuration with the same name already exists.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateResourceDataSyncResponse createResourceDataSync(CreateResourceDataSyncRequest createResourceDataSyncRequest)
            throws InternalServerErrorException, ResourceDataSyncCountExceededException, ResourceDataSyncAlreadyExistsException,
            ResourceDataSyncInvalidConfigurationException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceDataSyncResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceDataSyncRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceDataSync");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDataSyncRequest, CreateResourceDataSyncResponse>()
                            .withOperationName("CreateResourceDataSync").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createResourceDataSyncRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResourceDataSyncRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You
     * must manually de-register managed nodes.
     * </p>
     *
     * @param deleteActivationRequest
     * @return Result of the DeleteActivation operation returned by the service.
     * @throws InvalidActivationIdException
     *         The activation ID isn't valid. Verify that you entered the correct ActivationId or ActivationCode and try
     *         again.
     * @throws InvalidActivationException
     *         The activation isn't valid. The activation might have been deleted, or the ActivationId and the
     *         ActivationCode don't match.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteActivationResponse deleteActivation(DeleteActivationRequest deleteActivationRequest)
            throws InvalidActivationIdException, InvalidActivationException, InternalServerErrorException,
            TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteActivationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteActivationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteActivationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActivationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteActivation");

            return clientHandler.execute(new ClientExecutionParams<DeleteActivationRequest, DeleteActivationResponse>()
                    .withOperationName("DeleteActivation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteActivationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteActivationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified
     * managed node. If you created the association by using the <code>Targets</code> parameter, then you must delete
     * the association by using the association ID.
     * </p>
     * <p>
     * When you disassociate a document from a managed node, it doesn't change the configuration of the node. To change
     * the configuration state of a managed node after you disassociate a document, you must create a new document with
     * the desired configuration and associate it with the node.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent (SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in a valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAssociationResponse deleteAssociation(DeleteAssociationRequest deleteAssociationRequest)
            throws AssociationDoesNotExistException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssociation");

            return clientHandler.execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                    .withOperationName("DeleteAssociation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the
     * document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all managed
     * nodes that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws AssociatedInstancesException
     *         You must disassociate a document from all managed nodes before you can delete it.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentOperationException,
            AssociatedInstancesException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDocumentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocument");

            return clientHandler.execute(new ClientExecutionParams<DeleteDocumentRequest, DeleteDocumentResponse>()
                    .withOperationName("DeleteDocument").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     *
     * @param deleteInventoryRequest
     * @return Result of the DeleteInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidOptionException
     *         The delete inventory option specified isn't valid. Verify the option and try again.
     * @throws InvalidDeleteInventoryParametersException
     *         One or more of the parameters specified for the delete operation isn't valid. Verify all parameters and
     *         try again.
     * @throws InvalidInventoryRequestException
     *         The request isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteInventoryResponse deleteInventory(DeleteInventoryRequest deleteInventoryRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidOptionException,
            InvalidDeleteInventoryParametersException, InvalidInventoryRequestException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInventoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteInventoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInventoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInventory");

            return clientHandler.execute(new ClientExecutionParams<DeleteInventoryRequest, DeleteInventoryResponse>()
                    .withOperationName("DeleteInventory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteInventoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInventoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return Result of the DeleteMaintenanceWindow operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteMaintenanceWindowResponse deleteMaintenanceWindow(DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMaintenanceWindowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMaintenanceWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMaintenanceWindowRequest, DeleteMaintenanceWindowResponse>()
                            .withOperationName("DeleteMaintenanceWindow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an OpsItem. You must have permission in Identity and Access Management (IAM) to delete an OpsItem.
     * </p>
     * <important>
     * <p>
     * Note the following important information about this operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Deleting an OpsItem is irreversible. You can't restore a deleted OpsItem.
     * </p>
     * </li>
     * <li>
     * <p>
     * This operation uses an <i>eventual consistency model</i>, which means the system can take a few minutes to
     * complete this operation. If you delete an OpsItem and immediately call, for example, <a>GetOpsItem</a>, the
     * deleted OpsItem might still appear in the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * This operation is idempotent. The system doesn't throw an exception if you repeatedly call this operation for the
     * same OpsItem. If the first call is successful, all additional calls return the same successful response as the
     * first call.
     * </p>
     * </li>
     * <li>
     * <p>
     * This operation doesn't support cross-account calls. A delegated administrator or management account can't delete
     * OpsItems in other accounts, even if OpsCenter has been set up for cross-account administration. For more
     * information about cross-account administration, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setting-up-cross-account.html"
     * >Setting up OpsCenter to centrally manage OpsItems across accounts</a> in the <i>Systems Manager User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param deleteOpsItemRequest
     * @return Result of the DeleteOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteOpsItemResponse deleteOpsItem(DeleteOpsItemRequest deleteOpsItemRequest) throws InternalServerErrorException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOpsItemResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOpsItemRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOpsItem");

            return clientHandler.execute(new ClientExecutionParams<DeleteOpsItemRequest, DeleteOpsItemResponse>()
                    .withOperationName("DeleteOpsItem").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOpsItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOpsItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     *
     * @param deleteOpsMetadataRequest
     * @return Result of the DeleteOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object doesn't exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteOpsMetadataResponse deleteOpsMetadata(DeleteOpsMetadataRequest deleteOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOpsMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOpsMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<DeleteOpsMetadataRequest, DeleteOpsMetadataResponse>()
                    .withOperationName("DeleteOpsMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a
     * parameter with the same name.
     * </p>
     *
     * @param deleteParameterRequest
     * @return Result of the DeleteParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.</p> <note>
     *         <p>
     *         For the <code>DeleteParameter</code> and <code>GetParameter</code> actions, if the specified parameter
     *         doesn't exist, the <code>ParameterNotFound</code> exception is <i>not</i> recorded in CloudTrail event
     *         logs.
     *         </p>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteParameterResponse deleteParameter(DeleteParameterRequest deleteParameterRequest)
            throws InternalServerErrorException, ParameterNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteParameterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteParameterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteParameterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameter");

            return clientHandler.execute(new ClientExecutionParams<DeleteParameterRequest, DeleteParameterResponse>()
                    .withOperationName("DeleteParameter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteParameterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteParameterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with
     * the same name.
     * </p>
     *
     * @param deleteParametersRequest
     * @return Result of the DeleteParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteParametersResponse deleteParameters(DeleteParametersRequest deleteParametersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteParametersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteParametersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "TargetNotConnected":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetNotConnected").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetNotConnectedException::builder).build());
            case "ItemSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build());
            case "InvalidParameters":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameters").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParametersException::builder).build());
            case "ParameterMaxVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build());
            case "PoliciesLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build());
            case "InvalidKeyId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKeyId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKeyIdException::builder).build());
            case "InvalidFilter":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilter").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterException::builder).build());
            case "AssociationExecutionDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build());
            case "OpsItemLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build());
            case "InvalidSchedule":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSchedule").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidScheduleException::builder).build());
            case "UnsupportedInventorySchemaVersionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder)
                        .build());
            case "ResourceDataSyncAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidPluginName":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPluginName").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPluginNameException::builder).build());
            case "HierarchyTypeMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build());
            case "FeatureNotAvailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FeatureNotAvailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build());
            case "InvalidNextToken":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextToken").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceDataSyncInvalidConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder)
                        .build());
            case "InvalidActivationId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivationId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationIdException::builder).build());
            case "InvocationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvocationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build());
            case "MalformedResourcePolicyDocumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedResourcePolicyDocumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MalformedResourcePolicyDocumentException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "OpsItemInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build());
            case "AlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AlreadyExistsException::builder).build());
            case "OpsMetadataTooManyUpdatesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "SubTypeCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "InvalidResourceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceIdException::builder).build());
            case "ResourcePolicyConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyConflictException::builder).build());
            case "ParameterVersionNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build());
            case "ServiceSettingNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceSettingNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "InvalidDocument":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocument").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentException::builder).build());
            case "InvalidDocumentVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build());
            case "InvalidOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOptionException::builder).build());
            case "InvalidDocumentOperation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentOperation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build());
            case "ResourceDataSyncCountExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ComplianceTypeCountLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder)
                                .build());
            case "InvalidResourceType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build());
            case "UnsupportedFeatureRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build());
            case "AutomationDefinitionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build());
            case "InvalidInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build());
            case "ItemContentMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ItemContentMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ItemContentMismatchException::builder).build());
            case "ResourceDataSyncNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build());
            case "OpsItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build());
            case "DuplicateInstanceId":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateInstanceId").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build());
            case "InvalidTag":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTag").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagException::builder).build());
            case "InvalidDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build());
            case "AutomationExecutionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build());
            case "UnsupportedCalendarException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedCalendarException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build());
            case "AssociationLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build());
            case "OpsMetadataKeyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build());
            case "ResourceDataSyncConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build());
            case "InvalidInventoryGroupException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build());
            case "AssociationVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build());
            case "InvalidTarget":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTarget").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "OpsMetadataInvalidArgumentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build());
            case "AutomationStepNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build());
            case "InvalidFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterValue").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterValueException::builder).build());
            case "ResourcePolicyLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyLimitExceededException::builder).build());
            case "DocumentVersionLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build());
            case "InvalidItemContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidItemContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidItemContentException::builder).build());
            case "TooManyTagsError":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsError").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build());
            case "UnsupportedParameterType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedParameterType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build());
            case "InvalidAggregatorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAggregatorException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAggregatorException::builder).build());
            case "UnsupportedInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build());
            case "InvalidPolicyAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build());
            case "IncompatiblePolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatiblePolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build());
            case "InvalidUpdate":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidUpdate").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidUpdateException::builder).build());
            case "AssociationAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build());
            case "DuplicateDocumentContent":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentContent").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build());
            case "InvalidDocumentSchemaVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build());
            case "ResourcePolicyInvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyInvalidParameterException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ResourcePolicyInvalidParameterException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidInventoryItemContextException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build());
            case "InvalidAssociation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationException::builder).build());
            case "InvalidAutomationSignalException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build());
            case "InvalidTargetMaps":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetMaps").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetMapsException::builder).build());
            case "InvalidDocumentType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDocumentType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build());
            case "IdempotentParameterMismatch":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                        .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
            case "InvalidInventoryRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build());
            case "InvalidResultAttributeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultAttributeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build());
            case "AutomationDefinitionVersionNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder)
                        .build());
            case "InvalidAutomationExecutionParametersException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder)
                        .build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "InvalidAllowedPatternException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build());
            case "InvalidInstancePropertyFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstancePropertyFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstancePropertyFilterValueException::builder)
                        .build());
            case "OpsItemNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build());
            case "InvalidDeleteInventoryParametersException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder)
                                .build());
            case "InvalidPermissionType":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPermissionType").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build());
            case "UnsupportedOperatingSystem":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build());
            case "OpsMetadataAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build());
            case "InvalidOutputFolder":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputFolder").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build());
            case "OpsItemRelatedItemAssociationNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder)
                        .build());
            case "AutomationExecutionLimitExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder)
                                .build());
            case "DuplicateDocumentVersionName":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName").httpStatusCode(400)
                        .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build());
            case "InvalidNotificationConfig":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNotificationConfig").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build());
            case "InvalidCommandId":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommandId").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommandIdException::builder).build());
            case "ParameterNotFound":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterNotFound").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterNotFoundException::builder).build());
            case "ParameterVersionLabelLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                        .httpStatusCode(400).exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder)
                        .build());
            case "DocumentPermissionLimit":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentPermissionLimit").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build());
            case "DocumentLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build());
            case "HierarchyLevelLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build());
            case "TotalSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build());
            case "OpsMetadataLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build());
            case "InvalidActivation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActivation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActivationException::builder).build());
            case "OpsItemRelatedItemAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build());
            case "TooManyUpdates":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyUpdates").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyUpdatesException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "OpsMetadataNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build());
            case "DocumentAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("DocumentAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build());
            case "AutomationDefinitionNotApprovedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build());
            case "InvalidInstanceInformationFilterValue":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder)
                        .build());
            case "InvalidAssociationVersion":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAssociationVersion").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build());
            case "StatusUnchanged":
                return Optional.of(ExceptionMetadata.builder().errorCode("StatusUnchanged").httpStatusCode(400)
                        .exceptionBuilderSupplier(StatusUnchangedException::builder).build());
            case "TargetInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetInUseException::builder).build());
            case "AssociationDoesNotExist":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociationDoesNotExist").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build());
            case "UnsupportedPlatformType":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPlatformType").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build());
            case "MaxDocumentSizeExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build());
            case "InvalidRole":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRole").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRoleException::builder).build());
            case "InvalidDeletionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build());
            case "OpsItemAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemAccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemAccessDeniedException::builder).build());
            case "AssociatedInstances":
                return Optional.of(ExceptionMetadata.builder().errorCode("AssociatedInstances").httpStatusCode(400)
                        .exceptionBuilderSupplier(AssociatedInstancesException::builder).build());
            case "InvalidOutputLocation":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOutputLocation").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build());
            case "InvalidPolicyTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build());
            case "ParameterLimitExceeded":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterLimitExceeded").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build());
            case "InvalidTypeNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTypeNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTypeNameException::builder).build());
            case "InvalidAutomationStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build());
            case "OpsItemConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OpsItemConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OpsItemConflictException::builder).build());
            case "DoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DoesNotExistException::builder).build());
            case "InvalidFilterOption":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterOption").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build());
            case "CustomSchemaCountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build());
            case "ParameterPatternMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build());
            case "ParameterAlreadyExists":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParameterAlreadyExists").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build());
            case "InvalidFilterKey":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilterKey").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build());
            case "InternalServerError":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerError").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteParametersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameters");

            return clientHandler.execute(new ClientExecutionParams<DeleteParametersRequest, DeleteParametersResponse>()
                    .withOperationName("DeleteParameters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return Result of the DeletePatchBaseline operation returned by the service.
     * @throws ResourceInUseException
     *         Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePatchBaselineResponse deletePatchBaseline(DeletePatchBaselineRequest deletePatchBaselineRequest)
            throws ResourceInUseException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePatchBaselineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = error