/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more aggregators for viewing counts of OpsData using different dimensions such as <code>Source</code>,
 * <code>CreatedTime</code>, or <code>Source and CreatedTime</code>, to name a few.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsAggregator implements SdkPojo, Serializable, ToCopyableBuilder<OpsAggregator.Builder, OpsAggregator> {
    private static final SdkField<String> AGGREGATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregatorType").getter(getter(OpsAggregator::aggregatorType)).setter(setter(Builder::aggregatorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorType").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(OpsAggregator::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(OpsAggregator::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<Map<String, String>> VALUES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Values")
            .getter(getter(OpsAggregator::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<OpsFilter>> FILTERS_FIELD = SdkField
            .<List<OpsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(OpsAggregator::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OpsAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<OpsAggregator>> builder(MarshallingType.LIST)
            .memberName("Aggregators")
            .getter(getter(OpsAggregator::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_TYPE_FIELD,
            TYPE_NAME_FIELD, ATTRIBUTE_NAME_FIELD, VALUES_FIELD, FILTERS_FIELD, AGGREGATORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aggregatorType;

    private final String typeName;

    private final String attributeName;

    private final Map<String, String> values;

    private final List<OpsFilter> filters;

    private final List<OpsAggregator> aggregators;

    private OpsAggregator(BuilderImpl builder) {
        this.aggregatorType = builder.aggregatorType;
        this.typeName = builder.typeName;
        this.attributeName = builder.attributeName;
        this.values = builder.values;
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
    }

    /**
     * <p>
     * Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData summary.
     * </p>
     * 
     * @return Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData summary.
     */
    public final String aggregatorType() {
        return aggregatorType;
    }

    /**
     * <p>
     * The data type name to use for viewing counts of OpsData.
     * </p>
     * 
     * @return The data type name to use for viewing counts of OpsData.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The name of an OpsData attribute on which to limit the count of OpsData.
     * </p>
     * 
     * @return The name of an OpsData attribute on which to limit the count of OpsData.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The aggregator value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The aggregator value.
     */
    public final Map<String, String> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregator filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The aggregator filters.
     */
    public final List<OpsFilter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregators() {
        return aggregators != null && !(aggregators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A nested aggregator for viewing counts of OpsData.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregators} method.
     * </p>
     * 
     * @return A nested aggregator for viewing counts of OpsData.
     */
    public final List<OpsAggregator> aggregators() {
        return aggregators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregatorType());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregators() ? aggregators() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsAggregator)) {
            return false;
        }
        OpsAggregator other = (OpsAggregator) obj;
        return Objects.equals(aggregatorType(), other.aggregatorType()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(attributeName(), other.attributeName()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && hasAggregators() == other.hasAggregators()
                && Objects.equals(aggregators(), other.aggregators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpsAggregator").add("AggregatorType", aggregatorType()).add("TypeName", typeName())
                .add("AttributeName", attributeName()).add("Values", hasValues() ? values() : null)
                .add("Filters", hasFilters() ? filters() : null).add("Aggregators", hasAggregators() ? aggregators() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregatorType":
            return Optional.ofNullable(clazz.cast(aggregatorType()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregatorType", AGGREGATOR_TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Aggregators", AGGREGATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpsAggregator, T> g) {
        return obj -> g.apply((OpsAggregator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsAggregator> {
        /**
         * <p>
         * Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData summary.
         * </p>
         * 
         * @param aggregatorType
         *        Either a <code>Range</code> or <code>Count</code> aggregator for limiting an OpsData summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorType(String aggregatorType);

        /**
         * <p>
         * The data type name to use for viewing counts of OpsData.
         * </p>
         * 
         * @param typeName
         *        The data type name to use for viewing counts of OpsData.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The name of an OpsData attribute on which to limit the count of OpsData.
         * </p>
         * 
         * @param attributeName
         *        The name of an OpsData attribute on which to limit the count of OpsData.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The aggregator value.
         * </p>
         * 
         * @param values
         *        The aggregator value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Map<String, String> values);

        /**
         * <p>
         * The aggregator filters.
         * </p>
         * 
         * @param filters
         *        The aggregator filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OpsFilter> filters);

        /**
         * <p>
         * The aggregator filters.
         * </p>
         * 
         * @param filters
         *        The aggregator filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OpsFilter... filters);

        /**
         * <p>
         * The aggregator filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.OpsFilter.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ssm.model.OpsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.OpsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<OpsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.OpsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<OpsFilter>)
         */
        Builder filters(Consumer<OpsFilter.Builder>... filters);

        /**
         * <p>
         * A nested aggregator for viewing counts of OpsData.
         * </p>
         * 
         * @param aggregators
         *        A nested aggregator for viewing counts of OpsData.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<OpsAggregator> aggregators);

        /**
         * <p>
         * A nested aggregator for viewing counts of OpsData.
         * </p>
         * 
         * @param aggregators
         *        A nested aggregator for viewing counts of OpsData.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(OpsAggregator... aggregators);

        /**
         * <p>
         * A nested aggregator for viewing counts of OpsData.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssm.model.OpsAggregator.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssm.model.OpsAggregator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssm.model.OpsAggregator.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregators(List<OpsAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssm.model.OpsAggregator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(java.util.Collection<OpsAggregator>)
         */
        Builder aggregators(Consumer<Builder>... aggregators);
    }

    static final class BuilderImpl implements Builder {
        private String aggregatorType;

        private String typeName;

        private String attributeName;

        private Map<String, String> values = DefaultSdkAutoConstructMap.getInstance();

        private List<OpsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<OpsAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpsAggregator model) {
            aggregatorType(model.aggregatorType);
            typeName(model.typeName);
            attributeName(model.attributeName);
            values(model.values);
            filters(model.filters);
            aggregators(model.aggregators);
        }

        public final String getAggregatorType() {
            return aggregatorType;
        }

        public final void setAggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
        }

        @Override
        public final Builder aggregatorType(String aggregatorType) {
            this.aggregatorType = aggregatorType;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Map<String, String> getValues() {
            if (values instanceof SdkAutoConstructMap) {
                return null;
            }
            return values;
        }

        public final void setValues(Map<String, String> values) {
            this.values = OpsAggregatorValueMapCopier.copy(values);
        }

        @Override
        public final Builder values(Map<String, String> values) {
            this.values = OpsAggregatorValueMapCopier.copy(values);
            return this;
        }

        public final List<OpsFilter.Builder> getFilters() {
            List<OpsFilter.Builder> result = OpsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OpsFilter.BuilderImpl> filters) {
            this.filters = OpsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<OpsFilter> filters) {
            this.filters = OpsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(OpsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<OpsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OpsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAggregators() {
            List<Builder> result = OpsAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<BuilderImpl> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        public final Builder aggregators(Collection<OpsAggregator> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(OpsAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> OpsAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OpsAggregator build() {
            return new OpsAggregator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
