/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInventorySchemaRequest extends SsmRequest implements
        ToCopyableBuilder<GetInventorySchemaRequest.Builder, GetInventorySchemaRequest> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(GetInventorySchemaRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetInventorySchemaRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetInventorySchemaRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Boolean> AGGREGATOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Aggregator").getter(getter(GetInventorySchemaRequest::aggregator)).setter(setter(Builder::aggregator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregator").build()).build();

    private static final SdkField<Boolean> SUB_TYPE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SubType").getter(getter(GetInventorySchemaRequest::subType)).setter(setter(Builder::subType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, AGGREGATOR_FIELD, SUB_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String typeName;

    private final String nextToken;

    private final Integer maxResults;

    private final Boolean aggregator;

    private final Boolean subType;

    private GetInventorySchemaRequest(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.aggregator = builder.aggregator;
        this.subType = builder.subType;
    }

    /**
     * <p>
     * The type of inventory item to return.
     * </p>
     * 
     * @return The type of inventory item to return.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Returns inventory schemas that support aggregation. For example, this call returns the
     * <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
     * </p>
     * 
     * @return Returns inventory schemas that support aggregation. For example, this call returns the
     *         <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
     *         <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
     */
    public final Boolean aggregator() {
        return aggregator;
    }

    /**
     * <p>
     * Returns the sub-type schema for a specified inventory type.
     * </p>
     * 
     * @return Returns the sub-type schema for a specified inventory type.
     */
    public final Boolean subType() {
        return subType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(aggregator());
        hashCode = 31 * hashCode + Objects.hashCode(subType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventorySchemaRequest)) {
            return false;
        }
        GetInventorySchemaRequest other = (GetInventorySchemaRequest) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(aggregator(), other.aggregator())
                && Objects.equals(subType(), other.subType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInventorySchemaRequest").add("TypeName", typeName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Aggregator", aggregator()).add("SubType", subType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Aggregator":
            return Optional.ofNullable(clazz.cast(aggregator()));
        case "SubType":
            return Optional.ofNullable(clazz.cast(subType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Aggregator", AGGREGATOR_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInventorySchemaRequest, T> g) {
        return obj -> g.apply((GetInventorySchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInventorySchemaRequest> {
        /**
         * <p>
         * The type of inventory item to return.
         * </p>
         * 
         * @param typeName
         *        The type of inventory item to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Returns inventory schemas that support aggregation. For example, this call returns the
         * <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
         * <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
         * </p>
         * 
         * @param aggregator
         *        Returns inventory schemas that support aggregation. For example, this call returns the
         *        <code>AWS:InstanceInformation</code> type, because it supports aggregation based on the
         *        <code>PlatformName</code>, <code>PlatformType</code>, and <code>PlatformVersion</code> attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregator(Boolean aggregator);

        /**
         * <p>
         * Returns the sub-type schema for a specified inventory type.
         * </p>
         * 
         * @param subType
         *        Returns the sub-type schema for a specified inventory type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subType(Boolean subType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String typeName;

        private String nextToken;

        private Integer maxResults;

        private Boolean aggregator;

        private Boolean subType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventorySchemaRequest model) {
            super(model);
            typeName(model.typeName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            aggregator(model.aggregator);
            subType(model.subType);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Boolean getAggregator() {
            return aggregator;
        }

        public final void setAggregator(Boolean aggregator) {
            this.aggregator = aggregator;
        }

        @Override
        public final Builder aggregator(Boolean aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public final Boolean getSubType() {
            return subType;
        }

        public final void setSubType(Boolean subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(Boolean subType) {
            this.subType = subType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInventorySchemaRequest build() {
            return new GetInventorySchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
