/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OpsItemStatus {
    OPEN("Open"),

    IN_PROGRESS("InProgress"),

    RESOLVED("Resolved"),

    PENDING("Pending"),

    TIMED_OUT("TimedOut"),

    CANCELLING("Cancelling"),

    CANCELLED("Cancelled"),

    FAILED("Failed"),

    COMPLETED_WITH_SUCCESS("CompletedWithSuccess"),

    COMPLETED_WITH_FAILURE("CompletedWithFailure"),

    SCHEDULED("Scheduled"),

    RUNBOOK_IN_PROGRESS("RunbookInProgress"),

    PENDING_CHANGE_CALENDAR_OVERRIDE("PendingChangeCalendarOverride"),

    CHANGE_CALENDAR_OVERRIDE_APPROVED("ChangeCalendarOverrideApproved"),

    CHANGE_CALENDAR_OVERRIDE_REJECTED("ChangeCalendarOverrideRejected"),

    PENDING_APPROVAL("PendingApproval"),

    APPROVED("Approved"),

    REVOKED("Revoked"),

    REJECTED("Rejected"),

    CLOSED("Closed"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OpsItemStatus> VALUE_MAP = EnumUtils.uniqueIndex(OpsItemStatus.class,
            OpsItemStatus::toString);

    private final String value;

    private OpsItemStatus(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OpsItemStatus corresponding to the value
     */
    public static OpsItemStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OpsItemStatus}s
     */
    public static Set<OpsItemStatus> knownValues() {
        Set<OpsItemStatus> knownValues = EnumSet.allOf(OpsItemStatus.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
