/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilter;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterListCopier;
import software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilter;
import software.amazon.awssdk.services.ssm.model.InstanceInformationStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceInformationRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribeInstanceInformationRequest> {
    private static final SdkField<List<InstanceInformationFilter>> INSTANCE_INFORMATION_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceInformationFilterList").getter(DescribeInstanceInformationRequest.getter(DescribeInstanceInformationRequest::instanceInformationFilterList)).setter(DescribeInstanceInformationRequest.setter(Builder::instanceInformationFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInformationFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceInformationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceInformationStringFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeInstanceInformationRequest.getter(DescribeInstanceInformationRequest::filters)).setter(DescribeInstanceInformationRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceInformationStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeInstanceInformationRequest.getter(DescribeInstanceInformationRequest::maxResults)).setter(DescribeInstanceInformationRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceInformationRequest.getter(DescribeInstanceInformationRequest::nextToken)).setter(DescribeInstanceInformationRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_INFORMATION_FILTER_LIST_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInstanceInformationRequest.memberNameToFieldInitializer();
    private final List<InstanceInformationFilter> instanceInformationFilterList;
    private final List<InstanceInformationStringFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeInstanceInformationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceInformationFilterList = builder.instanceInformationFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInstanceInformationFilterList() {
        return this.instanceInformationFilterList != null && !(this.instanceInformationFilterList instanceof SdkAutoConstructList);
    }

    public final List<InstanceInformationFilter> instanceInformationFilterList() {
        return this.instanceInformationFilterList;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<InstanceInformationStringFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceInformationFilterList() ? this.instanceInformationFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationRequest)) {
            return false;
        }
        DescribeInstanceInformationRequest other = (DescribeInstanceInformationRequest)((Object)obj);
        return this.hasInstanceInformationFilterList() == other.hasInstanceInformationFilterList() && Objects.equals(this.instanceInformationFilterList(), other.instanceInformationFilterList()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceInformationRequest").add("InstanceInformationFilterList", this.hasInstanceInformationFilterList() ? this.instanceInformationFilterList() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceInformationFilterList": {
                return Optional.ofNullable(clazz.cast(this.instanceInformationFilterList()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceInformationFilterList", INSTANCE_INFORMATION_FILTER_LIST_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceInformationRequest, T> g) {
        return obj -> g.apply((DescribeInstanceInformationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<InstanceInformationFilter> instanceInformationFilterList = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceInformationStringFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationRequest model) {
            super(model);
            this.instanceInformationFilterList(model.instanceInformationFilterList);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<InstanceInformationFilter.Builder> getInstanceInformationFilterList() {
            List<InstanceInformationFilter.Builder> result = InstanceInformationFilterListCopier.copyToBuilder(this.instanceInformationFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInformationFilterList(Collection<InstanceInformationFilter.BuilderImpl> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copyFromBuilder(instanceInformationFilterList);
        }

        @Override
        public final Builder instanceInformationFilterList(Collection<InstanceInformationFilter> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copy(instanceInformationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationFilterList(InstanceInformationFilter ... instanceInformationFilterList) {
            this.instanceInformationFilterList(Arrays.asList(instanceInformationFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationFilterList(Consumer<InstanceInformationFilter.Builder> ... instanceInformationFilterList) {
            this.instanceInformationFilterList(Stream.of(instanceInformationFilterList).map(c -> (InstanceInformationFilter)((InstanceInformationFilter.Builder)InstanceInformationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceInformationStringFilter.Builder> getFilters() {
            List<InstanceInformationStringFilter.Builder> result = InstanceInformationStringFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<InstanceInformationStringFilter.BuilderImpl> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<InstanceInformationStringFilter> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InstanceInformationStringFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InstanceInformationStringFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (InstanceInformationStringFilter)((InstanceInformationStringFilter.Builder)InstanceInformationStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceInformationRequest build() {
            return new DescribeInstanceInformationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceInformationRequest> {
        public Builder instanceInformationFilterList(Collection<InstanceInformationFilter> var1);

        public Builder instanceInformationFilterList(InstanceInformationFilter ... var1);

        public Builder instanceInformationFilterList(Consumer<InstanceInformationFilter.Builder> ... var1);

        public Builder filters(Collection<InstanceInformationStringFilter> var1);

        public Builder filters(InstanceInformationStringFilter ... var1);

        public Builder filters(Consumer<InstanceInformationStringFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

