/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelParameterVersionRequest extends SsmRequest implements
        ToCopyableBuilder<LabelParameterVersionRequest.Builder, LabelParameterVersionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LabelParameterVersionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Long> PARAMETER_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(LabelParameterVersionRequest::parameterVersion)).setter(setter(Builder::parameterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterVersion").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(LabelParameterVersionRequest::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PARAMETER_VERSION_FIELD, LABELS_FIELD));

    private final String name;

    private final Long parameterVersion;

    private final List<String> labels;

    private LabelParameterVersionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.parameterVersion = builder.parameterVersion;
        this.labels = builder.labels;
    }

    /**
     * <p>
     * The parameter name on which you want to attach one or more labels.
     * </p>
     * 
     * @return The parameter name on which you want to attach one or more labels.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The specific version of the parameter on which you want to attach one or more labels. If no version is specified,
     * the system attaches the label to the latest version.)
     * </p>
     * 
     * @return The specific version of the parameter on which you want to attach one or more labels. If no version is
     *         specified, the system attaches the label to the latest version.)
     */
    public Long parameterVersion() {
        return parameterVersion;
    }

    /**
     * <p>
     * One or more labels to attach to the specified parameter version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more labels to attach to the specified parameter version.
     */
    public List<String> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parameterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(labels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelParameterVersionRequest)) {
            return false;
        }
        LabelParameterVersionRequest other = (LabelParameterVersionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(parameterVersion(), other.parameterVersion())
                && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LabelParameterVersionRequest").add("Name", name()).add("ParameterVersion", parameterVersion())
                .add("Labels", labels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParameterVersion":
            return Optional.ofNullable(clazz.cast(parameterVersion()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelParameterVersionRequest, T> g) {
        return obj -> g.apply((LabelParameterVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, LabelParameterVersionRequest> {
        /**
         * <p>
         * The parameter name on which you want to attach one or more labels.
         * </p>
         * 
         * @param name
         *        The parameter name on which you want to attach one or more labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The specific version of the parameter on which you want to attach one or more labels. If no version is
         * specified, the system attaches the label to the latest version.)
         * </p>
         * 
         * @param parameterVersion
         *        The specific version of the parameter on which you want to attach one or more labels. If no version is
         *        specified, the system attaches the label to the latest version.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterVersion(Long parameterVersion);

        /**
         * <p>
         * One or more labels to attach to the specified parameter version.
         * </p>
         * 
         * @param labels
         *        One or more labels to attach to the specified parameter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * One or more labels to attach to the specified parameter version.
         * </p>
         * 
         * @param labels
         *        One or more labels to attach to the specified parameter version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String name;

        private Long parameterVersion;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelParameterVersionRequest model) {
            super(model);
            name(model.name);
            parameterVersion(model.parameterVersion);
            labels(model.labels);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getParameterVersion() {
            return parameterVersion;
        }

        @Override
        public final Builder parameterVersion(Long parameterVersion) {
            this.parameterVersion = parameterVersion;
            return this;
        }

        public final void setParameterVersion(Long parameterVersion) {
            this.parameterVersion = parameterVersion;
        }

        public final Collection<String> getLabels() {
            return labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ParameterLabelListCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ParameterLabelListCopier.copy(labels);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public LabelParameterVersionRequest build() {
            return new LabelParameterVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
