/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommandInvocationRequest extends SsmRequest implements
        ToCopyableBuilder<GetCommandInvocationRequest.Builder, GetCommandInvocationRequest> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationRequest::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> PLUGIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetCommandInvocationRequest::pluginName)).setter(setter(Builder::pluginName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            INSTANCE_ID_FIELD, PLUGIN_NAME_FIELD));

    private final String commandId;

    private final String instanceId;

    private final String pluginName;

    private GetCommandInvocationRequest(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.pluginName = builder.pluginName;
    }

    /**
     * <p>
     * (Required) The parent command ID of the invocation plugin.
     * </p>
     * 
     * @return (Required) The parent command ID of the invocation plugin.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * (Required) The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2
     * instance or an instance in your hybrid environment that is configured for Systems Manager.
     * </p>
     * 
     * @return (Required) The ID of the managed instance targeted by the command. A managed instance can be an Amazon
     *         EC2 instance or an instance in your hybrid environment that is configured for Systems Manager.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * (Optional) The name of the plugin for which you want detailed results. If the document contains only one plugin,
     * the name can be omitted and the details will be returned.
     * </p>
     * 
     * @return (Optional) The name of the plugin for which you want detailed results. If the document contains only one
     *         plugin, the name can be omitted and the details will be returned.
     */
    public String pluginName() {
        return pluginName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(pluginName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationRequest)) {
            return false;
        }
        GetCommandInvocationRequest other = (GetCommandInvocationRequest) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(pluginName(), other.pluginName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCommandInvocationRequest").add("CommandId", commandId()).add("InstanceId", instanceId())
                .add("PluginName", pluginName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PluginName":
            return Optional.ofNullable(clazz.cast(pluginName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommandInvocationRequest, T> g) {
        return obj -> g.apply((GetCommandInvocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCommandInvocationRequest> {
        /**
         * <p>
         * (Required) The parent command ID of the invocation plugin.
         * </p>
         * 
         * @param commandId
         *        (Required) The parent command ID of the invocation plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * (Required) The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2
         * instance or an instance in your hybrid environment that is configured for Systems Manager.
         * </p>
         * 
         * @param instanceId
         *        (Required) The ID of the managed instance targeted by the command. A managed instance can be an Amazon
         *        EC2 instance or an instance in your hybrid environment that is configured for Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * (Optional) The name of the plugin for which you want detailed results. If the document contains only one
         * plugin, the name can be omitted and the details will be returned.
         * </p>
         * 
         * @param pluginName
         *        (Optional) The name of the plugin for which you want detailed results. If the document contains only
         *        one plugin, the name can be omitted and the details will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginName(String pluginName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private String pluginName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationRequest model) {
            super(model);
            commandId(model.commandId);
            instanceId(model.instanceId);
            pluginName(model.pluginName);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPluginName() {
            return pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCommandInvocationRequest build() {
            return new GetCommandInvocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
