/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a patch filter.
 * </p>
 * <p>
 * A patch filter consists of key/value pairs, but not all keys are valid for all operating system types. For example,
 * the key <code>PRODUCT</code> is valid for all supported operating system types. The key <code>MSRC_SEVERITY</code>,
 * however, is valid only for Windows operating systems, and the key <code>SECTION</code> is valid only for Ubuntu
 * operating systems.
 * </p>
 * <p>
 * Refer to the following sections for information about which keys may be used with each major operating system, and
 * which values are valid for each key.
 * </p>
 * <p>
 * <b>Windows Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for Windows operating systems are <code>PRODUCT</code>, <code>CLASSIFICATION</code>, and
 * <code>MSRC_SEVERITY</code>. See the following lists for valid values for each of these keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Windows7</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Windows8</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Windows8.1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Windows8Embedded</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Windows10</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Windows10LTSB</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WindowsServer2008</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WindowsServer2008R2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WindowsServer2012</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WindowsServer2012R2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>WindowsServer2016</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>CLASSIFICATION</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>CriticalUpdates</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DefinitionUpdates</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Drivers</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>FeaturePacks</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SecurityUpdates</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ServicePacks</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Tools</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateRollups</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Updates</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Upgrades</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>MSRC_SEVERITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Critical</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Moderate</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Low</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Unspecified</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Ubuntu Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for Ubuntu operating systems are <code>PRODUCT</code>, <code>PRIORITY</code>, and
 * <code>SECTION</code>. See the following lists for valid values for each of these keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Ubuntu14.04</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Ubuntu16.04</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>PRIORITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Required</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Standard</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Optional</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Extra</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>SECTION</code>
 * </p>
 * <p>
 * Only the length of the key value is validated. Minimum length is 1. Maximum length is 64.
 * </p>
 * <p>
 * <b>Amazon Linux Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for Amazon Linux operating systems are <code>PRODUCT</code>, <code>CLASSIFICATION</code>, and
 * <code>SEVERITY</code>. See the following lists for valid values for each of these keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>AmazonLinux2012.03</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2012.09</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2013.03</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2013.09</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2014.03</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2014.09</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2015.03</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2015.09</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2016.03</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2016.09</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2017.03</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2017.09</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>CLASSIFICATION</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Security</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Bugfix</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Enhancement</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Recommended</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Newpackage</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>SEVERITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Critical</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Medium</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Low</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Amazon Linux 2 Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for Amazon Linux 2 operating systems are <code>PRODUCT</code>, <code>CLASSIFICATION</code>, and
 * <code>SEVERITY</code>. See the following lists for valid values for each of these keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>AmazonLinux2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AmazonLinux2.0</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>CLASSIFICATION</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Security</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Bugfix</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Enhancement</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Recommended</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Newpackage</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>SEVERITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Critical</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Medium</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Low</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>RedHat Enterprise Linux (RHEL) Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for RedHat Enterprise Linux operating systems are <code>PRODUCT</code>,
 * <code>CLASSIFICATION</code>, and <code>SEVERITY</code>. See the following lists for valid values for each of these
 * keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux6.5</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux6.6</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux6.7</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux6.8</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux6.9</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux7.0</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux7.1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux7.2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux7.3</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RedhatEnterpriseLinux7.4</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>CLASSIFICATION</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Security</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Bugfix</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Enhancement</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Recommended</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Newpackage</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>SEVERITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Critical</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Medium</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Low</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>SUSE Linux Enterprise Server (SLES) Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for SLES operating systems are <code>PRODUCT</code>, <code>CLASSIFICATION</code>, and
 * <code>SEVERITY</code>. See the following lists for valid values for each of these keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Suse12.0</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.3</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.4</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.5</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.6</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.7</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.8</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Suse12.9</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>CLASSIFICATION</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Security</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Recommended</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Optional</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Feature</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Document</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Yast</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>SEVERITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Critical</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Moderate</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Low</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>CentOS Operating Systems</b>
 * </p>
 * <p>
 * The supported keys for CentOS operating systems are <code>PRODUCT</code>, <code>CLASSIFICATION</code>, and
 * <code>SEVERITY</code>. See the following lists for valid values for each of these keys.
 * </p>
 * <p>
 * <i>Supported key:</i> <code>PRODUCT</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>CentOS6.5</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS6.6</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS6.7</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS6.8</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS6.9</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS7.0</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS7.1</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS7.2</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS7.3</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CentOS7.4</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>*</code>
 * </p>
 * <p>
 * <i>Use a wildcard character (*) to target all supported operating system versions.</i>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>CLASSIFICATION</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Security</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Bugfix</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Enhancement</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Recommended</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Newpackage</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * <i>Supported key:</i> <code>SEVERITY</code>
 * </p>
 * <p>
 * <i>Supported values:</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Critical</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Important</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Medium</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>Low</code>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchFilter implements SdkPojo, Serializable, ToCopyableBuilder<PatchFilter.Builder, PatchFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PatchFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PatchFilter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private PatchFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The key for the filter.
     * </p>
     * <p>
     * See <a>PatchFilter</a> for lists of valid keys for each operating system type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link PatchFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The key for the filter.</p>
     *         <p>
     *         See <a>PatchFilter</a> for lists of valid keys for each operating system type.
     * @see PatchFilterKey
     */
    public PatchFilterKey key() {
        return PatchFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The key for the filter.
     * </p>
     * <p>
     * See <a>PatchFilter</a> for lists of valid keys for each operating system type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link PatchFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The key for the filter.</p>
     *         <p>
     *         See <a>PatchFilter</a> for lists of valid keys for each operating system type.
     * @see PatchFilterKey
     */
    public String keyAsString() {
        return key;
    }

    /**
     * <p>
     * The value for the filter key.
     * </p>
     * <p>
     * See <a>PatchFilter</a> for lists of valid values for each key based on operating system type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value for the filter key.</p>
     *         <p>
     *         See <a>PatchFilter</a> for lists of valid values for each key based on operating system type.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilter)) {
            return false;
        }
        PatchFilter other = (PatchFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PatchFilter").add("Key", keyAsString()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchFilter, T> g) {
        return obj -> g.apply((PatchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchFilter> {
        /**
         * <p>
         * The key for the filter.
         * </p>
         * <p>
         * See <a>PatchFilter</a> for lists of valid keys for each operating system type.
         * </p>
         * 
         * @param key
         *        The key for the filter.</p>
         *        <p>
         *        See <a>PatchFilter</a> for lists of valid keys for each operating system type.
         * @see PatchFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The key for the filter.
         * </p>
         * <p>
         * See <a>PatchFilter</a> for lists of valid keys for each operating system type.
         * </p>
         * 
         * @param key
         *        The key for the filter.</p>
         *        <p>
         *        See <a>PatchFilter</a> for lists of valid keys for each operating system type.
         * @see PatchFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchFilterKey
         */
        Builder key(PatchFilterKey key);

        /**
         * <p>
         * The value for the filter key.
         * </p>
         * <p>
         * See <a>PatchFilter</a> for lists of valid values for each key based on operating system type.
         * </p>
         * 
         * @param values
         *        The value for the filter key.</p>
         *        <p>
         *        See <a>PatchFilter</a> for lists of valid values for each key based on operating system type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value for the filter key.
         * </p>
         * <p>
         * See <a>PatchFilter</a> for lists of valid values for each key based on operating system type.
         * </p>
         * 
         * @param values
         *        The value for the filter key.</p>
         *        <p>
         *        See <a>PatchFilter</a> for lists of valid values for each key based on operating system type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilter model) {
            key(model.key);
            values(model.values);
        }

        public final String getKeyAsString() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(PatchFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = PatchFilterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = PatchFilterValueListCopier.copy(values);
        }

        @Override
        public PatchFilter build() {
            return new PatchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
